/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtil {
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    public static final long ONE_HOUR_MILLISECONDS = 3600000L;
    public static final long ONE_MIN_MILLISECONDS = 60000L;
    public static String dateFormatYMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static String dateFormatYMDH = "yyyy-MM-dd HH";
    public static String dateFormatYMDHMS_f = "yyyyMMddHHmmss";
    public static String dateFormatMDHM = "MM-dd HH:mm";
    public static String dateFormat = "yyyy-MM-dd HH:mm";
    public static String dateFormatYMD = "yyyy-MM-dd";
    public static String dateFormatYMDHMofChinese = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static String dateFormatYMDofChinese = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String dateFormatMDofChinese = "MM\u6708dd\u65e5";
    public static String dateFormatMofChinese = "MM\u6708";
    public static String dateFormatYM = "yyyy-MM";
    public static String dateFormatYMDHM = "yyyy-MM-dd HH:mm";
    public static String dateFormatYMDH2 = "yyyy/MM/dd HH:mm:ss";
    public static String dateFormatMD = "MM/dd";
    public static String dateFormatM_D = "MM-dd";
    public static String dateFormatM = "MM\u6708";
    public static String dateFormatD = "dd";
    public static String dateFormatM2 = "MM";
    public static String dateFormatMDHMofChinese = "MM\u6708dd\u65e5HH\u65f6mm\u5206";
    public static String dateFormatHMofChinese = "HH\u65f6mm\u5206";
    public static String dateFormatHMS = "HH:mm:ss";
    public static String dateFormatHM = "HH:mm";
    public static String dateFormatAHM = "aHH:mm";
    public static String dateFormatYMDE = "yyyy/MM/dd E";
    public static String dateFormatYMD2 = "yyyy/MM/dd";
    private static final ThreadLocal<SimpleDateFormat> dateFormater = new ThreadLocal<SimpleDateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    @SuppressLint(value={"SimpleDateFormat"})
    private static final ThreadLocal<SimpleDateFormat> dateFormater2 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static Time t;

    public static long dateToStamp(String format, String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.CHINA);
        Date date = simpleDateFormat.parse(s);
        return date.getTime();
    }

    public static String stampToDate(String format, long s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.CHINA);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String getCurDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        Date curDate = new Date(System.currentTimeMillis());
        return format.format(curDate);
    }

    public static String getTimeString() {
        return DateUtil.stampToDate("yyyy-MM-dd HH:mm:ss", DateUtil.getTimeLong());
    }

    public static long getTimeLong() {
        return System.currentTimeMillis();
    }

    public static int convertToSecond(Long time) {
        Date date = new Date();
        date.setTime(time);
        return date.getSeconds();
    }

    public static Date getDateByFormat(String strDate, String format) {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = mSimpleDateFormat.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getDateByOffset(Date date, int calendarField, int offset) {
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTime(date);
            ((Calendar)c).add(calendarField, offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c.getTime();
    }

    public static String getStringByOffset(String strDate, String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(mSimpleDateFormat.parse(strDate));
            ((Calendar)c).add(calendarField, offset);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getStringByOffset(Date date, String format, int calendarField, int offset) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(date);
            ((Calendar)c).add(calendarField, offset);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String formatDate(String before) {
        String after;
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(before);
            after = new SimpleDateFormat("MM-dd HH:mm", Locale.getDefault()).format(date);
        }
        catch (ParseException e) {
            return before;
        }
        return after;
    }

    public static String getStringByFormat(Date date, String format) {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
        String strDate = null;
        try {
            strDate = mSimpleDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getStringByFormat(String strDate, String format) {
        String mDateTime = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(mSimpleDateFormat.parse(strDate));
            SimpleDateFormat mSimpleDateFormat2 = new SimpleDateFormat(format);
            mDateTime = mSimpleDateFormat2.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getStringByFormat(long milliseconds, String format) {
        String thisDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            thisDateTime = mSimpleDateFormat.format(milliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thisDateTime;
    }

    public static String getCurrentDate(String format) {
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getCurrentDay() {
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(dateFormat);
            GregorianCalendar c = new GregorianCalendar();
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getCurrentDay2() {
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(dateFormatYMDHMS);
            GregorianCalendar c = new GregorianCalendar();
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getNextDay(int i) {
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(dateFormat);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(5, i);
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getNextHour(int i) {
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(dateFormat);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(11, i);
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getCurrentDateByOffset(String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(calendarField, offset);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getCurrentDateByOffsetYMD(String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(calendarField, offset);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static int getOffectDay(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int y1 = calendar1.get(1);
        int y2 = calendar2.get(1);
        int d1 = calendar1.get(6);
        int d2 = calendar2.get(6);
        int maxDays = 0;
        int day = 0;
        if (y1 - y2 > 0) {
            maxDays = calendar2.getActualMaximum(6);
            day = d1 - d2 + maxDays;
        } else if (y1 - y2 < 0) {
            maxDays = calendar1.getActualMaximum(6);
            day = d1 - d2 - maxDays;
        } else {
            day = d1 - d2;
        }
        return day;
    }

    public static int getOffectHour(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int h1 = calendar1.get(11);
        int h2 = calendar2.get(11);
        int h = 0;
        int day = DateUtil.getOffectDay(date1, date2);
        h = h1 - h2 + day * 24;
        return h;
    }

    public static int getOffectMinutes(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int m1 = calendar1.get(12);
        int m2 = calendar2.get(12);
        int h = DateUtil.getOffectHour(date1, date2);
        int m = 0;
        m = m1 - m2 + h * 60;
        return m;
    }

    public static int getOffectSecond(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int m1 = calendar1.get(13);
        int m2 = calendar2.get(13);
        int h = DateUtil.getOffectHour(date1, date2);
        int m = 0;
        m = m1 - m2 + h * 60 * 60;
        return m;
    }

    public static String getOffectMinutesAndSecond(long date1, long date2) {
        int interval = (int)((date1 - date2) / 1000L);
        int hour = interval / 60 / 60;
        int minute = (interval - hour * 60 * 60) / 60;
        int second = interval - hour * 60 * 60 - minute * 60;
        StringBuffer stringBuffer = new StringBuffer();
        if (hour > 0) {
            stringBuffer.append(hour > 9 ? hour + "" : "0" + hour);
        } else {
            stringBuffer.append("00");
        }
        stringBuffer.append(":").append(minute > 9 ? minute + "" : "0" + minute).append(":").append(second > 9 ? second + "" : "0" + second);
        return stringBuffer.toString();
    }

    public static String getFirstDayOfWeek(String format) {
        return DateUtil.getDayOfWeek(format, 2);
    }

    public static String getLastDayOfWeek(String format) {
        return DateUtil.getDayOfWeek(format, 1);
    }

    private static String getDayOfWeek(String format, int calendarField) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            int week = c.get(7);
            if (week == calendarField) {
                strDate = mSimpleDateFormat.format(c.getTime());
            } else {
                int offectDay = calendarField - week;
                if (calendarField == 1) {
                    offectDay = 7 - Math.abs(offectDay);
                }
                ((Calendar)c).add(5, offectDay);
                strDate = mSimpleDateFormat.format(c.getTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getFirstDayOfMonth(String format) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.set(5, 1);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getLastDayOfMonth(String format) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.set(5, 1);
            ((Calendar)c).roll(5, -1);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static long getFirstTimeOfDay() {
        Date date = null;
        try {
            String currentDate = DateUtil.getCurrentDate(dateFormatYMD);
            date = DateUtil.getDateByFormat(currentDate + " 00:00:00", dateFormatYMDHMS);
            return date.getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getLastTimeOfDay() {
        Date date = null;
        try {
            String currentDate = DateUtil.getCurrentDate(dateFormatYMD);
            date = DateUtil.getDateByFormat(currentDate + " 24:00:00", dateFormatYMDHMS);
            return date.getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 400 != 0 || year % 400 == 0;
    }

    public static String formatDateStr2Desc(String strDate, String outFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormatYMDHM);
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            String out;
            c2.setTime(df.parse(strDate));
            c1.setTime(new Date());
            int d = DateUtil.getOffectDay(c1.getTimeInMillis(), c2.getTimeInMillis());
            if (d == 0) {
                int h = DateUtil.getOffectHour(c1.getTimeInMillis(), c2.getTimeInMillis());
                if (h > 0) {
                    return h + "\u5c0f\u65f6\u524d";
                }
                if (h < 0) {
                    return Math.abs(h) + "\u5c0f\u65f6\u540e";
                }
                if (h == 0) {
                    int m = DateUtil.getOffectMinutes(c1.getTimeInMillis(), c2.getTimeInMillis());
                    if (m > 0) {
                        return m + "\u5206\u949f\u524d";
                    }
                    if (m < 0) {
                        return Math.abs(m) + "\u5206\u949f\u540e";
                    }
                    return "\u521a\u521a";
                }
            } else if (d > 0) {
                if (d == 1) {
                    return "\u6628\u5929";
                }
                if (d == 2) {
                    return "\u524d\u5929";
                }
            } else if (d < 0) {
                if (d == -1) {
                    return "\u660e\u5929";
                }
                if (d == -2) {
                    return "\u540e\u5929";
                }
                return Math.abs(d) + "\u5929\u540e";
            }
            if (!TextUtils.isEmpty((CharSequence)(out = DateUtil.getStringByFormat(strDate, outFormat)))) {
                return out;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strDate;
    }

    public static String getWeekNumber(String strDate, String inFormat) {
        String week = "\u661f\u671f\u65e5";
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat(inFormat);
        try {
            calendar.setTime(df.parse(strDate));
        }
        catch (Exception e) {
            return "\u9519\u8bef";
        }
        int intTemp = calendar.get(7) - 1;
        switch (intTemp) {
            case 0: {
                week = "\u661f\u671f\u65e5";
                break;
            }
            case 1: {
                week = "\u661f\u671f\u4e00";
                break;
            }
            case 2: {
                week = "\u661f\u671f\u4e8c";
                break;
            }
            case 3: {
                week = "\u661f\u671f\u4e09";
                break;
            }
            case 4: {
                week = "\u661f\u671f\u56db";
                break;
            }
            case 5: {
                week = "\u661f\u671f\u4e94";
                break;
            }
            case 6: {
                week = "\u661f\u671f\u516d";
            }
        }
        return week;
    }

    private static Date toDate(String sdate) {
        try {
            return dateFormater.get().parse(sdate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getfriendlyTime(Long ms) {
        String paramDate;
        if (ms == null) {
            return "";
        }
        Date time = new Date();
        time.setTime(ms);
        if (time == null) {
            return "Unknown";
        }
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        String curDate = dateFormater2.get().format(cal.getTime());
        if (curDate.equals(paramDate = dateFormater2.get().format(time))) {
            int hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour == 0 ? ((cal.getTimeInMillis() - time.getTime()) / 60000L < 1L ? "\u521a\u521a" : Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d") : hour + "\u5c0f\u65f6\u524d";
            return ftime;
        }
        long lt = time.getTime() / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        if (days == 0) {
            int hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d";
        } else if (days == 1) {
            ftime = "\u6628\u5929";
        } else if (days == 2) {
            ftime = "\u524d\u5929";
        } else if (days > 2) {
            ftime = days + "\u5929\u524d";
        }
        return ftime;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static int getExpiredHour(String dateStr) {
        int ret = -1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf.parse(dateStr);
            Date dateNow = new Date();
            long times = date.getTime() - dateNow.getTime();
            ret = times > 0L ? (int)(times / 3600000L) : -1;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static int getExpiredHour2(String dateStr) {
        int ret = -1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date sendDate = sdf.parse(dateStr);
            Date dateNow = new Date(System.currentTimeMillis());
            Log.e((String)"JPush", (String)("date=" + sendDate));
            long times = dateNow.getTime() - sendDate.getTime();
            Log.e((String)"JPush", (String)("date.getTime()=" + sendDate.getTime()));
            if (times > 0L) {
                ret = (int)(times / 3600000L);
                int n = (int)Math.floor(times / 3600000L);
            } else {
                ret = -1;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Log.e((String)"JPush", (String)("ret=" + ret));
        return ret;
    }

    public static boolean isToday(String sdate) {
        String timeDate;
        String nowDate;
        boolean b = false;
        Date time = DateUtil.toDate(sdate);
        Date today = new Date();
        if (time != null && (nowDate = dateFormater2.get().format(today)).equals(timeDate = dateFormater2.get().format(time))) {
            b = true;
        }
        return b;
    }

    public static boolean isToday(long sdate) {
        String timeDate;
        String nowDate;
        boolean b = false;
        Date time = new Date(sdate);
        Date today = new Date();
        if (time != null && (nowDate = dateFormater2.get().format(today)).equals(timeDate = dateFormater2.get().format(time))) {
            b = true;
        }
        return b;
    }

    public static int getAgeByBirthday(Date birthday) {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthday)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2) + 1;
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthday);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2) + 1;
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static String getFriendTimeOffer(long diff) {
        int day = (int)(diff / 86400000L);
        if (day > 0) {
            return day + "\u5929";
        }
        int time = (int)(diff / 3600000L);
        if (time > 0) {
            return time + "\u5c0f\u65f6";
        }
        int min = (int)(diff / 60000L);
        if (min > 0) {
            return min + "\u5206\u949f";
        }
        int sec = (int)diff / 1000;
        if (sec > 0) {
            return sec + "\u79d2";
        }
        return "1\u79d2";
    }

    public static String getFriendlyDuration(long duration) {
        String str = "";
        long tmpDuration = duration;
        str = str + (tmpDuration / 60L > 10L ? Long.valueOf(tmpDuration / 60L) : "0" + tmpDuration / 60L) + ":";
        str = str + ((tmpDuration %= 60L) / 1L >= 10L ? Long.valueOf(tmpDuration / 1L) : "0" + tmpDuration / 1L);
        tmpDuration %= 1L;
        return str;
    }

    public static String getFriendlyDuration2(long duration) {
        String str = "";
        long tmpDuration = duration;
        str = str + (tmpDuration / 60L > 0L ? tmpDuration / 60L + "'" : "");
        str = str + ((tmpDuration %= 60L) / 1L >= 10L ? tmpDuration / 1L + "''" : "0" + tmpDuration / 1L + "''");
        tmpDuration %= 1L;
        return str;
    }

    public static String getFriendlyMusicDuration(long duration) {
        String str = "-";
        int tmpDuration = (int)(duration / 1000L);
        str = str + (tmpDuration / 3600 > 10 ? Integer.valueOf(tmpDuration / 3600) : "0" + tmpDuration / 3600) + ":";
        str = str + ((tmpDuration %= 3600) / 60 > 10 ? Integer.valueOf(tmpDuration / 60) : "0" + tmpDuration / 60) + ":";
        str = str + ((tmpDuration %= 60) / 1 >= 10 ? Integer.valueOf(tmpDuration / 1) : "0" + tmpDuration / 1);
        tmpDuration %= 1;
        return str;
    }

    public static String getStarSeat(int mouth, int day) {
        String starSeat = null;
        starSeat = mouth == 3 && day >= 21 || mouth == 4 && day <= 19 ? "\u767d\u7f8a\u5ea7" : (mouth == 4 && day >= 20 || mouth == 5 && day <= 20 ? "\u91d1\u725b\u5ea7" : (mouth == 5 && day >= 21 || mouth == 6 && day <= 21 ? "\u53cc\u5b50\u5ea7" : (mouth == 6 && day >= 22 || mouth == 7 && day <= 22 ? "\u5de8\u87f9\u5ea7" : (mouth == 7 && day >= 23 || mouth == 8 && day <= 22 ? "\u72ee\u5b50\u5ea7" : (mouth == 8 && day >= 23 || mouth == 9 && day <= 22 ? "\u5904\u5973\u5ea7" : (mouth == 9 && day >= 23 || mouth == 10 && day <= 23 ? "\u5929\u79e4\u5ea7" : (mouth == 10 && day >= 24 || mouth == 11 && day <= 22 ? "\u5929\u874e\u5ea7" : (mouth == 11 && day >= 23 || mouth == 12 && day <= 21 ? "\u5c04\u624b\u5ea7" : (mouth == 12 && day >= 22 || mouth == 1 && day <= 19 ? "\u6469\u7faf\u5ea7" : (mouth == 1 && day >= 20 || mouth == 2 && day <= 18 ? "\u6c34\u74f6\u5ea7" : "\u53cc\u9c7c\u5ea7"))))))))));
        return starSeat;
    }

    public static String getChatTimeForShow(long time) {
        if (DateUtil.isToday(time)) {
            return DateUtil.getStringByFormat(time, dateFormatHMofChinese);
        }
        return DateUtil.getStringByFormat(time, dateFormatMDHMofChinese);
    }

    public static long getDatelongMills(String fomat, String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(fomat);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long longDate = date.getTime();
        return longDate;
    }

    public static int compare_date(String DATE1, String DATE2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() - dt2.getTime() > 0L) {
                return 1;
            }
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static int getCurrentYear() {
        Calendar a = Calendar.getInstance();
        return a.get(1);
    }

    public static int getCurrentMonth() {
        Calendar a = Calendar.getInstance();
        int moth = a.get(2) + 1;
        return moth;
    }

    public static int getCurrentDay1() {
        if (t == null) {
            t = new Time();
        }
        t.setToNow();
        int year = DateUtil.t.year;
        int month = DateUtil.t.month;
        int date = DateUtil.t.monthDay;
        return date;
    }

    public static int getCurrentHour() {
        if (t == null) {
            t = new Time();
        }
        t.setToNow();
        int year = DateUtil.t.year;
        int month = DateUtil.t.month;
        int date = DateUtil.t.monthDay;
        int hour = DateUtil.t.hour;
        return hour;
    }

    public static int getCurrentMinute() {
        if (t == null) {
            t = new Time();
        }
        t.setToNow();
        int year = DateUtil.t.year;
        int month = DateUtil.t.month;
        int date = DateUtil.t.monthDay;
        int hour = DateUtil.t.hour;
        int minute = DateUtil.t.minute;
        return minute;
    }

    public static int getCurrentSecond() {
        if (t == null) {
            t = new Time();
        }
        t.setToNow();
        int year = DateUtil.t.year;
        int month = DateUtil.t.month;
        int date = DateUtil.t.monthDay;
        int hour = DateUtil.t.hour;
        int minute = DateUtil.t.minute;
        int second = DateUtil.t.second;
        return second;
    }

    public static int getCurrentMonthDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getDayOfWeekByDate(String date) {
        int dayOfweek = 0;
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            calendar.setTime(df.parse(date));
            dayOfweek = calendar.get(7) - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dayOfweek;
    }
}

