/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import com.google.common.base.Strings;
import java.util.regex.Pattern;

public class CommonRegex {
    private static final Pattern ALI_PAY_CODE_PATTERN = Pattern.compile("^(((2[5-9])|(30))\\d{14,22})$");
    private static final Pattern WX_PAY_CODE_PATTERN = Pattern.compile("^1\\d{17}$");
    private static final Pattern UNION_PAY_CODE_PATTERN = Pattern.compile("^62[1-8]\\d{16}$");
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^1\\d{10}$");
    private static final Pattern DATE_YMDHM_PATTERN = Pattern.compile("^(\\d{4})-(0?\\d{1}|1[0-2])-(0?\\d{1}|[12]\\d{1}|3[01])+\\s(0?\\d{1}|1\\d{1}|2[0-3]):([0-5]?\\d{1})$");
    private static final Pattern DATE_YMDHMS_PATTERN = Pattern.compile("^(\\d{4})-(0?\\d{1}|1[0-2])-(0?\\d{1}|[12]\\d{1}|3[01])+\\s(0?\\d{1}|1\\d{1}|2[0-3]):([0-5]?\\d{1}):([0-5]?\\d{1})$");
    private static final Pattern DATE_YMD_PATTERN = Pattern.compile("^(\\d{4})-(0?\\d{1}|1[0-2])-(0?\\d{1}|[12]\\d{1}|3[01])$");
    private static final Pattern DATE_HM_PATTERN = Pattern.compile("^(0?\\d{1}|1\\d{1}|2[0-3]):([0-5]?\\d{1})$");

    public static boolean isMatch(String pattern, String content) {
        return Pattern.matches(pattern, content);
    }

    public static boolean isWechatCode(String qrCode) {
        if (Strings.isNullOrEmpty((String)qrCode)) {
            return false;
        }
        return WX_PAY_CODE_PATTERN.matcher(qrCode).matches();
    }

    public static boolean isUnionCode(String qrCode) {
        if (Strings.isNullOrEmpty((String)qrCode)) {
            return false;
        }
        return UNION_PAY_CODE_PATTERN.matcher(qrCode).matches();
    }

    public static boolean isAliPayCode(String qrCode) {
        if (Strings.isNullOrEmpty((String)qrCode)) {
            return false;
        }
        return ALI_PAY_CODE_PATTERN.matcher(qrCode).matches();
    }

    public static boolean isMobile(String mobile) {
        if (Strings.isNullOrEmpty((String)mobile)) {
            return false;
        }
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    public static boolean isDateYMDFomart(String format) {
        if (Strings.isNullOrEmpty((String)format)) {
            return false;
        }
        return DATE_YMD_PATTERN.matcher(format).matches();
    }

    public static boolean isDateYMDHMFomart(String format) {
        if (Strings.isNullOrEmpty((String)format)) {
            return false;
        }
        return DATE_YMDHM_PATTERN.matcher(format).matches();
    }

    public static boolean isDateYMDHMSFomart(String format) {
        if (Strings.isNullOrEmpty((String)format)) {
            return false;
        }
        return DATE_YMDHMS_PATTERN.matcher(format).matches();
    }

    public static boolean isDateHMFomart(String format) {
        if (Strings.isNullOrEmpty((String)format)) {
            return false;
        }
        return DATE_HM_PATTERN.matcher(format).matches();
    }
}

