/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.upload;

import com.fshows.android.stark.upload.UploadCallback;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class UploadRequestBody<T>
extends RequestBody {
    private RequestBody requestBody;
    private UploadCallback<T> uploadCallback;
    private BufferedSink bufferedSink;

    public UploadRequestBody(RequestBody requestBody, UploadCallback<T> uploadCallback) {
        this.requestBody = requestBody;
        this.uploadCallback = uploadCallback;
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.bufferedSink == null) {
            this.bufferedSink = Okio.buffer((Sink)this.sink((Sink)sink));
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }

    private Sink sink(Sink sink) {
        return new ForwardingSink(sink){
            long bytesWritten;
            long contentLength;
            {
                this.bytesWritten = 0L;
                this.contentLength = 0L;
            }

            public void write(Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                if (this.contentLength == 0L) {
                    this.contentLength = UploadRequestBody.this.contentLength();
                }
                this.bytesWritten += byteCount;
                UploadRequestBody.this.uploadCallback.onLoading(this.contentLength, this.bytesWritten);
            }
        };
    }
}

