/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.upload;

import android.content.Context;
import android.util.Log;
import com.annimon.stream.function.Supplier;
import com.facebook.stetho.common.LogUtil;
import com.fshows.android.stark.http.CommonNetProvider;
import com.fshows.android.stark.http.HttpUtils;
import com.fshows.android.stark.http.UploadApiServer;
import com.fshows.android.stark.upload.UploadCallback;
import com.fshows.android.stark.upload.UploadRequestBody;
import com.fshows.android.stark.upload.model.BaseResult;
import com.fshows.android.stark.upload.model.OssRequest;
import com.fshows.android.stark.upload.model.OssUrlBean;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import io.reactivex.CompletableObserver;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class UploadImageUtil {
    public static String HOST;
    public static String KEY;
    private Context context;
    private String[] hosts = new String[]{"https://crmgw-test.51youdian.com/gateway/", "https://crmgw-beta.51youdian.com/gateway/", "https://crmgw.51youdian.com/gateway/"};
    private String[] keys = new String[]{"88888888", "12b0a0f00978579342a897ceca8cd1f6", "12b0a0f00978579342a897ceca8cd1f6"};
    private final UploadApiServer mHttp;

    public UploadImageUtil(Context context, int buildType) {
        HOST = this.hosts[buildType];
        KEY = this.keys[buildType];
        this.context = context;
        this.mHttp = HttpUtils.getInstance().get(this.hosts[buildType], new CommonNetProvider(context), UploadApiServer.class);
    }

    public void upload(String path, boolean isCompress, final UploadCallback callback) {
        final File file = new File(path);
        String fileMD5 = this.getFileMD5(file);
        OssRequest ossRequest = new OssRequest(fileMD5 + ".jpg");
        this.mHttp.getOssUrl(ossRequest).subscribeOn(Schedulers.io()).subscribe((Observer)new Observer<BaseResult<OssUrlBean>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(BaseResult<OssUrlBean> ossUrlBeanBaseResult) {
                if (ossUrlBeanBaseResult.success.equals("true")) {
                    String ossUrl = UploadImageUtil.this.getOssUrl(((OssUrlBean)ossUrlBeanBaseResult.data).uploadUrl);
                    Log.e((String)"onNext", (String)ossUrl);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
                    UploadRequestBody upLoadRequestBody = new UploadRequestBody(requestBody, callback);
                    UploadImageUtil.this.mHttp.pusOssImg(((OssUrlBean)ossUrlBeanBaseResult.data).uploadUrl, requestBody).subscribeWith(new CompletableObserver(){

                        public void onSubscribe(Disposable d) {
                            LogUtil.e((String)"=======onSubscribe");
                        }

                        public void onComplete() {
                            LogUtil.e((String)"=======onComplete");
                        }

                        public void onError(Throwable e) {
                            LogUtil.e((String)"=======onError");
                        }
                    });
                } else {
                    Log.e((String)"onNext", (String)ossUrlBeanBaseResult.errorMsg);
                }
            }

            public void onError(Throwable e) {
                Log.e((String)"onError", (String)e.getMessage());
                callback.onFailure(null, e);
            }

            public void onComplete() {
            }
        });
    }

    private String getOssUrl(String url) {
        Matcher matcher = Pattern.compile("(.*)\\?").matcher(url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return url;
    }

    public String getFileMD5(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        return (String)Supplier.Util.safe(() -> Files.asByteSource((File)file).hash(Hashing.md5()).toString(), (Object)"").get();
    }
}

