/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.upload;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.fshows.android.stark.compress.Compress;
import com.fshows.android.stark.compress.CompressBuilder;
import com.fshows.android.stark.upload.FileUploadCallback;
import com.fshows.android.stark.upload.FileUploadMessageObj;
import com.fshows.android.stark.upload.OssService;
import com.fshows.android.stark.upload.OssUploadCallback;
import com.fshows.android.stark.utils.FileUtil;
import com.fshows.android.stark.utils.WeakReferenceHandler;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class FileUploadTask
implements Runnable,
WeakReferenceHandler.IHandlerCallback,
OssUploadCallback {
    private static final String TAG = FileUploadTask.class.getSimpleName();
    public static final String INVALID_ACCESS_KEY_ID = "InvalidAccessKeyId";
    private Context context;
    private String filePath;
    private FileUploadCallback callback;
    private int taskId;
    private CompressBuilder builder;
    private String key;
    private File tempFile;
    private WeakReferenceHandler handler = new WeakReferenceHandler(Looper.getMainLooper(), this);
    private static final int MSG_UPLOAD_START = 1;
    private static final int MSG_UPLOAD_PROGRESS = 2;
    private static final int MSG_UPLOAD_SUCCESS = 3;
    private static final int MSG_UPLOAD_FAIL = 4;

    @Override
    public void handleMessage(Message msg) {
        FileUploadMessageObj obj = (FileUploadMessageObj)msg.obj;
        if (obj == null || this.callback == null) {
            Log.d((String)TAG, (String)"obj == null or callback == null");
            return;
        }
        switch (msg.what) {
            case 1: {
                this.callback.onUploadStart(obj.getId());
                break;
            }
            case 2: {
                this.callback.onUploadProgress(obj.getProgress(), obj.getTotal(), obj.getId());
                break;
            }
            case 3: {
                this.callback.onUploadSuccess(obj.getFileUrl(), FileUploadTask.getBacketName(), this.key, obj.getId());
                break;
            }
            case 4: {
                this.callback.onUploadFail(obj.getId());
                break;
            }
        }
    }

    public FileUploadTask(Context context, String filePath, FileUploadCallback callback, int id2) {
        this.context = context;
        this.filePath = filePath;
        this.callback = callback;
        this.taskId = id2;
    }

    public void setBuilder(CompressBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void run() {
        File file = new File(this.filePath);
        if (!file.exists()) {
            Log.d((String)TAG, (String)"file is not exist!!!");
            return;
        }
        this.sendUploadStart();
        if (this.builder == null) {
            this.builder = new CompressBuilder(this.context);
        }
        try {
            this.tempFile = this.builder.isPic() ? new Compress(this.context).setBuilder(this.builder).compressToFile(file) : file;
            if (this.tempFile == null || !this.tempFile.exists()) {
                return;
            }
            String ossUploadDir = this.builder.getUploadDir();
            this.key = StringUtils.isEmpty((CharSequence)ossUploadDir) ? FileUtil.genKeyForUrl(this.tempFile) : ossUploadDir + FileUtil.genKeyForUrl(this.tempFile);
            OssService ossService = new OssService(this.context);
            ossService.setOSSUploadCallback(this);
            ossService.setBucketName(FileUploadTask.getBacketName());
            ossService.uploadImage(this.key, this.tempFile.getAbsolutePath(), this.taskId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onProgress(long progress, long total, int id2) {
        this.sendUploadProgress(progress, total);
    }

    @Override
    public void onSuccess(String backetName, String key, int id2) {
        this.deleteTempFile();
        this.getFinalUrl();
    }

    @Override
    public void onFailure(String errorCode, int id2) {
        Log.i((String)TAG, (String)("onFailure: " + errorCode));
        if (!INVALID_ACCESS_KEY_ID.equals(errorCode)) {
            this.sendUploadFail();
        }
    }

    public void deleteTempFile() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }

    private void getFinalUrl() {
    }

    private void sendUploadStart() {
        Message message = this.handler.obtainMessage();
        message.what = 1;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadProgress(long progress, long total) {
        Message message = this.handler.obtainMessage();
        message.what = 2;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        obj.setProgress(progress);
        obj.setTotal(total);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadSuccess(String fileUrl) {
        Message message = this.handler.obtainMessage();
        message.what = 3;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        obj.setFileUrl(fileUrl);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadFail() {
        Message message = this.handler.obtainMessage();
        message.what = 4;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadCancel() {
        Log.i((String)TAG, (String)"sendUploadCancel");
    }

    public static String getBacketName() {
        return null;
    }
}

