/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.http;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.fshows.android.stark.http.RequestHandler;
import com.fshows.android.stark.upload.UploadImageUtil;
import com.fshows.android.stark.upload.model.BaseRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.UUID;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class CommonRequestHandler
implements RequestHandler {
    private Context context;
    private final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public CommonRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public Request onBeforeRequest(Request request, Interceptor.Chain chain) throws IOException {
        if (TextUtils.equals((CharSequence)"POST", (CharSequence)request.method())) {
            return this.rebuildPostRequest(request);
        }
        return request;
    }

    private Request rebuildPostRequest(Request request) {
        RequestBody oldRequestBody = request.body();
        try {
            BaseRequest baseRequest = new BaseRequest();
            baseRequest.setContent(this.bodyToString(oldRequestBody));
            baseRequest.setDeviceId("74fa180a4758104c");
            String curUrl = request.url().toString().replace(UploadImageUtil.HOST, "");
            int index = curUrl.indexOf("&urlVersion=");
            if (index != -1) {
                baseRequest.setMethod(curUrl.substring(0, index));
                baseRequest.setVersion(curUrl.substring(index).replace("&urlVersion=", ""));
            } else {
                baseRequest.setMethod(curUrl);
                baseRequest.setVersion("1.0");
            }
            baseRequest.setKey(UploadImageUtil.KEY);
            baseRequest.setToken("eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJhdWQiOiI0NkZBMkFDNEQyMjc0NjQyQTNFMEJCQTNGQzMxMUU5QyIsImlzcyI6ImZzaG93cyIsImV4cCI6MTU3OTQwMzgyNiwiaWF0IjoxNTcxNjI3ODI2LCJqdGkiOiJmMDg3M2E1Yi1jNGI0LTQ1OTctYjYxOC0xYjQ0ZjcyMjAwOWUifQ._LrFh7x8LwpHljwZlZJ7cLb6oxbBOFopFC70nT4YLFw5fzszdpk-K51vQgjB_sFYfRuSbULcHYTrBanq_gFOSw");
            String beforeStr = JSON.toJSONString((Object)baseRequest);
            beforeStr = beforeStr.replace("\\\"", "\"");
            beforeStr = beforeStr.replace("\\\\", "");
            FormBody.Builder builder = new FormBody.Builder();
            builder.add("appid", baseRequest.getAppid());
            builder.add("token", baseRequest.getToken());
            builder.add("deviceId", baseRequest.getDeviceId());
            builder.add("method", baseRequest.getMethod());
            builder.add("sign", this.getStringMDcrm(beforeStr));
            builder.add("version", baseRequest.getVersion());
            builder.add("appinfo", "%7B%22client_ip%22%3A%22172.16.21.192%22%2C%22app_ua%22%3A%22MI%209%20SE%22%2C%22app_version%22%3A%221.3.3%22%7D");
            builder.add("content", baseRequest.getContent());
            Log.e((String)"xxxx", (String)("okhttp\u63a5\u53e3method:" + baseRequest.getMethod() + " \n\u8bf7\u6c42\u53c2\u6570content:\t" + baseRequest.getContent()));
            return request.newBuilder().addHeader("method", baseRequest.getMethod()).addHeader("content", URLEncoder.encode(baseRequest.getContent(), "utf-8")).url(UploadImageUtil.HOST).post((RequestBody)builder.build()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return request;
        }
    }

    private String getStringMDcrm(String src) {
        String result = null;
        try {
            result = new String(src);
            result = this.byteArrayToHexString(MessageDigest.getInstance("MD5").digest(result.getBytes()));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return result.toLowerCase();
    }

    private String byteArrayToHexString(byte[] digest) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            result.append(this.byteToHexString(digest[i]));
        }
        return result.toString();
    }

    private String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return this.HEX_DIGITS[d1] + this.HEX_DIGITS[d2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response onAfterRequest(Response response, Interceptor.Chain chain) throws IOException {
        ResponseBody responseBody = null;
        InputStreamReader jsonReader = null;
        BufferedReader reader = null;
        try {
            Charset charset = Charset.forName("UTF-8");
            responseBody = response.peekBody(Long.MAX_VALUE);
            jsonReader = new InputStreamReader(responseBody.byteStream(), charset);
            reader = new BufferedReader(jsonReader);
            StringBuilder sbJson = new StringBuilder();
            String line = reader.readLine();
            do {
                sbJson.append(line);
            } while ((line = reader.readLine()) != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (jsonReader != null) {
                jsonReader.close();
            }
            if (responseBody != null) {
                responseBody.close();
            }
        }
        return response;
    }

    private String bodyToString(RequestBody body) {
        Buffer buffer = new Buffer();
        try {
            body.writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.readUtf8();
    }

    @SuppressLint(value={"HardwareIds"})
    private String getUniqueId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)androidId)) {
            androidId = this.getPhoneSign(context);
        }
        return androidId;
    }

    @SuppressLint(value={"MissingPermission"})
    private String getPhoneSign(Context context) {
        StringBuilder deviceId = new StringBuilder();
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String imei = null;
            imei = Build.VERSION.SDK_INT >= 26 ? tm.getImei() : tm.getDeviceId();
            if (!TextUtils.isEmpty((CharSequence)imei)) {
                deviceId.append(imei);
                return deviceId.toString();
            }
            String sn = tm.getSimSerialNumber();
            if (!TextUtils.isEmpty((CharSequence)sn)) {
                deviceId.append(sn);
                return deviceId.toString();
            }
            String uuid = UUID.randomUUID().toString();
            if (!TextUtils.isEmpty((CharSequence)uuid)) {
                deviceId.append(uuid);
                return deviceId.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            deviceId.append(UUID.randomUUID().toString());
        }
        return deviceId.toString();
    }
}

