/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.log;

import android.content.Context;
import android.support.annotation.Nullable;
import com.alibaba.fastjson.JSON;
import com.aliyun.sls.android.sdk.ClientConfiguration;
import com.aliyun.sls.android.sdk.LOGClient;
import com.aliyun.sls.android.sdk.LogException;
import com.aliyun.sls.android.sdk.SLSLog;
import com.aliyun.sls.android.sdk.core.auth.CredentialProvider;
import com.aliyun.sls.android.sdk.core.auth.PlainTextAKSKCredentialProvider;
import com.aliyun.sls.android.sdk.core.auth.StsTokenCredentialProvider;
import com.aliyun.sls.android.sdk.core.callback.CompletedCallback;
import com.aliyun.sls.android.sdk.model.Log;
import com.aliyun.sls.android.sdk.model.LogGroup;
import com.aliyun.sls.android.sdk.request.PostLogRequest;
import com.aliyun.sls.android.sdk.result.PostLogResult;
import com.fshows.android.stark.log.AliyunLogConfig;
import com.fshows.android.stark.log.BaseLogModel;
import com.fshows.android.stark.utils.FsLogUtil;
import com.google.common.base.Strings;

public abstract class AbstractAliyunLogServer {
    private static final String TAG = AbstractAliyunLogServer.class.getSimpleName();
    protected Context context;
    private AliyunLogConfig aliyunLogConfig;
    private LOGClient logClient;

    public AbstractAliyunLogServer(Context context) {
        this.context = context;
        this.aliyunLogConfig = this.getAliyunLogConfig();
        this.initAliyunLogConfig();
    }

    private void initAliyunLogConfig() {
        String stsAk = this.aliyunLogConfig.getStsAk();
        String stsSk = this.aliyunLogConfig.getStsSk();
        String stsToken = this.aliyunLogConfig.getStsToken();
        Object credentialProvider = Strings.isNullOrEmpty((String)stsToken) ? new PlainTextAKSKCredentialProvider(stsAk, stsSk) : new StsTokenCredentialProvider(stsAk, stsSk, stsToken);
        ClientConfiguration conf = new ClientConfiguration();
        conf.setConnectionTimeout(15000);
        conf.setSocketTimeout(15000);
        conf.setMaxConcurrentRequest(5);
        conf.setMaxErrorRetry(2);
        conf.setCachable(Boolean.valueOf(false));
        conf.setConnectType(ClientConfiguration.NetworkPolicy.WWAN_OR_WIFI);
        SLSLog.enableLog();
        this.logClient = new LOGClient(this.context.getApplicationContext(), this.aliyunLogConfig.getEndpoint(), (CredentialProvider)credentialProvider, conf);
    }

    public void uploadLog(BaseLogModel model) {
        Log log = new Log();
        log.PutContent("content", JSON.toJSONString((Object)model));
        log.PutContent("appName", this.getAppName());
        this.asyncUploadLog(log);
    }

    private void asyncUploadLog(@Nullable Log log) {
        LogGroup logGroup = new LogGroup(this.aliyunLogConfig.getTopic(), "");
        logGroup.PutLog(log);
        try {
            PostLogRequest request = new PostLogRequest(this.aliyunLogConfig.getProject(), this.aliyunLogConfig.getLogStore(), logGroup);
            this.logClient.asyncPostLog(request, (CompletedCallback)new CompletedCallback<PostLogRequest, PostLogResult>(){

                public void onSuccess(PostLogRequest request, PostLogResult result) {
                    FsLogUtil.info(TAG, "onSuccess", new Object[0]);
                }

                public void onFailure(PostLogRequest request, LogException exception) {
                    FsLogUtil.error(TAG, "onFailure", new Object[0]);
                }
            });
        }
        catch (LogException e) {
            e.printStackTrace();
        }
    }

    public abstract String getAppName();

    public abstract AliyunLogConfig getAliyunLogConfig();
}

