/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.visitor;

import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.apm.visitor.TraceClassDecorator;
import com.mob.mobapm.apm.visitor.TraceMethodVisitor;
import com.mob.mobapm.org.objectweb.asm.ClassVisitor;
import com.mob.mobapm.org.objectweb.asm.MethodVisitor;
import com.mob.mobapm.org.objectweb.asm.Type;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;

public class AsyncTaskClassVisitor
extends ClassVisitor {
    public static final String TARGET_CLASS = "android/os/AsyncTask";
    private final InstrumentationContext context;
    private boolean instrument = false;
    public static final ImmutableMap<String, String> traceMethodMap = ImmutableMap.of((Object)"doInBackground", (Object)"([Ljava/lang/Object;)Ljava/lang/Object;");
    public static final ImmutableMap<String, String> endTraceMethodMap = ImmutableMap.of((Object)"onPostExecute", (Object)"(Ljava/lang/Object;)V");

    public AsyncTaskClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(327680, cv);
        this.context = context;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null && superName.equals(TARGET_CLASS)) {
            interfaces = TraceClassDecorator.addInterface(interfaces);
            super.visit(version, access, name, signature, superName, interfaces);
            this.instrument = true;
            this.context.markModified();
        } else {
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }

    @Override
    public void visitEnd() {
        if (this.instrument) {
            TraceClassDecorator decorator = new TraceClassDecorator(this);
            decorator.addTraceField();
            decorator.addTraceInterface(Type.getObjectType(this.context.getClassName()));
        }
        super.visitEnd();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.instrument) {
            if (traceMethodMap.containsKey((Object)name) && ((String)traceMethodMap.get((Object)name)).equals(desc)) {
                TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, name, desc, this.context);
                traceMethodVisitor.setUnloadContext();
                return traceMethodVisitor;
            }
            if (endTraceMethodMap.containsKey((Object)name) && ((String)endTraceMethodMap.get((Object)name)).equals(desc)) {
                TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, name, desc, this.context);
                return traceMethodVisitor;
            }
        }
        return methodVisitor;
    }
}

