/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.utils;

import com.mob.mobapm.apm.ClassMethod;
import com.mob.mobapm.apm.MobAgent;
import com.mob.mobapm.apm.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class ReplaceUtils {
    private static Map<String, String> needReplacedMap = new HashMap<String, String>();
    private static Map<ClassMethod, ClassMethod> wrappers;
    private static Map<String, Collection<ClassMethod>> callSiteReplacements;

    public static Map<String, String> getNeedReplacedMap() {
        return needReplacedMap;
    }

    public static ClassMethod getMethodWrapper(ClassMethod method) {
        if (wrappers != null && wrappers.containsKey(method)) {
            return wrappers.get(method);
        }
        return null;
    }

    public static Collection<ClassMethod> getCallSiteReplaceMents(String className, String methodName, String methodDesc) {
        ArrayList<ClassMethod> methods = new ArrayList<ClassMethod>();
        Collection<ClassMethod> matches = callSiteReplacements.get(methodName + ":" + methodDesc);
        if (matches != null) {
            methods.addAll(matches);
        }
        if ((matches = callSiteReplacements.get(className + "." + methodName + ":" + methodDesc)) != null) {
            methods.addAll(matches);
        }
        return methods;
    }

    private static Map<ClassMethod, ClassMethod> getMethodWrappers(Map<String, String> remappings) {
        HashMap<ClassMethod, ClassMethod> methodWrappers = new HashMap<ClassMethod, ClassMethod>();
        for (Map.Entry<String, String> entry : remappings.entrySet()) {
            if (!entry.getKey().startsWith("WRAP_METHOD:")) continue;
            String originalSig = entry.getKey().substring("WRAP_METHOD:".length());
            Log.e(originalSig + " originSig  ReplaceUtils");
            Log.e(entry.getValue() + " key  ReplaceUtils");
            ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
            ClassMethod wrappingMethod = ClassMethod.getClassMethod(entry.getValue());
            methodWrappers.put(origClassMethod, wrappingMethod);
        }
        return methodWrappers;
    }

    private static Map<String, Collection<ClassMethod>> getCallSiteReplacements(Map<String, String> remappings) {
        HashMap<String, HashSet<ClassMethod>> temp = new HashMap<String, HashSet<ClassMethod>>();
        for (Map.Entry<String, String> entry : remappings.entrySet()) {
            if (!entry.getKey().startsWith("REPLACE_CALL_SITE:")) continue;
            String originalSig = entry.getKey().substring("REPLACE_CALL_SITE:".length());
            if (originalSig.contains(".")) {
                ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
                ClassMethod classMethod1 = ClassMethod.getClassMethod(entry.getValue());
                String str = origClassMethod.getClassName() + "." + origClassMethod.getMethodName() + ":" + origClassMethod.getMethodDesc();
                HashSet<ClassMethod> set = (HashSet<ClassMethod>)temp.get(str);
                if (set == null) {
                    set = new HashSet<ClassMethod>();
                    temp.put(str, set);
                }
                set.add(classMethod1);
                continue;
            }
            String[] nameDesc = originalSig.split(":");
            int paren = originalSig.indexOf("(");
            String methodName = originalSig.substring(0, paren);
            String methodDesc = originalSig.substring(paren);
            String key = methodName + ":" + methodDesc;
            ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
            HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
            if (replacements == null) {
                replacements = new HashSet<ClassMethod>();
                temp.put(key, replacements);
            }
            replacements.add(replacement);
        }
        HashMap<String, Collection<ClassMethod>> callSiteReplacements = new HashMap<String, Collection<ClassMethod>>();
        for (Map.Entry entry : temp.entrySet()) {
            callSiteReplacements.put((String)entry.getKey(), (Collection<ClassMethod>)entry.getValue());
        }
        return callSiteReplacements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getRemappings() {
        Properties props = new Properties();
        URL resource = MobAgent.class.getResource("/mob_agentmap.properties");
        if (resource == null) {
            Log.e("Unable to find the type map");
            System.exit(1);
        }
        InputStream in = null;
        try {
            in = resource.openStream();
            props.load(in);
        }
        catch (Throwable ex) {
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    static {
        needReplacedMap = ReplaceUtils.getRemappings();
        wrappers = ReplaceUtils.getMethodWrappers(needReplacedMap);
        callSiteReplacements = ReplaceUtils.getCallSiteReplacements(needReplacedMap);
    }
}

