/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.transform;

import com.mob.mobapm.apm.ClassAdapterBase;
import com.mob.mobapm.apm.MobAgent;
import com.mob.mobapm.apm.PatchedClassWriter;
import com.mob.mobapm.apm.transform.ClassVisitorFactory;
import com.mob.mobapm.apm.transform.MethodVisitorFactory;
import com.mob.mobapm.apm.transform.ModifyClassTransformer;
import com.mob.mobapm.apm.utils.BytecodeBuilder;
import com.mob.mobapm.apm.utils.Log;
import com.mob.mobapm.apm.utils.SkipException;
import com.mob.mobapm.apm.visitor.BaseMethodVisitor;
import com.mob.mobapm.apm.visitor.SafeInstrumentationMethodVisitor;
import com.mob.mobapm.apm.visitor.SkipInstrumentedMethodsMethodVisitor;
import com.mob.mobapm.org.objectweb.asm.ClassReader;
import com.mob.mobapm.org.objectweb.asm.ClassVisitor;
import com.mob.mobapm.org.objectweb.asm.MethodVisitor;
import com.mob.mobapm.org.objectweb.asm.Type;
import com.mob.mobapm.org.objectweb.asm.commons.GeneratorAdapter;
import com.mob.mobapm.org.objectweb.asm.commons.Method;
import java.io.File;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DexClassTransformer
implements ModifyClassTransformer {
    private final Map<String, ClassVisitorFactory> classVisitors;

    public DexClassTransformer() throws URISyntaxException {
        String agentJarPath;
        try {
            agentJarPath = MobAgent.getAgentJarPath();
        }
        catch (URISyntaxException e) {
            Log.e("Unable to get the path of agent jar");
            throw e;
        }
        this.classVisitors = new HashMap<String, ClassVisitorFactory>(){
            {
                this.put("com/android/dx/command/dexer/Main", new ClassVisitorFactory(true){

                    @Override
                    public ClassVisitor create(ClassVisitor cv) {
                        return DexClassTransformer.createDexerMainClassAdapter(cv);
                    }
                });
                this.put("com/android/ant/DexExecTask", new ClassVisitorFactory(false){

                    @Override
                    public ClassVisitor create(ClassVisitor cv) {
                        return DexClassTransformer.createAntTaskClassAdapter(cv);
                    }
                });
                this.put("com/jayway/maven/plugins/android/phase08preparepackage/DexMojo", new ClassVisitorFactory(true){

                    @Override
                    public ClassVisitor create(ClassVisitor cv) {
                        return DexClassTransformer.createMavenClassAdapter(cv, agentJarPath);
                    }
                });
                this.put("java/lang/ProcessBuilder", new ClassVisitorFactory(true){

                    @Override
                    public ClassVisitor create(ClassVisitor cv) {
                        return DexClassTransformer.createProcessBuilderClassAdapter(cv);
                    }
                });
            }
        };
    }

    @Override
    public boolean modifies(Class<?> clazz) {
        Type t = Type.getType(clazz);
        return this.classVisitors.containsKey(t.getInternalName());
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> clazz, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        ClassVisitorFactory factory = this.classVisitors.get(className);
        if (factory != null) {
            if (clazz != null && !factory.isRetransformOkay()) {
                Log.e("Cannot instrument " + className);
                return null;
            }
            try {
                ClassReader cr = new ClassReader(bytes);
                PatchedClassWriter patchedClassWriter = new PatchedClassWriter(3, classLoader);
                ClassVisitor adapter = factory.create(patchedClassWriter);
                cr.accept(adapter, 4);
                Log.e("DexTransform: Transformed[" + className + "] Bytes In[" + bytes.length + "] Bytes Out[" + patchedClassWriter.toByteArray().length + "]");
                return patchedClassWriter.toByteArray();
            }
            catch (SkipException skipException) {
                Log.e("ssss skipexception" + skipException.getMessage());
            }
            catch (Exception ex) {
                Log.e("ssss exception" + ex.toString());
            }
        }
        return null;
    }

    private static ClassVisitor createDexerMainClassAdapter(ClassVisitor cw) {
        return new ClassAdapterBase(cw, (Map<Method, MethodVisitorFactory>)new HashMap<Method, MethodVisitorFactory>(){
            {
                this.put(new Method("processClass", "(Ljava/lang/String;[B)Z"), new MethodVisitorFactory(){

                    @Override
                    public MethodVisitor create(MethodVisitor mv, int access, String name, String desc) {
                        return new BaseMethodVisitor(mv, access, name, desc){

                            @Override
                            public void onMethodEnter() {
                                Log.e("sssscreateDexerMainClassAdapter");
                                this.builder.loadInvocationDispatcher().loadInvocationDispatcherKey(MobAgent.getProxyInvocationKey("com/android/dx/command/dexer/Main", this.methodName)).loadArgumentsArray(this.methodDesc).invokeDispatcher(false);
                                this.checkCast(Type.getType(byte[].class));
                                this.storeArg(1);
                            }
                        };
                    }
                });
            }
        });
    }

    private static ClassVisitor createAntTaskClassAdapter(ClassVisitor cw) {
        HashMap<Method, MethodVisitorFactory> methodVisitors = new HashMap<Method, MethodVisitorFactory>(){
            {
                this.put(new Method("preDexLibraries", "(Ljava/util/List;)V"), new MethodVisitorFactory(){

                    @Override
                    public MethodVisitor create(MethodVisitor mv, int access, String name, String desc) {
                        return new BaseMethodVisitor(mv, access, name, desc){

                            @Override
                            public void onMethodEnter() {
                                this.builder.loadInvocationDispatcher().loadInvocationDispatcherKey(MobAgent.getProxyInvocationKey("com/android/ant/DexExecTask", this.methodName)).loadArray(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.loadArg(0);
                                    }
                                }).invokeDispatcher(false);
                                this.loadThis();
                                this.swap();
                                this.putField(Type.getObjectType("com/android/ant/DexExecTask"), "MobAgentFile", Type.getType(Object.class));
                            }
                        };
                    }
                });
                this.put(new Method("runDx", "(Ljava/util/Collection;Ljava/lang/String;Z)V"), new MethodVisitorFactory(){

                    @Override
                    public MethodVisitor create(MethodVisitor mv, int access, String name, String desc) {
                        return new SafeInstrumentationMethodVisitor(mv, access, name, desc){

                            @Override
                            public void onMethodEnter() {
                                this.builder.loadInvocationDispatcher().loadInvocationDispatcherKey("SET_INSTRUMENTATION_DISABLED_FLAG").loadArray(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.loadThis();
                                        this.getField(Type.getObjectType("com/android/ant/DexExecTask"), "MobAgentFile", Type.getType(Object.class));
                                    }
                                }).invokeDispatcher();
                            }
                        };
                    }
                });
            }
        };
        return new ClassAdapterBase(cw, methodVisitors){

            @Override
            public void visitEnd() {
                super.visitEnd();
                this.visitField(2, "MobAgentFile", Type.getType(Object.class).getDescriptor(), null, null);
            }
        };
    }

    private static ClassVisitor createProcessBuilderClassAdapter(ClassVisitor cw) {
        return new ClassVisitor(327680, cw){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("start".equals(name)) {
                    return new SkipInstrumentedMethodsMethodVisitor(new BaseMethodVisitor(mv, access, name, desc){

                        @Override
                        public void onMethodEnter() {
                            this.builder.loadInvocationDispatcher().loadInvocationDispatcherKey(MobAgent.getProxyInvocationKey("java/lang/ProcessBuilder", this.methodName)).loadArray(new Runnable(){

                                @Override
                                public void run() {
                                    Log.e("sssscreateProcessBuilderClassAdapter");
                                    this.loadThis();
                                    this.invokeVirtual(Type.getObjectType("java/lang/ProcessBuilder"), new Method("command", "()Ljava/util/List;"));
                                }
                            }).invokeDispatcher();
                        }
                    });
                }
                return mv;
            }
        };
    }

    private static ClassVisitor createMavenClassAdapter(ClassVisitor cw, final String agentJarPath) {
        return new ClassAdapterBase(cw, (Map<Method, MethodVisitorFactory>)new HashMap<Method, MethodVisitorFactory>(){
            {
                this.put(new Method("runDex", "(Lcom/jayway/maven/plugins/android/CommandExecutor;Ljava/io/File;Ljava/util/Set;)V"), new MethodVisitorFactory(){

                    @Override
                    public MethodVisitor create(MethodVisitor mv, int access, String name, String desc) {
                        return new GeneratorAdapter(327680, mv, access, name, desc){

                            @Override
                            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                                if ("executeCommand".equals(name) && "(Ljava/lang/String;Ljava/util/List;Ljava/io/File;Z)V".equals(desc)) {
                                    int arg3 = this.newLocal(Type.BOOLEAN_TYPE);
                                    this.storeLocal(arg3);
                                    int arg2 = this.newLocal(Type.getType(File.class));
                                    this.storeLocal(arg2);
                                    this.dup();
                                    this.push(0);
                                    String agentCommand = "-javaagent:" + agentJarPath;
                                    if (MobAgent.getAgentArgs() != null) {
                                        agentCommand = agentCommand + "=" + MobAgent.getAgentArgs();
                                    }
                                    new BytecodeBuilder(this).printToInfoLogFromBytecode("Maven agent jar: " + agentCommand);
                                    this.visitLdcInsn(agentCommand);
                                    this.invokeInterface(Type.getType(List.class), new Method("add", "(ILjava/lang/Object;)V"));
                                    this.loadLocal(arg2);
                                    this.loadLocal(arg3);
                                }
                                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                            }
                        };
                    }
                });
            }
        });
    }
}

