/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm;

import com.mob.mobapm.apm.utils.Log;
import com.mob.mobapm.org.objectweb.asm.ClassWriter;

public class PatchedClassWriter
extends ClassWriter {
    private final ClassLoader classLoader;

    public PatchedClassWriter(int flags, ClassLoader classLoader) {
        super(flags);
        this.classLoader = classLoader;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> d;
        Class<?> c;
        try {
            c = Class.forName(type1.replace('/', '.'), true, this.classLoader);
            d = Class.forName(type2.replace('/', '.'), true, this.classLoader);
        }
        catch (Exception e) {
            Log.e(e.toString());
            throw new RuntimeException(e.toString());
        }
        if (c.isAssignableFrom(d)) {
            return type1;
        }
        if (d.isAssignableFrom(c)) {
            return type2;
        }
        if (c.isInterface() || d.isInterface()) {
            return "java/lang/Object";
        }
        while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
        }
        return c.getName().replace('.', '/');
    }
}

