/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.text.TextUtils;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.Strings;

public class NtFetcher {
    private static NtFetcher instance;
    private Context context;
    private DeviceHelper device;
    private BroadcastReceiver receiver;
    private String ntType;
    private Integer dtNtType;

    private NtFetcher(Context context) {
        this.context = context;
        this.device = DeviceHelper.getInstance(context);
        if (this.device.isSensitiveDevice()) {
            this.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NtFetcher getInstance(Context context) {
        if (instance != null) return instance;
        Class<NtFetcher> clazz = NtFetcher.class;
        synchronized (NtFetcher.class) {
            if (instance != null) return instance;
            instance = new NtFetcher(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void prepare() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.device.getSystemServiceSafe("connectivity");
            if (Build.VERSION.SDK_INT >= 26 && this.device.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager.NetworkCallback networkCallback = this.initNetworkCallback();
                connectivityManager.registerDefaultNetworkCallback(networkCallback);
            } else if (Build.VERSION.SDK_INT >= 21 && this.device.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                NetworkRequest request = builder.build();
                ConnectivityManager.NetworkCallback networkCallback = this.initNetworkCallback();
                connectivityManager.registerNetworkCallback(request, networkCallback);
            } else {
                this.registerReceiver();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public void recycle() {
        this.unregisterReceiver();
    }

    public synchronized String getNtType() {
        if (!this.device.isSensitiveDevice() || TextUtils.isEmpty((CharSequence)this.ntType)) {
            this.ntType = this.getNetworkType();
        }
        return this.ntType;
    }

    public synchronized int getDtNtType() {
        if (!this.device.isSensitiveDevice() || this.dtNtType == null) {
            this.dtNtType = this.getDataNtType();
        }
        return this.dtNtType;
    }

    @TargetApi(value=21)
    private ConnectivityManager.NetworkCallback initNetworkCallback() {
        ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                super.onAvailable(network);
                NtFetcher.this.refreshNet();
            }

            public void onLost(Network network) {
                super.onLost(network);
                NtFetcher.this.refreshNet();
            }

            public void onLosing(Network network, int maxMsToLive) {
                super.onLosing(network, maxMsToLive);
            }

            public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                super.onCapabilitiesChanged(network, networkCapabilities);
            }

            public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
                super.onLinkPropertiesChanged(network, linkProperties);
            }

            public void onUnavailable() {
                super.onUnavailable();
            }
        };
        return networkCallback;
    }

    private void refreshNet() {
        this.ntType = this.getNetworkType();
        this.dtNtType = this.getDataNtType();
    }

    private int getDataNtType() {
        int type = -1;
        Object phone = this.device.getSystemServiceSafe("phone");
        if (phone == null) {
            return type;
        }
        try {
            type = Build.VERSION.SDK_INT >= 24 && this.device.checkPermission("android.permission.READ_PHONE_STATE") ? ((Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(101), new Object[0])).intValue() : ((Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(19), new Object[0])).intValue();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return type;
    }

    private void registerReceiver() {
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                try {
                    if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
                        NtFetcher.this.refreshNet();
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        try {
            ReflectHelper.invokeInstanceMethod((Object)this.context, "registerReceiver", new Object[]{this.receiver, filter}, new Class[]{BroadcastReceiver.class, IntentFilter.class});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void unregisterReceiver() {
        if (this.receiver != null) {
            try {
                ReflectHelper.invokeInstanceMethod((Object)this.context, "unregisterReceiver", new Object[]{this.receiver}, new Class[]{BroadcastReceiver.class});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.receiver = null;
        }
    }

    private String getNetworkType() {
        try {
            NetworkInfo network;
            Object conn;
            if (this.device.checkPermission("android.permission.ACCESS_NETWORK_STATE") && (conn = this.device.getSystemServiceSafe("connectivity")) != null && (network = ((ConnectivityManager)conn).getActiveNetworkInfo()) != null && network.isAvailable()) {
                int type = network.getType();
                switch (type) {
                    case 1: {
                        return "wifi";
                    }
                    case 0: {
                        if (this.is5GMobileNetwork()) {
                            return "5G";
                        }
                        if (this.is4GMobileNetwork()) {
                            return "4G";
                        }
                        return this.isFastMobileNetwork() ? "3G" : "2G";
                    }
                    case 7: {
                        return "bluetooth";
                    }
                    case 8: {
                        return "dummy";
                    }
                    case 9: {
                        return "ethernet";
                    }
                    case 6: {
                        return "wimax";
                    }
                }
                return String.valueOf(type);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return "none";
    }

    private boolean is5GMobileNetwork() {
        if (this.is5GHw()) {
            return true;
        }
        if (this.maybe5G()) {
            return true;
        }
        return this.is5GCommon();
    }

    private boolean is5GHw() {
        try {
            String manufacturer;
            if (this.device.checkPermission("android.permission.READ_PHONE_STATE") && !TextUtils.isEmpty((CharSequence)(manufacturer = this.device.getManufacturer())) && (manufacturer.contains("huawei") || manufacturer.contains("Huawei") || manufacturer.contains("HUAWEI"))) {
                Object serviceState;
                int result;
                Object phone = this.device.getSystemServiceSafe("phone");
                if (phone == null) {
                    return false;
                }
                if (Build.VERSION.SDK_INT >= 29 && (result = ((Integer)ReflectHelper.invokeInstanceMethod(serviceState = ReflectHelper.invokeInstanceMethod(phone, Strings.getString(129), new Object[0]), Strings.getString(131), new Object[0])).intValue()) == 20) {
                    return true;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    private boolean maybe5G() {
        try {
            if (this.device.checkPermission("android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT >= 26) {
                Object phone = this.device.getSystemServiceSafe("phone");
                if (phone == null) {
                    return false;
                }
                Object serviceState = ReflectHelper.invokeInstanceMethod(phone, Strings.getString(129), new Object[0]);
                int result = (Integer)ReflectHelper.invokeInstanceMethod(serviceState, Strings.getString(130), new Object[0]);
                if (result == 3) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private boolean is5GCommon() {
        Object phone = this.device.getSystemServiceSafe("phone");
        if (phone == null) {
            return false;
        }
        try {
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(19), new Object[0]);
            return type == 20;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    private boolean is4GMobileNetwork() {
        Object phone = this.device.getSystemServiceSafe("phone");
        if (phone == null) {
            return false;
        }
        try {
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(19), new Object[0]);
            return type == 13;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    private boolean isFastMobileNetwork() {
        Object phone = this.device.getSystemServiceSafe("phone");
        if (phone == null) {
            return false;
        }
        try {
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(19), new Object[0]);
            switch (type) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }
}

