/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.location.Location;
import android.net.Proxy;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.MediaStore;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Size;
import android.view.View;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.mob.tools.MobLog;
import com.mob.tools.utils.BHelper;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.LHelper;
import com.mob.tools.utils.NtFetcher;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import com.mob.tools.utils.SmltHelper;
import com.mob.tools.utils.Strings;
import com.mob.tools.utils.UIHandler;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceHelper {
    private Context context;
    private String advertiseID;
    private String imei;
    private String serialno;
    private String wifimac;
    private String[] invalidMacList;
    private String fixedString = null;
    private String cacheDeviceKey = null;
    private volatile boolean hasSdcardWritePermission = false;
    private static DeviceHelper deviceHelper;
    private Boolean isSmlt;
    private String ln = "-1";
    private String swVer = "-1";
    private int sActCnt = -1;
    private List<Object> sActList;

    public static synchronized DeviceHelper getInstance(Context c) {
        if (deviceHelper == null && c != null) {
            deviceHelper = new DeviceHelper(c);
        }
        return deviceHelper;
    }

    private DeviceHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public boolean isRooted() {
        boolean checkTag = Build.TAGS != null && Build.TAGS.contains("test-keys");
        return checkTag || this.checkRootFile() || this.checkRootApp() || this.checkRootSu() || this.checkRootRw() || this.checkRootProp();
    }

    private boolean checkRootFile() {
        try {
            String[] folder;
            if (new File("/system/app/Superuser.apk").exists()) {
                return true;
            }
            for (String file : folder = new String[]{"/data/local/", "/data/local/bin/", "/data/local/xbin/", "/sbin/", "/su/bin/", "/system/bin/", "/system/bin/.ext/", "/system/bin/failsafe/", "/system/sd/xbin/", "/system/usr/we-need-root/", "/system/xbin/", "/system/sbin/", "/vendor/bin/", "/cache", "/data", "/dev"}) {
                if (!new File(file, "su").exists()) continue;
                return true;
            }
            for (String file : folder) {
                if (!new File(file, "busybox").exists()) continue;
                return true;
            }
            for (String file : folder) {
                if (!new File(file, "magisk").exists()) continue;
                return true;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    private boolean checkRootApp() {
        String[] rootApps = new String[]{"com.noshufou.android.su", "com.noshufou.android.su.elite", "eu.chainfire.supersu", "com.koushikdutta.superuser", "com.thirdparty.superuser", "com.yellowes.su", "com.topjohnwu.magisk", "com.koushikdutta.rommanager", "com.koushikdutta.rommanager.license", "com.dimonvideo.luckypatcher", "com.chelpus.lackypatch", "com.ramdroid.appquarantine", "com.ramdroid.appquarantinepro", "com.android.vending.billing.InAppBillingService.COIN", "com.chelpus.luckypatcher"};
        try {
            for (String app : rootApps) {
                if (!deviceHelper.isPackageInstalled(app)) continue;
                return true;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    private boolean checkRootProp() {
        try {
            InputStream inputStream = this.invokeRuntimeExec(new String[]{"getprop"});
            if (inputStream == null) {
                return false;
            }
            String[] props = new Scanner(inputStream).useDelimiter("\\A").next().split("\n");
            if (props != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("ro.debuggable", "1");
                hashMap.put("ro.secure", "0");
                for (String prop : props) {
                    for (String key : hashMap.keySet()) {
                        boolean result;
                        if (prop == null || !prop.contains(key) || !(result = prop.contains("[" + hashMap.get(key) + "]"))) continue;
                        return true;
                    }
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    private boolean checkRootRw() {
        try {
            InputStream inputStream = this.invokeRuntimeExec(new String[]{"mount"});
            if (inputStream == null) {
                return false;
            }
            String[] mounts = new Scanner(inputStream).useDelimiter("\\A").next().split("\n");
            if (mounts != null) {
                String[] folders = new String[]{"/system", "/system/bin", "/system/sbin", "/system/xbin", "/vendor/bin", "/sbin", "/etc"};
                for (String mount : mounts) {
                    String[] split = mount.split(" ");
                    if (split.length < 4) continue;
                    String folder = split[1];
                    String state = split[3];
                    for (String target : folders) {
                        String[] states;
                        if (folder == null || !folder.equalsIgnoreCase(target)) continue;
                        for (String targetState : states = state.split(",")) {
                            if (targetState == null || !targetState.equalsIgnoreCase("rw")) continue;
                            return true;
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    private boolean checkRootSu() {
        InputStream inputStream2;
        boolean result1 = false;
        boolean result2 = false;
        try {
            inputStream2 = this.invokeRuntimeExec(new String[]{"which", "su"});
            if (inputStream2 != null) {
                result1 = new BufferedReader(new InputStreamReader(inputStream2)).readLine() != null;
            }
        }
        catch (Throwable inputStream2) {
            // empty catch block
        }
        try {
            inputStream2 = this.invokeRuntimeExec(new String[]{"/system/xbin/which", "su"});
            if (inputStream2 != null) {
                result2 = new BufferedReader(new InputStreamReader(inputStream2)).readLine() != null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result1 || result2;
    }

    private InputStream invokeRuntimeExec(String[] cmdarray) {
        try {
            String clz = ReflectHelper.importClass(Strings.getString(42));
            Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
            Object p = ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), new Object[]{cmdarray});
            InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod(p, Strings.getString(45), new Object[0]);
            return is;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getSSID() {
        try {
            if (this.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                Object wifi = this.getSystemServiceSafe("wifi");
                if (wifi == null) {
                    return null;
                }
                Object info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0]);
                if (info != null) {
                    String ssid = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(3), new Object[0]);
                    return ssid == null ? null : ssid.replace("\"", "");
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public String getBssid() {
        try {
            if (this.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                Object wifi = this.getSystemServiceSafe("wifi");
                if (wifi == null) {
                    return null;
                }
                Object info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0]);
                if (info != null) {
                    String bssid = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(4), new Object[0]);
                    return bssid == null ? null : bssid;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private String[] getInvalidMacList() {
        try {
            HashMap map;
            ArrayList list;
            File file = ResHelper.getDataCacheFile(this.context, ".mcli");
            String tmp = Data.AES128Decode(Strings.getString(76), (byte[])ResHelper.readObjectFromFile(file.getPath()));
            if (!TextUtils.isEmpty((CharSequence)tmp) && (list = (ArrayList)(map = new Hashon().fromJson(tmp)).get("list")) != null && list.size() > 0) {
                return list.toArray(new String[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private String getLocalWifiMac() {
        try {
            File file = ResHelper.getCacheRootFile(this.context, ".mcw");
            String wifiMac = null;
            if (file.exists()) {
                wifiMac = Data.AES128Decode("1234567890abcdfg", (byte[])ResHelper.readObjectFromFile(file.getPath()));
            }
            if (TextUtils.isEmpty(wifiMac)) {
                wifiMac = this.getWAbcd(2);
            }
            if (!TextUtils.isEmpty(wifiMac) && wifiMac.trim().matches("^[a-fA-F0-9]{2}(:[a-fA-F0-9]{2}){5}$")) {
                return wifiMac.trim();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private void saveLocalWifiMac(String mac) {
        try {
            if (!TextUtils.isEmpty((CharSequence)mac) && mac.trim().matches("^[a-fA-F0-9]{2}(:[a-fA-F0-9]{2}){5}$")) {
                File file = ResHelper.getCacheRootFile(this.context, ".mcw");
                byte[] string = Data.AES128Encode("1234567890abcdfg", mac.trim());
                ResHelper.saveObjectToFile(file.getPath(), string);
                this.saveWabcd(mac.trim(), 2);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    private String getLocalSerial() {
        try {
            File file = ResHelper.getCacheRootFile(this.context, ".slw");
            String wifiMac = Data.AES128Decode(Strings.getString(76), (byte[])ResHelper.readObjectFromFile(file.getPath()));
            if (!TextUtils.isEmpty((CharSequence)wifiMac)) {
                return wifiMac.trim();
            }
            return this.getWAbcd(3);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return null;
        }
    }

    private void saveLocalSerial(String serialNo) {
        try {
            if (!TextUtils.isEmpty((CharSequence)serialNo) && !serialNo.trim().equals("")) {
                File file = ResHelper.getCacheRootFile(this.context, ".slw");
                byte[] string = Data.AES128Encode(Strings.getString(76), serialNo.trim());
                ResHelper.saveObjectToFile(file.getPath(), string);
                this.saveWabcd(serialNo.trim(), 3);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public String getMacAddress() {
        if (!TextUtils.isEmpty((CharSequence)this.wifimac)) {
            return this.wifimac;
        }
        String localWifiMac = this.getLocalWifiMac();
        if (!TextUtils.isEmpty((CharSequence)localWifiMac) && this.checkMacIsValid(localWifiMac)) {
            this.wifimac = localWifiMac;
            return localWifiMac;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            String tmpMac = this.getWlanMac();
            if (tmpMac != null && !TextUtils.isEmpty((CharSequence)tmpMac.trim())) {
                return tmpMac.trim();
            }
            tmpMac = this.getWifiMac();
            return tmpMac;
        }
        String tmpMac = this.getWifiMac();
        if (tmpMac != null && this.checkMacIsValid(tmpMac)) {
            this.wifimac = tmpMac.trim();
            this.saveLocalWifiMac(this.wifimac);
            return this.wifimac;
        }
        tmpMac = this.getWlanMac();
        return tmpMac;
    }

    private String getWlanMac() {
        try {
            String hd = this.getHardwareAddressFromShell("wlan0");
            if (hd != null && this.checkMacIsValid(hd)) {
                this.wifimac = hd.trim();
                this.saveLocalWifiMac(this.wifimac);
                return this.wifimac;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        try {
            return this.getValidNetworkHardwareAddress();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return null;
        }
    }

    private boolean checkMacIsValid(String mac) {
        try {
            String[] tmp;
            if (mac == null || TextUtils.isEmpty((CharSequence)mac.trim())) {
                return false;
            }
            if (this.invalidMacList == null) {
                this.invalidMacList = this.getInvalidMacList();
            }
            if ((tmp = this.invalidMacList) == null) {
                tmp = new String[]{Strings.getString(70), Strings.getString(71)};
            }
            for (String invalid : tmp) {
                if (invalid == null || !mac.trim().startsWith(invalid.trim())) continue;
                return false;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return true;
    }

    private String getWifiMac() {
        try {
            Object wifi = this.getSystemServiceSafe("wifi");
            if (wifi == null) {
                return null;
            }
            Object info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0]);
            if (info != null) {
                String tmpMac = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(5), new Object[0]);
                return tmpMac == null ? null : tmpMac.trim();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    private String getCurrentNetworkHardwareAddress() throws Throwable {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis == null) {
            return null;
        }
        ArrayList<NetworkInterface> interfaces = Collections.list(nis);
        for (NetworkInterface intf : interfaces) {
            Enumeration<InetAddress> ias = intf.getInetAddresses();
            if (ias == null) continue;
            ArrayList<InetAddress> addrs = Collections.list(ias);
            for (InetAddress add : addrs) {
                if (add.isLoopbackAddress() || !(add instanceof Inet4Address)) continue;
                byte[] mac = null;
                if (Build.VERSION.SDK_INT >= 9) {
                    mac = intf.getHardwareAddress();
                }
                if (mac == null) continue;
                return this.byteToHex(mac);
            }
        }
        return null;
    }

    private String getValidNetworkHardwareAddress() throws Throwable {
        String mac;
        HashMap<String, String> macs = this.listNetworkHardware();
        if (macs == null || macs.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(macs.keySet());
        String wlan0 = null;
        ArrayList<String> wlans = new ArrayList<String>();
        ArrayList<String> eths = new ArrayList<String>();
        ArrayList<String> rmnets = new ArrayList<String>();
        ArrayList<String> dummys = new ArrayList<String>();
        ArrayList<String> usbs = new ArrayList<String>();
        ArrayList<String> rmnetUsbs = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        while (names.size() > 0) {
            String name = names.remove(0).trim();
            if (name.equals("wlan0")) {
                wlan0 = "wlan0";
                continue;
            }
            if (name.startsWith("wlan")) {
                wlans.add(name);
                continue;
            }
            if (name.startsWith("eth")) {
                eths.add(name);
                continue;
            }
            if (name.startsWith("rev_rmnet")) {
                rmnets.add(name);
                continue;
            }
            if (name.startsWith("dummy")) {
                dummys.add(name);
                continue;
            }
            if (name.startsWith("usbnet")) {
                usbs.add(name);
                continue;
            }
            if (name.startsWith("rmnet_usb")) {
                rmnetUsbs.add(name);
                continue;
            }
            others.add(name);
        }
        Collections.sort(wlans);
        Collections.sort(eths);
        Collections.sort(rmnets);
        Collections.sort(dummys);
        Collections.sort(usbs);
        Collections.sort(rmnetUsbs);
        Collections.sort(others);
        if (!TextUtils.isEmpty((CharSequence)wlan0)) {
            names.add(wlan0);
        }
        names.addAll(wlans);
        if ("wifi".equals(this.getNetworkType())) {
            try {
                String wifiMac = this.getCurrentNetworkHardwareAddress();
                if (!TextUtils.isEmpty((CharSequence)wifiMac)) {
                    names.add(wifiMac);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (names.size() > 0) {
            for (String item : names) {
                mac = macs.get(item);
                if (mac == null || !this.checkMacIsValid(mac)) continue;
                this.wifimac = mac.trim();
                this.saveLocalWifiMac(this.wifimac);
                return this.wifimac;
            }
        }
        names.addAll(eths);
        names.addAll(rmnets);
        names.addAll(dummys);
        names.addAll(usbs);
        names.addAll(rmnetUsbs);
        names.addAll(others);
        for (String item : names) {
            mac = macs.get(item);
            if (mac == null || !this.checkMacIsValid(mac)) continue;
            return mac.trim();
        }
        return null;
    }

    public HashMap<String, String> listNetworkHardware() throws Throwable {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis == null) {
            return null;
        }
        ArrayList<NetworkInterface> interfaces = Collections.list(nis);
        HashMap<String, String> macs = new HashMap<String, String>();
        for (NetworkInterface intf : interfaces) {
            byte[] mac = null;
            if (Build.VERSION.SDK_INT >= 9) {
                mac = intf.getHardwareAddress();
            }
            if (mac == null) continue;
            macs.put(intf.getName(), this.byteToHex(mac));
        }
        return macs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHardwareAddressFromShell(String networkCard) {
        String line = null;
        BufferedReader br = null;
        try {
            String clz = ReflectHelper.importClass(Strings.getString(42));
            Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
            String c = Strings.getString(6) + networkCard + Strings.getString(7);
            Object p = ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), c);
            InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod(p, Strings.getString(45), new Object[0]);
            InputStreamReader isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            line = br.readLine();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable clz) {}
            }
        }
        return TextUtils.isEmpty(line) ? null : line;
    }

    public String getBTMacFromProvider() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"bluetooth_address");
    }

    public String getBTMac() {
        if (Build.VERSION.SDK_INT < 27) {
            String result;
            block7: {
                result = null;
                try {
                    if (!this.checkPermission("android.permission.BLUETOOTH")) break block7;
                    BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                    if (Build.VERSION.SDK_INT < 23) {
                        result = bluetoothAdapter.getAddress();
                        break block7;
                    }
                    try {
                        Object bms = ReflectHelper.getInstanceField(bluetoothAdapter, "mService");
                        if (bms != null) {
                            result = (String)ReflectHelper.invokeInstanceMethod(bms, "getAddress", new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }
        return null;
    }

    public boolean isBT() {
        try {
            return BHelper.getInstance(this.context).isEnabled();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getModel() {
        String model = Build.MODEL;
        if (!TextUtils.isEmpty((CharSequence)model)) {
            model = model.trim();
        }
        return model;
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getDeviceId() {
        String deviceId = this.getIMEI();
        if (TextUtils.isEmpty((CharSequence)deviceId) && Build.VERSION.SDK_INT >= 9) {
            return this.getSerialno();
        }
        return deviceId;
    }

    public String getIMEI() {
        if (!TextUtils.isEmpty((CharSequence)this.imei)) {
            return this.imei;
        }
        Object phone = this.getSystemServiceSafe("phone");
        if (phone == null) {
            return null;
        }
        String deviceId = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT < 29) {
                try {
                    deviceId = (String)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(8), new Object[0]);
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t.getMessage());
                }
            }
            if (TextUtils.isEmpty(deviceId)) {
                File keyFile = ResHelper.getCacheRootFile(this.context, "comm/.di");
                if (keyFile == null || !keyFile.exists()) {
                    return this.getWAbcd(1);
                }
                FileInputStream fis = new FileInputStream(keyFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                Object key = ois.readObject();
                String strKey = null;
                if (key != null && key instanceof char[]) {
                    char[] cKey = (char[])key;
                    strKey = String.valueOf(cKey);
                }
                ois.close();
                return strKey;
            }
            this.imei = deviceId;
            File keyFile = ResHelper.getCacheRootFile(this.context, "comm/.di");
            if (keyFile != null && keyFile.exists()) {
                keyFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(keyFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            char[] cKey = deviceId.toCharArray();
            oos.writeObject(cKey);
            oos.flush();
            oos.close();
            this.saveWabcd(deviceId, 1);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return deviceId;
    }

    public String[] queryIMEI() {
        try {
            int i;
            ArrayList<String> values;
            block17: {
                values = new ArrayList<String>();
                try {
                    if (!this.checkPermission("android.permission.READ_PHONE_STATE") || Build.VERSION.SDK_INT >= 29) break block17;
                    Object phone = this.getSystemServiceSafe("phone");
                    if (phone == null) {
                        return null;
                    }
                    String deviceId = null;
                    try {
                        deviceId = (String)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(8), new Object[0]);
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t.getMessage(), new Object[0]);
                    }
                    if (TextUtils.isEmpty((CharSequence)deviceId)) {
                        deviceId = "-1";
                    }
                    values.add(deviceId);
                    for (i = 0; i <= 5; ++i) {
                        try {
                            deviceId = (String)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(8), i);
                        }
                        catch (Throwable t) {
                            deviceId = null;
                        }
                        if (TextUtils.isEmpty((CharSequence)deviceId)) {
                            deviceId = "-1";
                        }
                        values.add(deviceId);
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
            }
            String[] parts = Strings.getString(54).split(";");
            String[][] keys = new String[parts.length][];
            for (i = 0; i < parts.length; ++i) {
                keys[i] = parts[i].split(",");
            }
            String[][] stringArrayArray = keys;
            int n = stringArrayArray.length;
            for (int j = 0; j < n; ++j) {
                String[] key;
                for (String name : key = stringArrayArray[j]) {
                    String[] props;
                    String prop = this.getSystemProperties(name);
                    for (String p : props = prop.split(",")) {
                        if (TextUtils.isEmpty((CharSequence)p) || values.contains(p)) continue;
                        values.add(p);
                    }
                }
            }
            if (values.size() > 0) {
                return values.toArray(new String[values.size()]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    private String getSystemProperties(String key) {
        try {
            String cls = ReflectHelper.importClass(Strings.getString(9));
            Object o = ReflectHelper.invokeStaticMethod(cls, Strings.getString(10), key);
            if (o != null) {
                return String.valueOf(o);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return "";
    }

    public String getSerialno() {
        if (!TextUtils.isEmpty((CharSequence)this.serialno)) {
            return this.serialno;
        }
        String serialno = null;
        if (Build.VERSION.SDK_INT >= 9 && Build.VERSION.SDK_INT < 26) {
            try {
                String clzName = ReflectHelper.importClass(Strings.getString(9));
                serialno = (String)ReflectHelper.invokeStaticMethod(clzName, Strings.getString(10), Strings.getString(11), "unknown");
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                serialno = null;
            }
        }
        if (TextUtils.isEmpty(serialno) || "unknown".equalsIgnoreCase(serialno)) {
            serialno = Build.SERIAL;
        }
        if (TextUtils.isEmpty((CharSequence)serialno) || "unknown".equalsIgnoreCase(serialno)) {
            try {
                if (this.checkPermission("android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT < 29) {
                    String buildClass = ReflectHelper.importClass("android.os.Build");
                    serialno = (String)ReflectHelper.invokeStaticMethod(buildClass, "getSerial", new Object[0]);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t.getMessage());
                serialno = null;
            }
        }
        if ("unknown".equalsIgnoreCase(serialno)) {
            serialno = null;
        }
        if (TextUtils.isEmpty((CharSequence)serialno)) {
            String local = this.getLocalSerial();
            if (!TextUtils.isEmpty((CharSequence)local)) {
                return local;
            }
        } else {
            this.serialno = serialno;
            serialno = serialno.trim();
            this.saveLocalSerial(serialno);
        }
        return serialno;
    }

    public String getDeviceData() {
        try {
            String data = this.getModel() + "|" + this.getOSVersionInt() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
            String deviString = this.getDeviceKey();
            if (deviString == null) {
                deviString = "";
            } else if (deviString.length() > 16) {
                deviString = deviString.substring(0, 16);
            }
            return this.Base64AES(data, deviString);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    public String getDeviceDataNotAES() {
        return this.getModel() + "|" + this.getOSVersionInt() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
    }

    public String Base64AES(String msg, String key) {
        String result = null;
        try {
            result = Base64.encodeToString((byte[])Data.AES128Encode(key, msg), (int)0);
            if (result.contains("\n")) {
                result = result.replace("\n", "");
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return result;
    }

    public int getOSVersionInt() {
        return Build.VERSION.SDK_INT;
    }

    public String getOSVersionName() {
        try {
            return Build.VERSION.RELEASE;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getOSLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getAppLanguage() {
        return this.context.getResources().getConfiguration().locale.getLanguage();
    }

    public String getOSCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getScreenSize() {
        int[] size = ResHelper.getScreenSize(this.context);
        if (this.context.getResources().getConfiguration().orientation == 1) {
            return size[0] + "x" + size[1];
        }
        return size[1] + "x" + size[0];
    }

    public String getCarrier() {
        try {
            Object tm = this.getSystemServiceSafe("phone");
            if (tm == null) {
                return "-1";
            }
            String operator = (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(12), new Object[0]);
            if (TextUtils.isEmpty((CharSequence)operator)) {
                operator = "-1";
            }
            return operator;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "-1";
        }
    }

    public String getCarrierName() {
        Object tm = this.getSystemServiceSafe("phone");
        if (tm == null) {
            return null;
        }
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                String operator = (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(13), new Object[0]);
                if (TextUtils.isEmpty((CharSequence)operator)) {
                    operator = null;
                }
                return operator;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public String getMCC() {
        String imsi = this.getIMSI();
        if (imsi != null && imsi.length() >= 3) {
            return imsi.substring(0, 3);
        }
        return null;
    }

    public String getMNC() {
        String imsi = this.getIMSI();
        if (imsi != null && imsi.length() >= 5) {
            return imsi.substring(3, 5);
        }
        return null;
    }

    public String getSimSerialNumber() {
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT < 29) {
                Object tm = this.getSystemServiceSafe("phone");
                if (tm == null) {
                    return "-1";
                }
                return (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(14), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t.getMessage());
        }
        return "-1";
    }

    public String getLN() {
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                if (!"-1".equals(this.ln) && this.isSensitiveDevice()) {
                    return this.ln;
                }
                Object tm = this.getSystemServiceSafe("phone");
                if (tm == null) {
                    return this.ln;
                }
                this.ln = (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(15), new Object[0]);
                return this.ln;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return this.ln;
    }

    public String getBluetoothName() {
        try {
            String adapterClass;
            Object myDevice;
            if (this.checkPermission("android.permission.BLUETOOTH") && (myDevice = ReflectHelper.invokeStaticMethod(adapterClass = ReflectHelper.importClass(Strings.getString(16)), Strings.getString(17), new Object[0])) != null) {
                return (String)ReflectHelper.invokeInstanceMethod(myDevice, Strings.getString(18), new Object[0]);
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().d(e);
        }
        return null;
    }

    public String getSignMD5() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 64);
            Signature[] signs = packageInfo.signatures;
            return Data.MD5(signs[0].toByteArray());
        }
        catch (Exception e) {
            MobLog.getInstance().w(e);
            return null;
        }
    }

    public String getSignMD5(String pkg) {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(pkg, 64);
            Signature[] signs = packageInfo.signatures;
            return Data.MD5(signs[0].toByteArray());
        }
        catch (Exception e) {
            MobLog.getInstance().w(e);
            return null;
        }
    }

    public Object getSystemServiceSafe(String name) {
        try {
            return this.context.getSystemService(name);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public String getNetworkType() {
        return NtFetcher.getInstance(this.context).getNtType();
    }

    public String getNetworkTypeForStatic() {
        String networkType = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)networkType) || "none".equals(networkType)) {
            return "none";
        }
        if (networkType.startsWith("5g") || networkType.startsWith("4g") || networkType.startsWith("3g") || networkType.startsWith("2g")) {
            return "cell";
        }
        if (networkType.startsWith("wifi")) {
            return "wifi";
        }
        return "other";
    }

    public String getDetailNetworkTypeForStatic() {
        try {
            String networkType = this.getNetworkType().toLowerCase();
            if (TextUtils.isEmpty((CharSequence)networkType) || "none".equals(networkType)) {
                return "none";
            }
            if (networkType.startsWith("wifi")) {
                return "wifi";
            }
            if (networkType.startsWith("5g")) {
                return "5g";
            }
            if (networkType.startsWith("4g")) {
                return "4g";
            }
            if (networkType.startsWith("3g")) {
                return "3g";
            }
            if (networkType.startsWith("2g")) {
                return "2g";
            }
            if (networkType.startsWith("bluetooth")) {
                return "bluetooth";
            }
            return networkType;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "none";
        }
    }

    public int getPlatformCode() {
        return 1;
    }

    public String getDeviceKey() {
        if (!TextUtils.isEmpty((CharSequence)this.cacheDeviceKey)) {
            return this.cacheDeviceKey;
        }
        String deviceKey = null;
        try {
            deviceKey = this.getDeviceKeyWithDuid("comm/dbs/.duid");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (TextUtils.isEmpty((CharSequence)deviceKey) || deviceKey.length() < 40) {
            deviceKey = this.genDeviceKey();
        }
        if (!TextUtils.isEmpty((CharSequence)deviceKey) && deviceKey.length() >= 40) {
            this.cacheDeviceKey = deviceKey.trim();
            return this.cacheDeviceKey;
        }
        try {
            deviceKey = this.getLocalDeviceKey();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            deviceKey = null;
        }
        if (!TextUtils.isEmpty((CharSequence)deviceKey) && deviceKey.length() >= 40) {
            this.cacheDeviceKey = deviceKey.trim();
            return this.cacheDeviceKey;
        }
        if (TextUtils.isEmpty((CharSequence)deviceKey) || deviceKey.length() < 40) {
            deviceKey = this.getCharAndNumr(40);
        }
        if (deviceKey != null) {
            try {
                deviceKey = deviceKey.trim();
                this.saveLocalDeviceKey(deviceKey);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return deviceKey;
    }

    private String genDeviceKey() {
        String newKey = null;
        try {
            String mac = this.getMacAddress();
            String udid = this.getDeviceId();
            String model = this.getModel();
            String data = mac + ":" + udid + ":" + model;
            byte[] bytes = Data.SHA1(data);
            newKey = Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            newKey = null;
        }
        return newKey;
    }

    public String getCharAndNumr(int length) {
        long currentTime = System.currentTimeMillis();
        long elapseTime = SystemClock.elapsedRealtime();
        long realTime = currentTime ^ elapseTime;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(realTime);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                char charValue = (char)(97 + random.nextInt(26));
                stringBuffer.insert(i + 1, charValue);
                continue;
            }
            stringBuffer.insert(stringBuffer.length(), random.nextInt(10));
        }
        return stringBuffer.toString().substring(0, 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceKeyWithDuid(String duidFilePath) throws Throwable {
        HashMap map;
        block19: {
            map = null;
            try {
                File file = ResHelper.getCacheRootFile(this.context, duidFilePath);
                if (file == null || !file.exists() || !file.isFile()) break block19;
                ObjectInputStream ois = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    map = (HashMap)ois.readObject();
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable fis) {}
                    }
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        if (map == null) {
            return null;
        }
        HashMap deviceInfo = (HashMap)map.get("deviceInfo");
        if (deviceInfo == null) {
            return null;
        }
        String deviceKey = "";
        try {
            String mac = (String)deviceInfo.get("mac");
            String deviceId = (String)deviceInfo.get("imei");
            if (TextUtils.isEmpty((CharSequence)deviceId) && Build.VERSION.SDK_INT >= 9) {
                deviceId = (String)deviceInfo.get("serialno");
            }
            String model = (String)deviceInfo.get("model");
            String data = mac + ":" + deviceId + ":" + model;
            byte[] bytes = Data.SHA1(data);
            deviceKey = Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            deviceKey = null;
        }
        return deviceKey;
    }

    private String getLocalDeviceKey() throws Throwable {
        File dk;
        File keyFile;
        if (!this.getSdcardState()) {
            return null;
        }
        String sdPath = this.getSdcardPath();
        File cacheRoot = new File(sdPath, "ShareSDK");
        if (cacheRoot.exists() && (keyFile = new File(cacheRoot, ".dk")).exists() && (dk = ResHelper.getCacheRootFile(this.context, ".dk")) != null && keyFile.renameTo(dk)) {
            keyFile.delete();
        }
        if ((keyFile = ResHelper.getCacheRootFile(this.context, ".dk")) != null && !keyFile.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(keyFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object key = ois.readObject();
        String strKey = null;
        if (key != null && key instanceof char[]) {
            char[] cKey = (char[])key;
            strKey = String.valueOf(cKey);
        }
        ois.close();
        return strKey;
    }

    private void saveLocalDeviceKey(String key) throws Throwable {
        if (!this.getSdcardState()) {
            return;
        }
        File keyFile = ResHelper.getCacheRootFile(this.context, ".dk");
        if (keyFile != null && keyFile.exists()) {
            keyFile.delete();
        }
        FileOutputStream fos = new FileOutputStream(keyFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        char[] cKey = key.toCharArray();
        oos.writeObject(cKey);
        oos.flush();
        oos.close();
    }

    public String getPackageName() {
        return this.context.getPackageName();
    }

    public String getAppName() {
        try {
            int appLbl;
            ApplicationInfo ai = this.context.getApplicationInfo();
            String appName = ai.name;
            if (appName != null) {
                if (Build.VERSION.SDK_INT >= 25 && !appName.endsWith(".*")) {
                    try {
                        ReflectHelper.importClass(appName);
                        appName = null;
                    }
                    catch (Throwable throwable) {}
                } else {
                    return appName;
                }
            }
            if ((appLbl = ai.labelRes) > 0) {
                try {
                    appName = this.context.getString(appLbl);
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
            } else {
                appName = String.valueOf(ai.nonLocalizedLabel);
            }
            return appName;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    public String getAppName(String pkg) {
        String name = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)pkg)) {
                PackageManager pm = this.context.getPackageManager();
                PackageInfo pi = pm.getPackageInfo(pkg, 1);
                name = pi.applicationInfo.loadLabel(pm).toString();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return name;
    }

    public int getAppVersion() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            if (Build.VERSION.SDK_INT >= 28) {
                return (int)pi.getLongVersionCode();
            }
            return pi.versionCode;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return 0;
        }
    }

    public String getAppVersionName() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionName;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return "1.0";
        }
    }

    public ArrayList<HashMap<String, String>> getIA(boolean includeSystemApp) {
        return this.getIA(includeSystemApp, true);
    }

    public ArrayList<HashMap<String, String>> getIA(boolean includeSystemApp, boolean includeName) {
        return this.getAL(false, includeSystemApp, includeName);
    }

    public ArrayList<HashMap<String, String>> getSA() {
        return this.getAL(true, true);
    }

    public ArrayList<HashMap<String, String>> getAA() {
        return this.getAL(false, true);
    }

    public synchronized ArrayList<HashMap<String, String>> getAL(boolean onlySystem, boolean includeSystemApp) {
        return this.getAL(onlySystem, includeSystemApp, true);
    }

    public synchronized ArrayList<HashMap<String, String>> getAL(boolean onlySystem, boolean includeSystemApp, boolean includeName) {
        try {
            ArrayList<String> packages = this.getPL();
            ArrayList<HashMap<String, String>> apps = new ArrayList<HashMap<String, String>>();
            PackageManager pm = this.context.getPackageManager();
            HashMap<String, String> ansMap = null;
            boolean ansChanged = false;
            if (includeName) {
                ansMap = this.getANS();
            }
            for (String pkg : packages) {
                PackageInfo pi = null;
                try {
                    pi = pm.getPackageInfo(pkg, 0);
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
                if (pi != null) {
                    if (onlySystem ? !this.isSystemApp(pi) : !includeSystemApp && this.isSystemApp(pi)) continue;
                    HashMap<String, String> app = new HashMap<String, String>();
                    app.put("pkg", pi.packageName);
                    if (includeName) {
                        String tmpName = null;
                        if (ansMap != null) {
                            tmpName = ansMap.get(Data.MD5(pi.packageName));
                        } else {
                            ansMap = new HashMap();
                        }
                        if (TextUtils.isEmpty(tmpName)) {
                            CharSequence appLabel = null;
                            try {
                                appLabel = pi.applicationInfo.loadLabel(pm);
                            }
                            catch (Throwable t) {
                                try {
                                    appLabel = pm.getText(pi.packageName, pi.applicationInfo.labelRes, pi.applicationInfo);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            tmpName = appLabel == null ? pi.packageName : appLabel.toString();
                            ansMap.put(Data.MD5(pi.packageName), tmpName);
                            ansChanged = true;
                        }
                        app.put("name", tmpName);
                    }
                    app.put("version", pi.versionName);
                    app.put("visible", pm.getLaunchIntentForPackage(pi.packageName) == null ? "0" : "1");
                    app.put("enable", pi.applicationInfo.enabled ? "1" : "0");
                    app.put("firstInstallTime", String.valueOf(pi.firstInstallTime));
                    app.put("lastUpdateTime", String.valueOf(pi.lastUpdateTime));
                    apps.add(app);
                }
                if (!includeName || !ansChanged) continue;
                this.saveANS(ansMap);
            }
            return apps;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return new ArrayList<HashMap<String, String>>();
        }
    }

    private HashMap<String, String> getANS() {
        HashMap map = null;
        try {
            map = (HashMap)ResHelper.readObjectFromFile(ResHelper.getDataCacheFile(this.context, ".ans").getAbsolutePath());
        }
        catch (Throwable t1) {
            try {
                MobLog.getInstance().w(t1);
                ResHelper.getDataCacheFile(this.context, ".ans").delete();
            }
            catch (Throwable t2) {
                MobLog.getInstance().w(t2);
            }
        }
        return map;
    }

    private void saveANS(HashMap<String, String> ansMap) {
        try {
            if (ansMap != null) {
                ResHelper.saveObjectToFile(ResHelper.getDataCacheFile(this.context, ".ans").getAbsolutePath(), ansMap);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    private ArrayList<String> getPL() {
        ArrayList<String> packages = new ArrayList<String>();
        try {
            String clz = ReflectHelper.importClass(Strings.getString(42));
            Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
            Object p = ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), Strings.getString(20));
            InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod(p, Strings.getString(45), new Object[0]);
            InputStreamReader isr = new InputStreamReader(is, "utf-8");
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                String prefix;
                if ((line = line.trim()).length() > 8 && (prefix = line.substring(0, 8)).equalsIgnoreCase("package:") && !TextUtils.isEmpty((CharSequence)(line = line.substring(8).trim()))) {
                    packages.add(line);
                }
                line = br.readLine();
            }
            br.close();
            ReflectHelper.invokeInstanceMethod(p, Strings.getString(51), new Object[0]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (packages.isEmpty()) {
            try {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.addCategory(Strings.getString(74));
                PackageManager pm = this.context.getPackageManager();
                List list = pm.queryIntentActivities(intent, 0);
                for (ResolveInfo item : list) {
                    if (item == null || item.activityInfo == null || TextUtils.isEmpty((CharSequence)item.activityInfo.packageName)) continue;
                    packages.add(item.activityInfo.packageName);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return packages;
    }

    private boolean isSystemApp(PackageInfo pi) {
        boolean isSysApp = (pi.applicationInfo.flags & 1) == 1;
        boolean isSysUpd = (pi.applicationInfo.flags & 0x80) == 1;
        return isSysApp || isSysUpd;
    }

    public String getNetworkOperator() {
        Object tm = this.getSystemServiceSafe("phone");
        if (tm == null) {
            return null;
        }
        try {
            return (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(21), new Object[0]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public boolean checkPermission(String permission) throws Throwable {
        int res;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                ReflectHelper.importClass("android.content.Context");
                Integer ret = (Integer)ReflectHelper.invokeInstanceMethod((Object)this.context, Strings.getString(22), permission);
                res = ret == null ? -1 : ret;
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                res = -1;
            }
        } else {
            res = this.context.getPackageManager().checkPermission(permission, this.getPackageName());
        }
        return res == 0;
    }

    public boolean amIOnForeground() {
        try {
            if (Build.VERSION.SDK_INT > 27) {
                return !DeviceHelper.isBackground(this.context);
            }
            Object thread = DeviceHelper.currentActivityThread();
            Map activities = (Map)ReflectHelper.getInstanceField(thread, Strings.getString(23));
            for (Object activity : activities.values()) {
                Boolean stopped = (Boolean)ReflectHelper.getInstanceField(activity, Strings.getString(24));
                if (stopped.booleanValue()) continue;
                return true;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    private static boolean isBackground(Context context) {
        try {
            Context app = context.getApplicationContext();
            ActivityManager activityManager = (ActivityManager)app.getSystemService("activity");
            List appProcessList = activityManager.getRunningAppProcesses();
            if (appProcessList != null && !appProcessList.isEmpty()) {
                String pkgName = context.getPackageName();
                for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
                    if (!process.processName.equals(pkgName)) continue;
                    return process.importance == 400;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    public boolean getSdcardState() {
        if (!this.hasSdcardWritePermission) {
            try {
                this.hasSdcardWritePermission = this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE") && "mounted".equals(Environment.getExternalStorageState());
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return this.hasSdcardWritePermission;
    }

    public String getSdcardPath() {
        try {
            if (Build.VERSION.SDK_INT >= 29 && this.context.getApplicationInfo().targetSdkVersion >= 29) {
                return this.context.getExternalFilesDir(null).getAbsolutePath();
            }
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getAndroidID() {
        try {
            String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
            MobLog.getInstance().i("getAndroidID === " + androidId, new Object[0]);
            return androidId;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAdvertisingID() throws Throwable {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new Throwable("Do not call this function from the main thread !");
        }
        if (!TextUtils.isEmpty((CharSequence)this.advertiseID)) {
            return this.advertiseID;
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        GSConnection gsc = new GSConnection();
        try {
            this.context.bindService(intent, (ServiceConnection)gsc, 1);
            IBinder binder = gsc.takeBinder();
            if (binder == null) {
                String string = this.advertiseID;
                return string;
            }
            Parcel input = Parcel.obtain();
            Parcel output = Parcel.obtain();
            input.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
            binder.transact(1, input, output, 0);
            output.readException();
            this.advertiseID = output.readString();
            output.recycle();
            input.recycle();
            String string = this.advertiseID;
            return string;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            String string = this.advertiseID;
            return string;
        }
        finally {
            this.context.unbindService((ServiceConnection)gsc);
        }
    }

    public void hideSoftInput(View view) {
        Object service = this.getSystemServiceSafe("input_method");
        if (service == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)service;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public void showSoftInput(View view) {
        Object service = this.getSystemServiceSafe("input_method");
        if (service == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)service;
        imm.toggleSoftInputFromWindow(view.getWindowToken(), 2, 0);
    }

    public String getIMSI() {
        String[] queryIMSI;
        Object phone = this.getSystemServiceSafe("phone");
        if (phone == null) {
            return null;
        }
        String imsi = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT < 29) {
                imsi = (String)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(25), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t.getMessage());
        }
        if ((imsi == null || imsi.length() < 15) && (queryIMSI = this.queryIMSI()) != null && queryIMSI.length > 0 && queryIMSI[0].length() >= 15) {
            imsi = queryIMSI[0];
        }
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            return null;
        }
        return imsi;
    }

    public String[] queryIMSI() {
        try {
            String[] props;
            String prop = this.getSystemProperties(Strings.getString(55));
            ArrayList<String> values = new ArrayList<String>();
            for (String p : props = prop.split(",")) {
                if (TextUtils.isEmpty((CharSequence)p) || values.contains(p)) continue;
                values.add(p);
            }
            if (values.size() > 0) {
                return values.toArray(new String[values.size()]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public String getIPAddress() {
        try {
            if (this.checkPermission("android.permission.INTERNET")) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                        return inetAddress.getHostAddress();
                    }
                }
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return "0.0.0.0";
    }

    public Location getLocation(int GPSTimeout, int networkTimeout, boolean useLastKnown) {
        try {
            if (this.checkPermission("android.permission.ACCESS_FINE_LOCATION") || Build.VERSION.SDK_INT >= 29 && this.checkPermission("android.permission.ACCESS_BACKGROUND_LOCATION")) {
                return LHelper.getInstance().getLocation(this.context, GPSTimeout, networkTimeout, useLastKnown);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public HashMap<String, String> ping(String address, int count, int packetsize) {
        ArrayList<Float> sucRes = new ArrayList<Float>();
        try {
            String cmd = "ping -c " + count + " -s " + packetsize + " " + address;
            int bytes = packetsize + 8;
            String clz = ReflectHelper.importClass(Strings.getString(42));
            Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
            java.lang.Process p = (java.lang.Process)ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), cmd);
            InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod((Object)p, Strings.getString(45), new Object[0]);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith(bytes + " bytes from")) {
                    if (line.endsWith("ms")) {
                        line = line.substring(0, line.length() - 2).trim();
                    } else if (line.endsWith("s")) {
                        line = line.substring(0, line.length() - 1).trim() + "000";
                    }
                    int i = line.indexOf("time=");
                    if (i > 0) {
                        line = line.substring(i + 5).trim();
                        try {
                            sucRes.add(Float.valueOf(Float.parseFloat(line)));
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                    }
                }
                line = br.readLine();
            }
            p.waitFor();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        int sucCount = sucRes.size();
        int fldCount = count - sucRes.size();
        float min = 0.0f;
        float max = 0.0f;
        float average = 0.0f;
        if (sucCount > 0) {
            min = Float.MAX_VALUE;
            for (int i = 0; i < sucCount; ++i) {
                float item = ((Float)sucRes.get(i)).floatValue();
                if (item < min) {
                    min = item;
                }
                if (item > max) {
                    max = item;
                }
                average += item;
            }
            average /= (float)sucCount;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", address);
        map.put("transmitted", String.valueOf(count));
        map.put("received", String.valueOf(sucCount));
        map.put("loss", String.valueOf(fldCount));
        map.put("min", String.valueOf(min));
        map.put("max", String.valueOf(max));
        map.put("avg", String.valueOf(average));
        return map;
    }

    public int getCellId() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && !"CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(27), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCellLac() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && !"CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(28), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getPsc() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && !"CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(63), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCdmaLat() {
        int lat = -1;
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                lat = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(56), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        if (lat == Integer.MAX_VALUE) {
            lat = -1;
        }
        return lat;
    }

    public int getCdmaLon() {
        int lon = -1;
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                lon = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(57), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        if (lon == Integer.MAX_VALUE) {
            lon = -1;
        }
        return lon;
    }

    public int getCdmaBid() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(58), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCdmaSid() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(59), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCdmaNid() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSafe("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(60), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public ArrayList<HashMap<String, Object>> getNeighboringCellInfo() {
        try {
            List list;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && !this.isScopedStorage() && (tm = this.getSystemServiceSafe("phone")) != null && (list = (List)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(61), new Object[0])) != null && list.size() > 0) {
                ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
                for (Object obj : list) {
                    int cid = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(27), new Object[0]), -1);
                    int lac = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(28), new Object[0]), -1);
                    int rssi = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(62), new Object[0]), -1);
                    int psc = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(63), new Object[0]), -1);
                    int networkType = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(19), new Object[0]), -1);
                    if (cid == -1 || lac == -1) continue;
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("cell", cid);
                    map.put("lac", lac);
                    map.put("rssi", rssi);
                    map.put("psc", psc);
                    map.put("networkType", networkType);
                    resultList.add(map);
                }
                if (resultList.size() > 0) {
                    return resultList;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public String getDeviceType() {
        try {
            UiModeManager um = (UiModeManager)this.getSystemServiceSafe("uimode");
            if (um != null) {
                int type = um.getCurrentModeType();
                switch (type) {
                    case 1: {
                        return "NO_UI";
                    }
                    case 2: {
                        return "DESK";
                    }
                    case 3: {
                        return "CAR";
                    }
                    case 4: {
                        return "TELEVISION";
                    }
                    case 5: {
                        return "APPLIANCE";
                    }
                    case 6: {
                        return "WATCH";
                    }
                    case 7: {
                        return "VRHEADSET";
                    }
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return "UNDEFINED";
    }

    public int cscreen() {
        PowerManager pm = (PowerManager)this.context.getSystemService("power");
        if (!pm.isScreenOn()) {
            return 0;
        }
        KeyguardManager mKeyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        if (!mKeyguardManager.inKeyguardRestrictedInputMode()) {
            return 1;
        }
        return 2;
    }

    public List<Object[]> getIntentA(String scheme) {
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            return null;
        }
        Intent intent = new Intent();
        Uri uri = Uri.parse((String)scheme);
        intent.setData(uri);
        PackageManager pm = this.context.getPackageManager();
        List tmpList = pm.queryIntentActivities(intent, 0);
        if (tmpList == null || tmpList.isEmpty()) {
            return null;
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (ResolveInfo item : tmpList) {
            Intent tmpIntent = new Intent();
            tmpIntent.setFlags(0x10800000);
            tmpIntent.setData(uri);
            String md5 = this.getSignMD5(item.activityInfo.packageName);
            tmpIntent.setComponent(new ComponentName(item.activityInfo.packageName, item.activityInfo.name));
            Object[] objs = new Object[]{item.activityInfo.packageName, item.activityInfo.name, tmpIntent, md5, item.activityInfo.exported};
            list.add(objs);
        }
        return list;
    }

    public String getDefaultResolvePkg(String scheme) {
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            return null;
        }
        Intent intent = new Intent();
        Uri uri = Uri.parse((String)scheme);
        intent.setData(uri);
        PackageManager pm = this.context.getPackageManager();
        ResolveInfo info = pm.resolveActivity(intent, 65536);
        return info == null ? null : (info.activityInfo == null ? null : info.activityInfo.packageName);
    }

    public List<String> getResolvePkgs(String scheme) {
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            return null;
        }
        Intent intent = new Intent();
        Uri uri = Uri.parse((String)scheme);
        intent.setData(uri);
        PackageManager pm = this.context.getPackageManager();
        List tmpList = pm.queryIntentActivities(intent, 0);
        if (tmpList == null || tmpList.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ResolveInfo item : tmpList) {
            if (item.activityInfo == null || item.activityInfo.packageName == null || list.contains(item.activityInfo.packageName)) continue;
            list.add(item.activityInfo.packageName);
        }
        return list;
    }

    public List<Object[]> getIntentSP(String pkg) {
        if (TextUtils.isEmpty((CharSequence)pkg)) {
            return null;
        }
        Intent intent = new Intent();
        intent.setPackage(pkg);
        PackageManager pm = this.context.getPackageManager();
        List tmpList = pm.queryIntentServices(intent, 0);
        if (tmpList == null || tmpList.isEmpty()) {
            return null;
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (ResolveInfo item : tmpList) {
            Intent tmpIntent = new Intent();
            tmpIntent.setComponent(new ComponentName(item.serviceInfo.packageName, item.serviceInfo.name));
            String md5 = this.getSignMD5(item.serviceInfo.packageName);
            Object[] objs = new Object[]{item.serviceInfo.packageName, item.serviceInfo.name, tmpIntent, md5};
            list.add(objs);
        }
        return list;
    }

    public String gb(Context context) {
        block4: {
            try {
                if (Build.VERSION.SDK_INT >= 11) {
                    ClipboardManager cm = (ClipboardManager)context.getSystemService("clipboard");
                    ClipData clipData = cm.getPrimaryClip();
                    if (clipData != null && clipData.getItemCount() > 0) {
                        return clipData.getItemAt(0).getText().toString();
                    }
                    break block4;
                }
                ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
                return (String)clipboardManager.getText();
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                return null;
            }
        }
        return null;
    }

    public int cb(Context context, String str) {
        try {
            if (Build.VERSION.SDK_INT >= 11) {
                ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
                ClipData clipData = ClipData.newPlainText((CharSequence)"", (CharSequence)str);
                clipboardManager.setPrimaryClip(clipData);
            } else {
                ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
                clipboardManager.setText((CharSequence)str);
            }
            return 1;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return 2;
        }
    }

    public int sap(Context context, String packageName) throws Throwable {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = packageManager.getLaunchIntentForPackage(packageName);
            if (intent == null) {
                return 0;
            }
            intent.addFlags(0x10800000);
            context.startActivity(intent);
            return 1;
        }
        catch (ActivityNotFoundException t) {
            MobLog.getInstance().d(t);
            return 0;
        }
    }

    public int ca(Context context, String packageName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = packageManager.getLaunchIntentForPackage(packageName);
            if (intent != null) {
                return this.cs(context, intent);
            }
            return 0;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return 3;
        }
    }

    public int sa(Context context, Intent intent) throws Throwable {
        try {
            context.startActivity(intent);
            return 1;
        }
        catch (ActivityNotFoundException e) {
            MobLog.getInstance().d(e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saInUI(final Context context, final Intent intent) {
        final int[] res = new int[1];
        UIHandler.sendEmptyMessage(0, new Handler.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean handleMessage(Message msg) {
                int[] nArray = res;
                synchronized (res) {
                    try {
                        res[0] = DeviceHelper.this.sa(context, intent);
                    }
                    catch (Throwable t) {
                        res[0] = 2;
                        MobLog.getInstance().d(t);
                    }
                    finally {
                        res.notifyAll();
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
            }
        });
        int[] nArray = res;
        synchronized (res) {
            try {
                res.wait();
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
            return res[0];
        }
    }

    public int sh(Context context) throws Throwable {
        try {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setFlags(0x10000000);
            intent.addCategory("android.intent.category.HOME");
            intent.addCategory("android.intent.category.DEFAULT");
            context.startActivity(intent);
            return 1;
        }
        catch (ActivityNotFoundException e) {
            MobLog.getInstance().d(e);
            return 0;
        }
    }

    public int ih(Context context) throws Throwable {
        String top = DeviceHelper.getTopApp(context);
        if (top != null && DeviceHelper.getLauncherPackageNames(context).contains(top)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ir(Context context, String pkg) throws Throwable {
        List<Object[]> list;
        if (Build.VERSION.SDK_INT < 21) {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List list2 = am.getRunningAppProcesses();
            if (list2 != null && list2.size() > 0) {
                for (ActivityManager.RunningAppProcessInfo item : list2) {
                    if (!item.processName.equals(pkg)) continue;
                    return 1;
                }
            }
            return 0;
        }
        if (Build.VERSION.SDK_INT <= 24) {
            java.lang.Process p = null;
            FilterInputStream dis = null;
            FilterOutputStream dos = null;
            try {
                String clz = ReflectHelper.importClass(Strings.getString(42));
                Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
                p = (java.lang.Process)ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), Strings.getString(46));
                OutputStream os = (OutputStream)ReflectHelper.invokeInstanceMethod((Object)p, Strings.getString(128), new Object[0]);
                InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod((Object)p, Strings.getString(45), new Object[0]);
                dos = new DataOutputStream(os);
                dis = new DataInputStream(is);
                String cmd = "ps | grep " + pkg;
                dos.write(cmd.getBytes());
                ((DataOutputStream)dos).writeBytes("\n");
                ((DataOutputStream)dos).flush();
                ((DataOutputStream)dos).writeBytes("exit\n");
                ((DataOutputStream)dos).flush();
                String line = null;
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(dis));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                p.waitFor();
                int n = TextUtils.isEmpty((CharSequence)sb.toString().trim()) ? 0 : 1;
                return n;
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
            finally {
                if (p != null) {
                    try {
                        p.destroy();
                    }
                    catch (Throwable throwable) {}
                }
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable) {}
                }
                p = null;
                dos = null;
                dis = null;
            }
        }
        if (Build.VERSION.SDK_INT < 27 && (list = this.getIntentSP(pkg)) != null && list.size() > 0) {
            for (Object[] item : list) {
                int s = this.cs(context, (Intent)item[2]);
                if (s == 0) {
                    return 0;
                }
                if (s != 1 && s != 2) continue;
                return 1;
            }
        }
        return 2;
    }

    private static List<String> getLauncherPackageNames(Context context) throws Throwable {
        ArrayList<String> names = new ArrayList<String>();
        PackageManager manager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        intent.addCategory("android.intent.category.DEFAULT");
        List list = manager.queryIntentActivities(intent, 65536);
        for (ResolveInfo info : list) {
            names.add(info.activityInfo.packageName);
        }
        return names;
    }

    public static String getTopApp(Context context) throws Throwable {
        if (Build.VERSION.SDK_INT >= 21) {
            UsageStatsManager m = (UsageStatsManager)context.getSystemService("usagestats");
            if (null != m) {
                long now = System.currentTimeMillis();
                List stats = m.queryUsageStats(4, now - 3600000L, now);
                String ta = "";
                if (stats != null && !stats.isEmpty()) {
                    int j = 0;
                    for (int i = 0; i < stats.size(); ++i) {
                        if (((UsageStats)stats.get(i)).getLastTimeUsed() <= ((UsageStats)stats.get(j)).getLastTimeUsed()) continue;
                        j = i;
                    }
                    ta = ((UsageStats)stats.get(j)).getPackageName();
                }
                return ta;
            }
        } else {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List rti = am.getRunningTasks(1);
            return ((ActivityManager.RunningTaskInfo)rti.get((int)0)).topActivity.getPackageName();
        }
        return null;
    }

    public Activity getTopActivity() {
        try {
            if (Build.VERSION.SDK_INT > 27) {
                return null;
            }
            Object thread = DeviceHelper.currentActivityThread();
            Map activities = (Map)ReflectHelper.getInstanceField(thread, Strings.getString(23));
            for (Object activity : activities.values()) {
                Boolean paused = (Boolean)ReflectHelper.getInstanceField(activity, Strings.getString(29));
                if (paused.booleanValue()) continue;
                return (Activity)ReflectHelper.getInstanceField(activity, Strings.getString(30));
            }
            for (Object activity : activities.values()) {
                Boolean stopped = (Boolean)ReflectHelper.getInstanceField(activity, Strings.getString(24));
                if (stopped.booleanValue()) continue;
                return (Activity)ReflectHelper.getInstanceField(activity, Strings.getString(30));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object currentActivityThread() {
        final ReflectHelper.ReflectRunnable<Void, Object> mainThreadAct = new ReflectHelper.ReflectRunnable<Void, Object>(){

            @Override
            public Object run(Void arg) {
                try {
                    String clzName = ReflectHelper.importClass(Strings.getString(31));
                    return ReflectHelper.invokeStaticMethod(clzName, Strings.getString(32), new Object[0]);
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                    return null;
                }
            }
        };
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            return mainThreadAct.run(null);
        }
        final Object lock = new Object();
        final Object[] output = new Object[1];
        Object object = lock;
        synchronized (object) {
            UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean handleMessage(Message msg) {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            output[0] = mainThreadAct.run(null);
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                        finally {
                            try {
                                lock.notify();
                            }
                            catch (Throwable t) {
                                MobLog.getInstance().w(t);
                            }
                        }
                    }
                    return false;
                }
            });
            try {
                lock.wait();
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return output[0];
    }

    public static Context getApplication() {
        try {
            Object actThread = DeviceHelper.currentActivityThread();
            if (actThread != null) {
                return (Context)ReflectHelper.invokeInstanceMethod(actThread, Strings.getString(33), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public HashMap<String, Object> getCurrentWifiInfo() {
        block20: {
            try {
                Object info;
                Object wifi;
                if (!this.checkPermission("android.permission.ACCESS_WIFI_STATE") || (wifi = this.getSystemServiceSafe("wifi")) == null || (info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0])) == null) break block20;
                HashMap<String, Object> map = new HashMap<String, Object>();
                try {
                    String bssid = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(4), new Object[0]);
                    map.put("bssid", bssid);
                }
                catch (Throwable bssid) {
                    // empty catch block
                }
                try {
                    String ssid = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(3), new Object[0]);
                    ssid = ssid == null ? null : ssid.replace("\"", "");
                    map.put("ssid", ssid);
                }
                catch (Throwable ssid) {
                    // empty catch block
                }
                try {
                    int ip = (Integer)ReflectHelper.invokeInstanceMethod(info, Strings.getString(79), new Object[0]);
                    map.put("ip", ip);
                }
                catch (Throwable ip) {
                    // empty catch block
                }
                try {
                    String mac = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(5), new Object[0]);
                    map.put("wlanMac", mac);
                }
                catch (Throwable mac) {
                    // empty catch block
                }
                try {
                    boolean hidden = (Boolean)ReflectHelper.invokeInstanceMethod(info, Strings.getString(80), new Object[0]);
                    map.put("hidden", hidden);
                }
                catch (Throwable hidden) {
                    // empty catch block
                }
                try {
                    int speed = (Integer)ReflectHelper.invokeInstanceMethod(info, Strings.getString(81), new Object[0]);
                    map.put("speed", speed);
                }
                catch (Throwable speed) {
                    // empty catch block
                }
                try {
                    int networkId = (Integer)ReflectHelper.invokeInstanceMethod(info, Strings.getString(60), new Object[0]);
                    map.put("networkId", networkId);
                }
                catch (Throwable networkId) {
                    // empty catch block
                }
                try {
                    int rssi = (Integer)ReflectHelper.invokeInstanceMethod(info, Strings.getString(62), new Object[0]);
                    map.put("level", rssi);
                }
                catch (Throwable rssi) {
                    // empty catch block
                }
                try {
                    int frequency = (Integer)ReflectHelper.invokeInstanceMethod(info, Strings.getString(82), new Object[0]);
                    map.put("frequency", frequency);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return map;
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return null;
    }

    public ArrayList<HashMap<String, Object>> getAvailableWifiList() {
        block21: {
            try {
                String[] fldsToString;
                String[] fields;
                String[] fldsToStringTmp;
                String[] fieldsTmp;
                if (!this.checkPermission("android.permission.ACCESS_WIFI_STATE")) break block21;
                Object wifi = this.getSystemServiceSafe("wifi");
                if (wifi == null) {
                    return null;
                }
                List list = (List)ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(34), new Object[0]);
                if (list == null) {
                    return null;
                }
                if (Build.VERSION.SDK_INT > 27) {
                    fieldsTmp = TextUtils.split((String)Strings.getString(72), (String)",");
                    fldsToStringTmp = TextUtils.split((String)Strings.getString(73), (String)",");
                    fields = fieldsTmp;
                    fldsToString = fldsToStringTmp;
                } else {
                    fieldsTmp = TextUtils.split((String)Strings.getString(35), (String)",");
                    fldsToStringTmp = TextUtils.split((String)Strings.getString(36), (String)",");
                    fields = fieldsTmp;
                    fldsToString = fldsToStringTmp;
                }
                ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
                for (Object sr : list) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String ssid = null;
                    for (String fld : fields) {
                        try {
                            fld = fld.trim();
                            if ("SSID".equals(fld)) {
                                ssid = (String)ReflectHelper.getInstanceField(sr, fld);
                                if (TextUtils.isEmpty((CharSequence)ssid)) break;
                                map.put(fld, ssid);
                                continue;
                            }
                            if ("capabilities".equals(fld)) {
                                String capabilities = (String)ReflectHelper.getInstanceField(sr, fld);
                                if (capabilities != null && capabilities.contains("[IBSS]")) {
                                    ssid = null;
                                    break;
                                }
                                map.put(fld, capabilities);
                                continue;
                            }
                            map.put(fld, ReflectHelper.getInstanceField(sr, fld));
                        }
                        catch (Throwable capabilities) {
                            // empty catch block
                        }
                    }
                    if (TextUtils.isEmpty(ssid)) continue;
                    for (String fld : fldsToString) {
                        try {
                            fld = fld.trim();
                            Object o = ReflectHelper.getInstanceField(sr, fld);
                            map.put(fld, o == null ? null : o.toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        Object o = ReflectHelper.invokeInstanceMethod(sr, Strings.getString(37), new Object[0]);
                        map.put(Strings.getString(39), o);
                    }
                    catch (Throwable o) {
                        // empty catch block
                    }
                    try {
                        if (Build.VERSION.SDK_INT < 28) {
                            List anqpLines = (List)ReflectHelper.getInstanceField(sr, Strings.getString(38));
                            map.put(Strings.getString(38), anqpLines == null ? null : new ArrayList(anqpLines));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    result.add(map);
                }
                return result;
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return null;
    }

    private int getWifiSecurity(String capabilities) {
        if (capabilities != null) {
            if (capabilities.contains("WEP")) {
                return 1;
            }
            if (capabilities.contains("PSK")) {
                return 2;
            }
            if (capabilities.contains("EAP")) {
                return 3;
            }
        }
        return 0;
    }

    public boolean scanWifiList() {
        try {
            if (this.checkPermission("android.permission.CHANGE_WIFI_STATE")) {
                Object wifi = this.getSystemServiceSafe("wifi");
                if (wifi == null) {
                    return false;
                }
                return (Boolean)ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(40), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    public int getStatusBarHeight() {
        if (Build.VERSION.SDK_INT < 28) {
            try {
                String clzName = ReflectHelper.importClass("com.android.internal.R$dimen");
                int resId = (Integer)ReflectHelper.getStaticField(clzName, "status_bar_height");
                return this.context.getResources().getDimensionPixelSize(resId);
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return -1;
    }

    public boolean isPackageInstalled(String packageName) {
        try {
            return this.context.getPackageManager().getPackageInfo(packageName, 0) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public List<Object[]> getIntent(String scheme) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)scheme)) {
            return null;
        }
        Intent intent = new Intent();
        Uri uri = Uri.parse((String)scheme);
        intent.setData(uri);
        PackageManager pm = this.context.getPackageManager();
        List tmpList = pm.queryIntentServices(intent, 0);
        if (tmpList == null || tmpList.isEmpty()) {
            return null;
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (ResolveInfo item : tmpList) {
            Intent tmpIntent = new Intent();
            tmpIntent.setData(uri);
            tmpIntent.setComponent(new ComponentName(item.serviceInfo.packageName, item.serviceInfo.name));
            Object[] objs = new Object[]{item.serviceInfo.packageName, item.serviceInfo.name, tmpIntent};
            list.add(objs);
        }
        return list;
    }

    public int ss(Context context, Intent intent) throws Throwable {
        try {
            return context.startService(intent) == null ? 0 : 1;
        }
        catch (SecurityException t) {
            MobLog.getInstance().d(t);
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int bs(final Context context, Intent intent) throws Throwable {
        final boolean[] result = new boolean[]{false};
        try {
            boolean isCanBeBind = context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    try {
                        boolean[] blArray = result;
                        synchronized (result) {
                            result[0] = true;
                            result.notifyAll();
                            context.unbindService((ServiceConnection)this);
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                        }
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                    {
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceDisconnected(ComponentName name) {
                    try {
                        boolean[] blArray = result;
                        synchronized (result) {
                            result.notifyAll();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                        }
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                    {
                        return;
                    }
                }
            }, 1);
            if (!isCanBeBind) return 0;
            for (long timeout = 200L; !result[0] && timeout > 0L; timeout -= 20L) {
                boolean[] blArray = result;
                // MONITORENTER : result
                result.wait(20L);
                // MONITOREXIT : blArray
            }
            if (!result[0]) return 2;
            return 1;
        }
        catch (SecurityException e) {
            MobLog.getInstance().d(e);
            return 3;
        }
    }

    public int cs(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT < 26) {
            try {
                ComponentName componentName = intent.getComponent();
                String pkg = componentName.getPackageName();
                String clz = componentName.getClassName();
                ActivityManager am = (ActivityManager)context.getSystemService("activity");
                List serviceList = am.getRunningServices(1000);
                boolean aa = false;
                boolean sa = false;
                if (serviceList != null && !serviceList.isEmpty()) {
                    for (ActivityManager.RunningServiceInfo item : serviceList) {
                        String tmpPkg = item.service.getPackageName();
                        String tmpClz = item.service.getClassName();
                        if (!tmpPkg.equals(pkg)) continue;
                        aa = true;
                        if (!tmpClz.equals(clz)) continue;
                        sa = true;
                        break;
                    }
                }
                if (aa) {
                    return sa ? 1 : 2;
                }
                return 0;
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                return 3;
            }
        }
        return 4;
    }

    public HashMap<String, Object> getCPUInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String line;
            FileReader fr = new FileReader(Strings.getString(41));
            BufferedReader br = new BufferedReader(fr);
            ArrayList processors = new ArrayList();
            map.put("processors", processors);
            HashMap<String, String> processor = null;
            while ((line = br.readLine()) != null) {
                String[] parts;
                if (TextUtils.isEmpty((CharSequence)line)) {
                    if (processor != null) {
                        processors.add(processor);
                    }
                    processor = null;
                    continue;
                }
                if ((line = line.trim()).startsWith("processor")) {
                    if (processor != null) {
                        processors.add(processor);
                    }
                    processor = new HashMap<String, String>();
                }
                if ((parts = line.split(":")) == null || parts.length <= 1) continue;
                if (processor == null) {
                    map.put(parts[0].trim(), parts[1].trim());
                    continue;
                }
                processor.put(parts[0].trim(), parts[1].trim());
            }
            br.close();
            fr.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return map;
    }

    public ArrayList<ArrayList<String>> getTTYDriversInfo() {
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        if (Build.VERSION.SDK_INT < 28) {
            try {
                String line;
                FileReader fr = new FileReader(Strings.getString(52));
                BufferedReader br = new BufferedReader(fr);
                while ((line = br.readLine()) != null) {
                    String[] parts;
                    if (TextUtils.isEmpty((CharSequence)line) || (parts = (line = line.trim()).split(" ")).length <= 1) continue;
                    ArrayList<String> temp = new ArrayList<String>();
                    for (String item : parts) {
                        if (TextUtils.isEmpty((CharSequence)item)) continue;
                        temp.add(item.trim());
                    }
                    list.add(temp);
                }
                br.close();
                fr.close();
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t.getMessage(), new Object[0]);
            }
        }
        return list;
    }

    public void getBatteryState(final ReflectHelper.ReflectRunnable<HashMap<String, Object>, Void> callback) {
        block2: {
            try {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
                this.context.registerReceiver(new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (String key : intent.getExtras().keySet()) {
                            map.put(key, intent.getExtras().get(key));
                        }
                        if (callback != null) {
                            callback.run(map);
                        }
                        try {
                            context.unregisterReceiver((BroadcastReceiver)this);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }, intentFilter);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
                if (callback == null) break block2;
                callback.run(null);
            }
        }
    }

    public int getScreenBrightness() {
        int brightness = -1;
        try {
            ContentResolver resolver = this.context.getContentResolver();
            brightness = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return brightness;
    }

    public int getScreenBrightnessMode() {
        int brightnessMode = -1;
        try {
            ContentResolver resolver = this.context.getContentResolver();
            brightnessMode = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness_mode");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return brightnessMode;
    }

    public String getQemuKernel() {
        String qemuKernel = "0";
        try {
            String clzName = ReflectHelper.importClass(Strings.getString(9));
            qemuKernel = (String)ReflectHelper.invokeStaticMethod(clzName, Strings.getString(10), Strings.getString(53), "0");
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return qemuKernel;
    }

    public HashMap<String, HashMap<String, Long>> getSizeInfo() {
        String[] names;
        HashMap<String, HashMap<String, Long>> map = new HashMap<String, HashMap<String, Long>>();
        for (String name : names = new String[]{"sdcard", "data"}) {
            HashMap<String, Long> map1 = new HashMap<String, Long>();
            map1.put("available", -1L);
            map1.put("free", -1L);
            map1.put("total", -1L);
            map.put(name, map1);
        }
        HashMap<String, StatFs> stats = new HashMap<String, StatFs>();
        try {
            String path = this.getSdcardPath();
            if (path != null) {
                stats.put("sdcard", new StatFs(path));
            }
        }
        catch (Throwable path) {
            // empty catch block
        }
        try {
            File data = Environment.getDataDirectory();
            if (data != null) {
                stats.put("data", new StatFs(data.getPath()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Map.Entry ent : stats.entrySet()) {
            long total;
            long free;
            long available;
            StatFs stat = (StatFs)ent.getValue();
            if (Build.VERSION.SDK_INT <= 18) {
                available = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
                free = (long)stat.getFreeBlocks() * (long)stat.getBlockSize();
                total = (long)stat.getBlockCount() * (long)stat.getBlockSize();
            } else {
                available = stat.getAvailableBlocksLong() * stat.getBlockSizeLong();
                free = stat.getFreeBlocksLong() * stat.getBlockSizeLong();
                total = stat.getBlockCountLong() * stat.getBlockSizeLong();
            }
            HashMap<String, Long> map1 = map.get(ent.getKey());
            map1.put("available", available);
            map1.put("free", free);
            map1.put("total", total);
        }
        return map;
    }

    public HashMap<String, Long> getMemoryInfo() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("available", -1L);
        map.put("total", -1L);
        map.put("isLow", -1L);
        map.put("threshold", -1L);
        try {
            Object am = this.getSystemServiceSafe(Strings.getString(30));
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ReflectHelper.invokeInstanceMethod(am, Strings.getString(64), memInfo);
            map.put("available", memInfo.availMem);
            map.put("total", memInfo.totalMem);
            map.put("isLow", memInfo.lowMemory ? 1L : 0L);
            map.put("threshold", memInfo.threshold);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    public Bitmap getWallPaper() {
        try {
            WallpaperManager wm = WallpaperManager.getInstance((Context)this.context);
            Drawable drw = wm.peekDrawable();
            if (drw == null && (drw = wm.getWallpaperInfo().loadThumbnail(this.context.getPackageManager())) == null) {
                return null;
            }
            if (drw instanceof BitmapDrawable) {
                return ((BitmapDrawable)drw).getBitmap();
            }
            int width = 1;
            int height = 1;
            if (drw.getIntrinsicWidth() > 0 && drw.getIntrinsicHeight() > 0) {
                width = drw.getIntrinsicWidth();
                height = drw.getIntrinsicHeight();
            }
            Bitmap bm = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas can = new Canvas(bm);
            drw.setBounds(0, 0, bm.getWidth(), bm.getHeight());
            drw.draw(can);
            return bm;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return null;
        }
    }

    public String getMIUIVersion() {
        String version = null;
        version = this.getSystemProperties(Strings.getString(65));
        if (TextUtils.isEmpty((CharSequence)version)) {
            version = this.getSystemProperties(Strings.getString(66));
        }
        if (TextUtils.isEmpty((CharSequence)version)) {
            version = this.getSystemProperties(Strings.getString(67));
        }
        if (TextUtils.isEmpty((CharSequence)version)) {
            version = this.getSystemProperties(Strings.getString(135));
        }
        if (TextUtils.isEmpty((CharSequence)version)) {
            version = this.getSystemProperties(Strings.getString(136));
        }
        if (TextUtils.isEmpty((CharSequence)version)) {
            version = this.getSystemProperties(Strings.getString(69));
        }
        return version;
    }

    public boolean isFreeMeOS() {
        try {
            String pro = this.getSystemProperties("ro.build.freeme.label");
            if (!TextUtils.isEmpty((CharSequence)pro) && pro.equalsIgnoreCase("FREEMEOS")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean isSSUIOS() {
        try {
            String pro = this.getSystemProperties("ro.ssui.product");
            if (!TextUtils.isEmpty((CharSequence)pro) && !pro.equalsIgnoreCase("unknown")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public int getAlbumCount() {
        int count = 0;
        try {
            Cursor cursor;
            if (this.checkPermission("android.permission.READ_EXTERNAL_STORAGE") && (cursor = this.context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, "bucket_display_name like ? or bucket_display_name like ? or bucket_display_name like ?", new String[]{"%Camera%", "%\u76f8\u673a%", "%DCIM%"}, "datetaken")) != null) {
                count = cursor.getCount();
                cursor.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }

    public String getWAbcd(int type) {
        block7: {
            try {
                if (!this.getSdcardState()) {
                    return null;
                }
                String sdCardPath = this.getSdcardPath();
                if (TextUtils.isEmpty((CharSequence)sdCardPath)) {
                    return null;
                }
                String[] folder = Strings.getString(75).split(",");
                if (folder == null || folder.length <= 0) break block7;
                for (String item : folder) {
                    if (item == null || TextUtils.isEmpty((CharSequence)(item = item.trim()))) continue;
                    try {
                        String value;
                        HashMap<String, Object> map;
                        File file = new File(sdCardPath + item, ".mn_" + this.getFixedString());
                        if (!file.exists() || !file.isFile() || (map = this.getMapFromOtherPlace(file.getPath())) == null || TextUtils.isEmpty((CharSequence)(value = (String)map.get(String.valueOf(type))))) continue;
                        return value.trim();
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return null;
    }

    public void saveWabcd(String data, int type) {
        try {
            if (!this.getSdcardState()) {
                return;
            }
            String sdCardPath = this.getSdcardPath();
            if (TextUtils.isEmpty((CharSequence)sdCardPath)) {
                return;
            }
            String[] folder = Strings.getString(75).split(",");
            if (folder != null && folder.length > 0) {
                for (String item : folder) {
                    if (item == null || TextUtils.isEmpty((CharSequence)(item = item.trim()))) continue;
                    try {
                        File file = new File(sdCardPath + item, ".mn_" + this.getFixedString());
                        HashMap<String, Object> map = null;
                        if (file.exists() && file.isFile()) {
                            map = this.getMapFromOtherPlace(file.getPath());
                        }
                        if (map == null) {
                            map = new HashMap<String, String>();
                        }
                        map.put(String.valueOf(type), data);
                        String json = this.getSortWabcd(map);
                        String sign = Data.MD5(json + Strings.getString(77));
                        map.put(Strings.getString(78), sign);
                        byte[] aes = Data.AES128Encode(Strings.getString(76), new Hashon().fromHashMap(map));
                        ResHelper.saveObjectToFile(file.getPath(), aes);
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public void removeWABCD() {
        try {
            if (!this.getSdcardState()) {
                return;
            }
            String sdCardPath = this.getSdcardPath();
            if (TextUtils.isEmpty((CharSequence)sdCardPath)) {
                return;
            }
            String[] folder = Strings.getString(75).split(",");
            if (folder != null && folder.length > 0) {
                for (String item : folder) {
                    if (item == null || TextUtils.isEmpty((CharSequence)(item = item.trim()))) continue;
                    try {
                        File file = new File(sdCardPath + item, ".mn_" + this.getFixedString());
                        file.delete();
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    private HashMap<String, Object> getMapFromOtherPlace(String filePath) {
        try {
            String tmp = Data.AES128Decode(Strings.getString(76), (byte[])ResHelper.readObjectFromFile(filePath));
            if (!TextUtils.isEmpty((CharSequence)tmp)) {
                HashMap<String, Object> map = new Hashon().fromJson(tmp);
                String sign = (String)map.remove(Strings.getString(78));
                String json = this.getSortWabcd(map);
                String md5 = Data.MD5(json + Strings.getString(77));
                if (sign == null || sign.equals(md5)) {
                    return map;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private String getSortWabcd(HashMap<String, Object> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String item = (String)map.get("0");
        if (item != null) {
            sb.append(item);
        }
        if ((item = (String)map.get("1")) != null) {
            sb.append(item);
        }
        if ((item = (String)map.get("2")) != null) {
            sb.append(item);
        }
        if ((item = (String)map.get("3")) != null) {
            sb.append(item);
        }
        return sb.toString();
    }

    public String getFixedString() {
        if (this.fixedString == null) {
            try {
                SensorManager sm = (SensorManager)this.getSystemServiceSafe("sensor");
                List sensorList = sm.getSensorList(-1);
                StringBuilder sb = new StringBuilder();
                for (Sensor item : sensorList) {
                    if (item.getType() < 0) continue;
                    sb.append(item.getType()).append('.').append(item.getName()).append('-').append(item.getVersion()).append("-").append(item.getVendor()).append('\n');
                }
                this.fixedString = String.valueOf(sb.toString().hashCode());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.fixedString;
    }

    public ArrayList<HashMap<String, Object>> getArpList() {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/proc/net/arp"));
            while ((line = br.readLine()) != null) {
                try {
                    String mac;
                    if ((line = line.trim()).toUpperCase(Locale.US).contains("IP") || line.length() < 63 || (mac = line.substring(41, 63).trim()).startsWith("00:00:00:00:00:00")) continue;
                    String ip = line.substring(0, 17).trim();
                    String flag = line.substring(29, 32).trim();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("ip", ip);
                    map.put("flag", flag);
                    map.put("mac", mac);
                    list.add(map);
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
            }
            br.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cx() {
        try {
            if (this.context.getPackageManager().getPackageInfo("de.robv.android.xposed.installer", 0) != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            throw new Exception("test");
        }
        catch (Throwable t) {
            for (StackTraceElement className : t.getStackTrace()) {
                if (!className.getClassName().contains("de.robv.android.xposed.XposedBridge")) continue;
                return true;
            }
            try {
                ClassLoader.getSystemClassLoader().loadClass("de.robv.android.xposed.XposedHelpers").newInstance();
                try {
                    ClassLoader.getSystemClassLoader().loadClass("de.robv.android.xposed.XposedBridge").newInstance();
                    return true;
                }
                catch (InstantiationException e1) {
                    return true;
                }
                catch (IllegalAccessException e2) {
                    return true;
                }
            }
            catch (InstantiationException e4) {
                return true;
            }
            catch (IllegalAccessException e5) {
                return true;
            }
            catch (Throwable t2) {
                MobLog.getInstance().d(t2);
                BufferedReader br = null;
                try {
                    String tmp;
                    br = new BufferedReader(new FileReader("/proc/" + Process.myPid() + "/maps"));
                    int isXposed = 0;
                    while ((tmp = br.readLine()) != null && !isXposed) {
                        isXposed = tmp.toLowerCase().contains("xposed");
                    }
                    int n = isXposed;
                    return n != 0;
                }
                catch (Throwable t3) {
                    MobLog.getInstance().d(t3);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            MobLog.getInstance().d(e);
                        }
                    }
                }
                return false;
            }
        }
    }

    public HashMap<String, Object> getIInfo() {
        return this.getIInfo(false);
    }

    public HashMap<String, Object> getIInfo(boolean ln) {
        try {
            Object phone = this.getSystemServiceSafe("phone");
            if (phone == null) {
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(Strings.getString(83), this.invokeInstanceMethod(phone, Strings.getString(84), new Object[0]));
            map.put(Strings.getString(85), this.invokeInstanceMethod(phone, Strings.getString(86), new Object[0]));
            map.put(Strings.getString(87), this.invokeInstanceMethod(phone, Strings.getString(88), new Object[0]));
            if (Build.VERSION.SDK_INT >= 23) {
                map.put(Strings.getString(89), this.invokeInstanceMethod(phone, Strings.getString(90), new Object[0]));
            }
            if (!this.checkPermission("android.permission.READ_PHONE_STATE")) {
                return map;
            }
            if (Build.VERSION.SDK_INT < 29) {
                if (Build.VERSION.SDK_INT >= 26) {
                    map.put(Strings.getString(91), this.invokeInstanceMethod(phone, Strings.getString(92), new Object[0]));
                    map.put(Strings.getString(93), this.invokeInstanceMethod(phone, Strings.getString(94), new Object[0]));
                } else {
                    map.put(Strings.getString(91), this.invokeInstanceMethod(phone, Strings.getString(95), new Object[0]));
                }
                map.put(Strings.getString(96), this.invokeInstanceMethod(phone, Strings.getString(25), new Object[0]));
                map.put(Strings.getString(99), this.invokeInstanceMethod(phone, Strings.getString(14), new Object[0]));
            }
            if (Build.VERSION.SDK_INT >= 24) {
                map.put(Strings.getString(100), DeviceHelper.getInstance(this.context).getDataNtType());
            }
            if ("-1".equals(this.swVer) || !this.isSensitiveDevice()) {
                this.swVer = (String)this.invokeInstanceMethod(phone, Strings.getString(98), new Object[0]);
            }
            if (!"-1".equals(this.swVer) && !TextUtils.isEmpty((CharSequence)this.swVer)) {
                map.put(Strings.getString(97), this.swVer);
            }
            if (Build.VERSION.SDK_INT >= 22) {
                Object sm = this.getSystemServiceSafe(Strings.getString(114));
                if (this.sActCnt == -1 || !this.isSensitiveDevice()) {
                    this.sActCnt = (Integer)this.invokeInstanceMethod(sm, Strings.getString(103), new Object[0]);
                }
                if (this.sActCnt != -1) {
                    map.put(Strings.getString(102), this.sActCnt);
                }
                if (this.sActList == null || !this.isSensitiveDevice()) {
                    this.sActList = (List)this.invokeInstanceMethod(sm, Strings.getString(104), new Object[0]);
                }
                if (this.sActList != null) {
                    int size = this.sActList.size();
                    ArrayList tmpMap = new ArrayList();
                    for (int i = 0; i < size; ++i) {
                        Object item = this.sActList.get(i);
                        HashMap itemMap = new HashMap();
                        int subscriptionId = (Integer)this.invokeInstanceMethod(item, Strings.getString(105), new Object[0]);
                        itemMap.put(Strings.getString(106), this.invokeInstanceMethod(item, Strings.getString(107), new Object[0]));
                        if (ln) {
                            itemMap.put(Strings.getString(108), this.invokeInstanceMethod(item, Strings.getString(109), new Object[0]));
                        }
                        itemMap.put(Strings.getString(110), this.invokeInstanceMethod(item, Strings.getString(111), new Object[0]));
                        int simSlotIndex = (Integer)this.invokeInstanceMethod(item, Strings.getString(112), new Object[0]);
                        itemMap.put(Strings.getString(83), this.invokeInstanceMethod(phone, Strings.getString(84), new Object[]{simSlotIndex}, new Class[]{Integer.TYPE}));
                        if (Build.VERSION.SDK_INT < 29) {
                            if (Build.VERSION.SDK_INT >= 26) {
                                itemMap.put(Strings.getString(91), this.invokeInstanceMethod(phone, Strings.getString(92), new Object[]{simSlotIndex}, new Class[]{Integer.TYPE}));
                                itemMap.put(Strings.getString(93), this.invokeInstanceMethod(phone, Strings.getString(94), new Object[]{simSlotIndex}, new Class[]{Integer.TYPE}));
                            } else if (Build.VERSION.SDK_INT >= 23) {
                                itemMap.put(Strings.getString(91), this.invokeInstanceMethod(phone, Strings.getString(95), new Object[]{simSlotIndex}, new Class[]{Integer.TYPE}));
                            } else {
                                itemMap.put(Strings.getString(91), this.invokeInstanceMethod(phone, Strings.getString(95), new Object[0]));
                            }
                            itemMap.put(Strings.getString(96), this.invokeInstanceMethod(phone, Strings.getString(25), new Object[]{subscriptionId}, new Class[]{Integer.TYPE}));
                            itemMap.put(Strings.getString(99), this.invokeInstanceMethod(phone, Strings.getString(14), new Object[]{subscriptionId}, new Class[]{Integer.TYPE}));
                        }
                        tmpMap.add(itemMap);
                    }
                    map.put(Strings.getString(113), tmpMap);
                }
            }
            return map;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return null;
        }
    }

    public <T> T invokeInstanceMethod(Object receiver, String methodName, Object ... args) {
        try {
            return ReflectHelper.invokeInstanceMethod(receiver, methodName, args);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return null;
        }
    }

    public <T> T invokeInstanceMethod(Object receiver, String methodName, Object[] args, Class<?>[] paramTypes) {
        try {
            return ReflectHelper.invokeInstanceMethod(receiver, methodName, args, paramTypes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return null;
        }
    }

    public boolean checkPad() {
        return (this.context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public boolean checkADBModel(int nm) {
        switch (nm) {
            case 273: {
                return this.usbEnable() && this.devEnable();
            }
            case 17: {
                return this.usbEnable() || this.devEnable();
            }
            case 16: {
                return this.devEnable();
            }
            case 1: {
                return this.usbEnable();
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public boolean usbEnable() {
        try {
            boolean enableAdb = Build.VERSION.SDK_INT >= 17 ? Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"adb_enabled", (int)0) > 0 : Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"adb_enabled", (int)0) > 0;
            return enableAdb;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean devEnable() {
        try {
            boolean enableDevelopment = Build.VERSION.SDK_INT >= 17 ? Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"development_settings_enabled", (int)0) > 0 : Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"development_settings_enabled", (int)0) > 0;
            return enableDevelopment;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean checkUA() {
        try {
            Intent batteryBroadcast = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            int chargeStyle = batteryBroadcast.getIntExtra("plugged", -1);
            return chargeStyle == 2;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return false;
        }
    }

    public boolean vpn() {
        try {
            Enumeration<NetworkInterface> niList = NetworkInterface.getNetworkInterfaces();
            if (niList != null) {
                for (NetworkInterface intf : Collections.list(niList)) {
                    if (!intf.isUp() || intf.getInterfaceAddresses().size() == 0 || !"tun0".equals(intf.getName()) && !"ppp0".equals(intf.getName())) continue;
                    return true;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return false;
    }

    public boolean debugable() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 1);
            return (pi.applicationInfo.flags & 2) != 0;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return false;
        }
    }

    public boolean isWifiProxy() {
        try {
            int proxyPort;
            String proxyAddress;
            if (Build.VERSION.SDK_INT >= 14) {
                proxyAddress = System.getProperty("http.proxyHost");
                String portstr = System.getProperty("http.proxyPort");
                proxyPort = -1;
                try {
                    proxyPort = Integer.parseInt(portstr != null ? portstr : "-1");
                }
                catch (Throwable throwable) {}
            } else {
                proxyAddress = Proxy.getHost((Context)this.context);
                proxyPort = Proxy.getPort((Context)this.context);
            }
            return !TextUtils.isEmpty((CharSequence)proxyAddress) && proxyPort != -1;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isScopedStorage() {
        boolean deviceQ = Build.VERSION.SDK_INT >= 29;
        boolean targetQ = this.context.getApplicationInfo().targetSdkVersion >= 29;
        return deviceQ && targetQ;
    }

    public ArrayList<HashMap<String, Object>> getBondedBluetooth() {
        try {
            return BHelper.getInstance(this.context).getBondedDevice();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return new ArrayList<HashMap<String, Object>>();
        }
    }

    public void scanBtList(int scanInterval, final BtScanCallback bScanCallback) {
        try {
            BHelper.getInstance(this.context).findLEAndClassic(scanInterval, new BHelper.BScanCallback(){

                @Override
                public void onScan(ArrayList<HashMap<String, Object>> result) {
                    if (bScanCallback != null) {
                        bScanCallback.onScan(result);
                    }
                }
            });
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public void unRegisterBtScanReceiver() {
        try {
            BHelper.getInstance(this.context).unRegisterBScanReceiver();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public void registerBtWatcher(String id, final BtWatcher btWatcher) {
        if (btWatcher != null) {
            try {
                BHelper.getInstance(this.context).registerBOperationReceiver(id, new BHelper.BOperationCallback(){

                    @Override
                    protected void onEnabled() {
                        btWatcher.onBtEnabled();
                    }

                    @Override
                    protected void onDisabled() {
                        btWatcher.onBtDisabled();
                    }

                    @Override
                    protected void onConnectionChanged(boolean connect, HashMap<String, Object> btDevice) {
                        btWatcher.onBtConnectionChanged(connect, btDevice);
                    }

                    @Override
                    protected void onDeviceConnected(HashMap<String, Object> btDevice) {
                        btWatcher.onDeviceConnected(btDevice);
                    }

                    @Override
                    protected void onDeviceDisconnected(HashMap<String, Object> btDevice) {
                        btWatcher.onDeviceDisconnected(btDevice);
                    }
                });
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
    }

    public void unRegisterBtWatcher(String id) {
        try {
            BHelper.getInstance(this.context).unRegisterBOperationReceiver(id);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public ArrayList<HashMap<String, String>> getCamResolution() {
        try {
            String[] cameraIdList;
            CameraManager cameraManager;
            if (this.checkPermission("android.permission.CAMERA") && Build.VERSION.SDK_INT >= 21 && (cameraManager = (CameraManager)this.context.getSystemService("camera")) != null && (cameraIdList = (String[])ReflectHelper.invokeInstanceMethod((Object)cameraManager, Strings.getString(126), new Object[0])) != null && cameraIdList.length > 0) {
                ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>(cameraIdList.length);
                for (String cameraId : cameraIdList) {
                    Size size;
                    CameraCharacteristics characteristics;
                    if (cameraId == null || (characteristics = (CameraCharacteristics)ReflectHelper.invokeInstanceMethod((Object)cameraManager, Strings.getString(127), cameraId)) == null || (size = (Size)characteristics.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE)) == null) continue;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("width", String.valueOf(size.getWidth()));
                    hashMap.put("height", String.valueOf(size.getHeight()));
                    result.add(hashMap);
                }
                return result;
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().d(e);
        }
        return null;
    }

    public String getTimezone() {
        String timezone = null;
        try {
            Calendar instance;
            Configuration configuration = new Configuration();
            configuration.setToDefaults();
            Settings.System.getConfiguration((ContentResolver)this.context.getContentResolver(), (Configuration)configuration);
            Locale locale = configuration.locale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((instance = Calendar.getInstance(locale)) != null) {
                timezone = instance.getTimeZone().getID();
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().d(e);
        }
        return timezone;
    }

    public HashMap<String, Object> getSupport() {
        HashMap<String, Object> hashMap;
        block14: {
            hashMap = new HashMap<String, Object>();
            try {
                PackageManager packageManager = this.context.getPackageManager();
                if (packageManager == null) break block14;
                try {
                    hashMap.put("mobile", packageManager.hasSystemFeature("android.hardware.telephony"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    hashMap.put("wifi", packageManager.hasSystemFeature("android.hardware.wifi"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    hashMap.put("gps", packageManager.hasSystemFeature("android.hardware.location.gps"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
                hashMap.put("telephone", telephonyManager != null && telephonyManager.getPhoneType() != 0);
                try {
                    hashMap.put("nfc", packageManager.hasSystemFeature("android.hardware.nfc"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    hashMap.put("bluetooth", packageManager.hasSystemFeature("android.hardware.bluetooth"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    hashMap.put("otg", packageManager.hasSystemFeature("android.hardware.usb.host"));
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public HashMap<String, String> getCPUFreq() {
        String maxFreq;
        String minFreq;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String currentFreq = this.readFile("/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq");
        if (!TextUtils.isEmpty((CharSequence)currentFreq)) {
            hashMap.put("currentCpuHz", currentFreq);
        }
        if (!TextUtils.isEmpty((CharSequence)(minFreq = this.readFile("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq")))) {
            hashMap.put("minCpuHz", minFreq);
        }
        if (!TextUtils.isEmpty((CharSequence)(maxFreq = this.readFile("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq")))) {
            hashMap.put("maxCpuHz", maxFreq);
        }
        return hashMap;
    }

    public String readFile(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(line);
            }
            br.close();
            fr.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return stringBuilder.toString();
    }

    public String getCPUType() {
        try {
            return Build.VERSION.SDK_INT < 21 ? Build.CPU_ABI : Build.SUPPORTED_ABIS[0];
        }
        catch (Throwable e) {
            MobLog.getInstance().d(e);
            return null;
        }
    }

    public String getFlavor() {
        String data = null;
        try {
            data = this.getSystemProperties(Strings.getString(119));
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getTraffic() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Build.VERSION.SDK_INT < 29) {
            BufferedReader bufferedReader = null;
            try {
                String readLine;
                bufferedReader = new BufferedReader(new FileReader(Strings.getString(120)));
                StringBuilder stringBuilder = new StringBuilder();
                while ((readLine = bufferedReader.readLine()) != null) {
                    stringBuilder.append(readLine).append("\n");
                }
                String totalNet = stringBuilder.toString();
                if (totalNet != null) {
                    long[] wlan = new long[2];
                    this.getTrafficBytes(totalNet, "wlan0:", wlan);
                    result.put("downFlowWifi", wlan[0]);
                    result.put("upwardFlowWifi", wlan[1]);
                    long[] rmnet = new long[2];
                    this.getTrafficBytes(totalNet, "rmnet0:", rmnet);
                    result.put("downFlowCellular", rmnet[0]);
                    result.put("upwardFlowCellular", rmnet[1]);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().d(t);
                    }
                }
            }
        }
        try {
            PackageManager packageManager = this.context.getPackageManager();
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    String pkg = this.context.getPackageName();
                    ApplicationInfo applicationInfo = packageManager.getApplicationInfo(pkg, 1);
                    int uid = applicationInfo.uid;
                    result.put("upwardFlowApp", TrafficStats.getUidTxBytes((int)uid));
                    result.put("downFlowApp", TrafficStats.getUidRxBytes((int)uid));
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return result;
    }

    public String getBaseband() {
        String data = null;
        try {
            data = this.getSystemProperties(Strings.getString(116));
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return data;
    }

    public String getBoardFromSysProperty() {
        String data = null;
        try {
            data = this.getSystemProperties(Strings.getString(117));
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return data;
    }

    public String getBoardPlatform() {
        String data = null;
        try {
            data = this.getSystemProperties(Strings.getString(118));
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return data;
    }

    private void getTrafficBytes(String content, String type, long[] result) {
        block6: {
            try {
                int index = content.indexOf(type);
                if (index == -1) break block6;
                Matcher matcher = Pattern.compile(" \\d+ ").matcher(content.substring(index));
                int i = 0;
                while (matcher.find()) {
                    if (i == 0) {
                        result[0] = Long.parseLong(matcher.group().trim());
                    } else if (i == 8) {
                        result[1] = Long.parseLong(matcher.group().trim());
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
    }

    public long getElapsedTime() {
        long result = 0L;
        try {
            result = SystemClock.elapsedRealtime();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return result;
    }

    public int getDataNtType() {
        return NtFetcher.getInstance(this.context).getDtNtType();
    }

    public String getDefaultIMPkg() {
        String mDefaultInputMethodPkg = null;
        try {
            String mDefaultInputMethodCls = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"default_input_method");
            if (!TextUtils.isEmpty((CharSequence)mDefaultInputMethodCls)) {
                mDefaultInputMethodPkg = mDefaultInputMethodCls.split("/")[0];
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return mDefaultInputMethodPkg;
    }

    public HashMap<String, Object> getDefaultIM() {
        HashMap<String, String> map = null;
        try {
            String pkg = this.getDefaultIMPkg();
            String name = this.getAppName(pkg);
            map = new HashMap<String, String>();
            map.put("name", name);
            map.put("pkg", pkg);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return map;
    }

    public ArrayList<HashMap<String, Object>> getIMList() {
        ArrayList ims = null;
        try {
            InputMethodManager imm = (InputMethodManager)this.getSystemServiceSafe("input_method");
            List methodList = imm.getInputMethodList();
            ims = new ArrayList();
            for (InputMethodInfo mi : methodList) {
                if (mi == null) continue;
                HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
                CharSequence name = mi.loadLabel(this.context.getPackageManager());
                map.put("name", name);
                map.put("pkg", mi.getPackageName());
                ims.add(map);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return ims;
    }

    public String getBrand() {
        return Build.BRAND;
    }

    public boolean isSmlt() {
        try {
            int board;
            if (this.isSmlt != null) {
                return this.isSmlt;
            }
            int THRESHOLD = 2;
            int curr = 0;
            SmltHelper helper = new SmltHelper();
            int baseband = helper.checkBaseband(this.context);
            if (baseband == 1) {
                ++curr;
            }
            if ((board = helper.checkBoard(this.context)) == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int platform = helper.checkPlatform(this.context);
            if (platform == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int flavor = helper.checkFlavor(this.context);
            if (flavor == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int cgroup = helper.checkCgroup();
            if (cgroup == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int bluetooth = helper.checkBluetooth(this.context);
            if (bluetooth == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int imei = helper.checkImei(this.context);
            if (imei == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int commonapp = helper.checkCommonApp(this.context);
            if (commonapp == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int cpuinfo = helper.checkCpuInfo();
            if (cpuinfo == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
            int sensor = helper.checkSensor(this.context);
            if (sensor == 1) {
                ++curr;
            }
            if (curr >= THRESHOLD) {
                this.isSmlt = true;
                return this.isSmlt;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        this.isSmlt = false;
        return this.isSmlt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcessor() {
        String processor = null;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(Strings.getString(41)));
            Pattern p = Pattern.compile("Processor\\s*:\\s*(.*)");
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                processor = m.group(1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    MobLog.getInstance().d(e);
                }
            }
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getDeviceMemUsage() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BufferedReader bfr = null;
        try {
            String line;
            String file = Strings.getString(125);
            bfr = new BufferedReader(new FileReader(file));
            while ((line = bfr.readLine()) != null) {
                String[] strArr = line.split("\\s+");
                if (strArr == null || strArr.length <= 1) continue;
                String name = strArr[0];
                long size = Long.parseLong(strArr[1]) * 1024L;
                if ("MemTotal:".equals(name)) {
                    map.put("totalMemorySize", size);
                    continue;
                }
                if ("MemFree:".equals(name)) {
                    map.put("freeMemorySize", size);
                    continue;
                }
                if ("MemAvailable:".equals(name)) {
                    map.put("availableMemorySize", size);
                    continue;
                }
                if ("Active:".equals(name)) {
                    map.put("activeMemorySize", size);
                    continue;
                }
                if (!"Inactive:".equals(name)) continue;
                map.put("inactiveMemorySize", size);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        finally {
            if (bfr != null) {
                try {
                    bfr.close();
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
            }
        }
        return map;
    }

    private String byteToHex(byte[] mac) {
        if (mac == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte aMac : mac) {
            buf.append(String.format("%02x:", aMac));
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public ArrayList<HashMap<String, Object>> getLocalIpInfo() {
        try {
            if (this.checkPermission("android.permission.INTERNET")) {
                ArrayList<HashMap<String, Object>> resList = new ArrayList<HashMap<String, Object>>();
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                ArrayList<NetworkInterface> interfaces = Collections.list(nis);
                for (NetworkInterface intf : interfaces) {
                    HashMap<String, Object> tmpRes = new HashMap<String, Object>();
                    tmpRes.put("name", intf.getName());
                    tmpRes.put("mac", this.byteToHex(intf.getHardwareAddress()));
                    List<InterfaceAddress> list = intf.getInterfaceAddresses();
                    if (list == null || list.size() <= 0) continue;
                    ArrayList tmpList = new ArrayList();
                    for (InterfaceAddress ia : list) {
                        HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                        InetAddress inetAddress = ia.getAddress();
                        tmpMap.put("haddr", inetAddress.getHostAddress());
                        tmpMap.put("hname", inetAddress.getHostName());
                        tmpMap.put("lp", inetAddress.isLoopbackAddress());
                        tmpMap.put("addr", this.byteToHex(inetAddress.getAddress()));
                        tmpMap.put("len", inetAddress.getAddress().length);
                        inetAddress = ia.getBroadcast();
                        if (inetAddress != null) {
                            HashMap<String, Object> broadcast = new HashMap<String, Object>();
                            broadcast.put("haddrB", inetAddress.getHostAddress());
                            broadcast.put("hnameB", inetAddress.getHostName());
                            broadcast.put("lpB", inetAddress.isLoopbackAddress());
                            broadcast.put("addrB", this.byteToHex(inetAddress.getAddress()));
                            broadcast.put("lenB", inetAddress.getAddress().length);
                            tmpMap.put("broadcast", broadcast);
                        }
                        tmpList.add(tmpMap);
                    }
                    tmpRes.put("inets", tmpList);
                    resList.add(tmpRes);
                }
                return resList;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFakePass(String permission2) {
        boolean fake = false;
        try {
            String clzName = ReflectHelper.importClass(Strings.getString(132));
            String op = (String)ReflectHelper.invokeStaticMethod(clzName, Strings.getString(133), permission2);
            int ra = (Integer)ReflectHelper.invokeStaticMethod(clzName, Strings.getString(134), this.context, op, this.getPackageName());
            if (ra == 1) {
                return true;
            }
            if (ra != 0) return fake;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return fake;
    }

    public boolean isSensitiveDevice() {
        boolean isSensitiveDevice = false;
        try {
            String manufacturer = this.getManufacturer();
            String uiVersion = this.getMIUIVersion();
            boolean isUpperMIUI12 = false;
            if (!TextUtils.isEmpty((CharSequence)uiVersion) && uiVersion.length() >= 3) {
                String subUiVersion = uiVersion.substring(1);
                try {
                    int uiVersionInt = Integer.parseInt(subUiVersion);
                    if (uiVersionInt >= 12) {
                        isUpperMIUI12 = true;
                    }
                }
                catch (Throwable t) {
                    String msg;
                    String string = msg = t == null ? "" : t.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                    MobLog.getInstance().d(msg, new Object[0]);
                }
            }
            if ("xiaomi".equalsIgnoreCase(manufacturer) && isUpperMIUI12) {
                isSensitiveDevice = true;
            }
        }
        catch (Throwable t) {
            String msg;
            String string = msg = t == null ? "" : t.getMessage();
            if (msg == null) {
                msg = "";
            }
            MobLog.getInstance().d(msg, new Object[0]);
        }
        return isSensitiveDevice;
    }

    public static interface BtScanCallback {
        public void onScan(ArrayList<HashMap<String, Object>> var1);
    }

    public static class BtWatcher {
        protected void onBtEnabled() {
        }

        protected void onBtDisabled() {
        }

        protected void onBtConnectionChanged(boolean connect, HashMap<String, Object> btDevice) {
        }

        protected void onDeviceConnected(HashMap<String, Object> btDevice) {
        }

        protected void onDeviceDisconnected(HashMap<String, Object> btDevice) {
        }
    }

    private class GSConnection
    implements ServiceConnection {
        boolean got = false;
        private final BlockingQueue<IBinder> iBinders = new LinkedBlockingQueue<IBinder>();

        private GSConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.iBinders.put(service);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder takeBinder() throws InterruptedException {
            if (this.got) {
                throw new IllegalStateException();
            }
            this.got = true;
            return this.iBinders.poll(1500L, TimeUnit.MILLISECONDS);
        }
    }
}

