/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.log;

import android.content.Context;
import android.os.Process;
import com.mob.tools.log.LogCollector;
import com.mob.tools.log.MobUncaughtExceptionHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.HashMap;

public abstract class NLog {
    private static boolean disable;
    private static HashMap<String, NLog> loggers;
    private static LogCollector defaultCollector;
    private LogCollector collector;

    public static void disable() {
        disable = true;
    }

    public static void setContext(Context context) {
    }

    public static void setCollector(String sdkTag, LogCollector collector) {
        NLog nlog = NLog.getInstance(sdkTag);
        nlog.setCollector(collector);
    }

    protected static NLog getInstanceForSDK(String sdkTag, boolean createNew) {
        return NLog.getInstance(sdkTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NLog getInstance(final String sdkTag) {
        NLog logger;
        HashMap<String, NLog> hashMap = loggers;
        synchronized (hashMap) {
            logger = loggers.get(sdkTag);
            if (logger == null) {
                logger = new NLog(){

                    @Override
                    protected String getSDKTag() {
                        return sdkTag;
                    }
                };
                loggers.put(sdkTag, logger);
            }
        }
        return logger;
    }

    public static <Collector extends LogCollector> Collector setDefaultCollector(Collector collector) {
        defaultCollector = collector;
        return collector;
    }

    public NLog setCollector(LogCollector collector) {
        this.collector = collector;
        return this;
    }

    protected abstract String getSDKTag();

    public final int v(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(2, 0, this.getStackTraceString(t));
    }

    public final int v(Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return this.println(2, 0, message);
    }

    public final int v(Throwable throwable, Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return this.println(2, 0, message);
    }

    public final int d(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(3, 0, this.getStackTraceString(t));
    }

    public final int d(Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return this.println(3, 0, message);
    }

    public final int d(Throwable throwable, Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return this.println(3, 0, message);
    }

    public final int i(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(4, 0, this.getStackTraceString(t));
    }

    public final int i(Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return this.println(4, 0, message);
    }

    public final int i(Throwable throwable, Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return this.println(4, 0, message);
    }

    public final int w(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(5, 0, this.getStackTraceString(t));
    }

    public final int w(Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return this.println(5, 0, message);
    }

    public final int w(Throwable throwable, Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return this.println(5, 0, message);
    }

    public final int w(String m) {
        if (disable) {
            return 0;
        }
        return this.println(5, 0, m);
    }

    public final int e(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(6, 0, this.getStackTraceString(t));
    }

    public final int e(Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return this.println(6, 0, message);
    }

    public final int e(Throwable throwable, Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return this.println(6, 0, message);
    }

    public int wtf(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(6, 0, this.getStackTraceString(t));
    }

    public final int crash(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(6, 1, this.getStackTraceString(t));
    }

    public final int sdkErr(Throwable t) {
        if (disable) {
            return 0;
        }
        return this.println(6, 3, this.getStackTraceString(t));
    }

    public final int sdkErr(Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = args.length > 0 ? String.format(s, args) : s;
        return this.println(6, 3, message);
    }

    public final int sdkErr(Throwable throwable, Object format, Object ... args) {
        if (disable) {
            return 0;
        }
        String s = format.toString();
        String message = (args.length > 0 ? String.format(s, args) : s) + '\n' + this.getStackTraceString(throwable);
        return this.println(6, 3, message);
    }

    private String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        try {
            for (Throwable t = tr; t != null; t = t.getCause()) {
                if (!(t instanceof UnknownHostException)) continue;
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            tr.printStackTrace(pw);
            pw.flush();
            String res = sw.toString();
            sw.close();
            return res;
        }
        catch (Throwable t1) {
            if (t1 instanceof OutOfMemoryError) {
                return "getStackTraceString oom";
            }
            if (t1 != null) {
                return t1.getMessage();
            }
            return "";
        }
    }

    private int println(int priority, int level, String msg) {
        LogCollector c;
        String message = msg;
        try {
            message = Process.myPid() + "-" + Process.myTid() + "(" + Thread.currentThread().getName() + ") " + msg;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String sdkTag = this.getSDKTag();
        LogCollector logCollector = c = this.collector == null ? defaultCollector : this.collector;
        if (c != null) {
            c.log(sdkTag, priority, level, null, message);
        }
        return 0;
    }

    static {
        loggers = new HashMap();
        MobUncaughtExceptionHandler.register();
    }
}

