/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.mob.tools.FakeActivity;
import com.mob.tools.MobLog;
import com.mob.tools.network.KVPair;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class MobUIShell
extends Activity {
    private static HashMap<String, FakeActivity> executors = new HashMap();
    private FakeActivity executor;

    public static Uri toMobUIShellUri(String fakeActivity, HashMap<String, Object> params) {
        ArrayList<KVPair<String>> kvs = new ArrayList<KVPair<String>>();
        for (String key : params.keySet()) {
            kvs.add(new KVPair<String>(key, String.valueOf(params.get(key))));
        }
        String strUri = "mobui://" + fakeActivity + "?" + ResHelper.encodeUrl(kvs);
        return Uri.parse((String)strUri);
    }

    protected static String registerExecutor(Object executor) {
        String launchTime = String.valueOf(System.currentTimeMillis());
        return MobUIShell.registerExecutor(launchTime, executor);
    }

    protected static String registerExecutor(String scheme, Object executor) {
        executors.put(scheme, (FakeActivity)executor);
        return scheme;
    }

    public final void setTheme(int resid) {
        if (this.initExecutor()) {
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stacks.length; ++i) {
                if (!stacks[i].toString().startsWith("java.lang.Thread.getStackTrace") || (i += 2) >= stacks.length) continue;
                boolean l = stacks[i].toString().startsWith("android.app.ActivityThread.performLaunchActivity");
                if ((resid = this.executor.onSetTheme(resid, l)) > 0) {
                    super.setTheme(resid);
                }
                return;
            }
        }
        super.setTheme(resid);
    }

    private boolean initExecutor() {
        if (this.executor == null) {
            Intent intent = this.getIntent();
            Uri uri = intent.getData();
            if (uri != null && "mobui".equals(uri.getScheme())) {
                this.executor = this.activityForName(uri.getHost());
                if (this.executor != null) {
                    MobLog.getInstance().i("MobUIShell found executor: " + this.executor.getClass(), new Object[0]);
                    this.executor.setActivity(this);
                    return true;
                }
            }
            String launchTime = "";
            String executorName = "";
            try {
                launchTime = intent.getStringExtra("launch_time");
                executorName = intent.getStringExtra("executor_name");
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
                return false;
            }
            this.executor = executors.remove(launchTime);
            if (this.executor == null) {
                String uriScheme = intent.getScheme();
                this.executor = executors.remove(uriScheme);
                if (this.executor == null) {
                    this.executor = this.getDefault();
                    if (this.executor == null) {
                        MobLog.getInstance().w(new RuntimeException("Executor lost! launchTime = " + launchTime + ", executorName: " + executorName));
                        return false;
                    }
                }
            }
            MobLog.getInstance().i("MobUIShell found executor: " + this.executor.getClass(), new Object[0]);
            this.executor.setActivity(this);
        }
        return true;
    }

    private FakeActivity activityForName(String className) {
        try {
            if (!TextUtils.isEmpty((CharSequence)className)) {
                Object fa;
                String name;
                if (className.startsWith(".")) {
                    className = this.getPackageName() + className;
                }
                if (!TextUtils.isEmpty((CharSequence)(name = ReflectHelper.importClass(className))) && (fa = ReflectHelper.newInstance(name, new Object[0])) != null && fa instanceof FakeActivity) {
                    return (FakeActivity)fa;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.initExecutor()) {
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onCreate", new Object[0]);
            if (Build.VERSION.SDK_INT == 26 && this.isTranslucentOrFloating()) {
                boolean bl = this.fixOrientation();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.executor.activity.getWindow().addFlags(Integer.MIN_VALUE);
                this.executor.activity.getWindow().setStatusBarColor(0);
            }
            super.onCreate(savedInstanceState);
            this.executor.onCreate();
        } else {
            super.onCreate(savedInstanceState);
            this.finish();
        }
    }

    public FakeActivity getDefault() {
        String defaultActivity;
        try {
            ActivityInfo ai = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
            defaultActivity = ai.metaData.getString("defaultActivity");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            defaultActivity = null;
        }
        return this.activityForName(defaultActivity);
    }

    public void setContentView(int layoutResID) {
        View contentView = LayoutInflater.from((Context)this).inflate(layoutResID, null);
        this.setContentView(contentView);
    }

    public void setContentView(View view) {
        if (view == null) {
            return;
        }
        super.setContentView(view);
        if (this.executor != null) {
            this.executor.setContentView(view);
        }
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (view == null) {
            return;
        }
        if (params == null) {
            super.setContentView(view);
        } else {
            super.setContentView(view, params);
        }
        if (this.executor != null) {
            this.executor.setContentView(view);
        }
    }

    protected void onNewIntent(Intent intent) {
        if (this.executor == null) {
            super.onNewIntent(intent);
        } else {
            this.executor.onNewIntent(intent);
        }
    }

    protected void onStart() {
        if (this.executor != null) {
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onStart", new Object[0]);
            this.executor.onStart();
        }
        super.onStart();
    }

    protected void onResume() {
        if (this.executor != null) {
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onResume", new Object[0]);
            this.executor.onResume();
        }
        super.onResume();
    }

    protected void onPause() {
        if (this.executor != null) {
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onPause", new Object[0]);
            this.executor.onPause();
        }
        super.onPause();
    }

    protected void onStop() {
        if (this.executor != null) {
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onStop", new Object[0]);
            this.executor.onStop();
        }
        super.onStop();
    }

    protected void onRestart() {
        if (this.executor != null) {
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onRestart", new Object[0]);
            this.executor.onRestart();
        }
        super.onRestart();
    }

    protected void onDestroy() {
        if (this.executor != null) {
            this.executor.sendResult();
            MobLog.getInstance().d(this.executor.getClass().getSimpleName() + " onDestroy", new Object[0]);
            this.executor.onDestroy();
        }
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.executor != null) {
            this.executor.onActivityResult(requestCode, resultCode, data);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        try {
            boolean ret = false;
            if (this.executor != null) {
                ret = this.executor.onKeyEvent(keyCode, event);
            }
            return ret ? true : super.onKeyDown(keyCode, event);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        try {
            boolean ret = false;
            if (this.executor != null) {
                ret = this.executor.onKeyEvent(keyCode, event);
            }
            return ret ? true : super.onKeyUp(keyCode, event);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.executor != null) {
            this.executor.onConfigurationChanged(newConfig);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (this.executor != null) {
            this.executor.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void finish() {
        if (this.executor != null && this.executor.onFinish()) {
            return;
        }
        super.finish();
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (Build.VERSION.SDK_INT == 26 && this.isTranslucentOrFloating()) {
            return;
        }
        super.setRequestedOrientation(requestedOrientation);
    }

    public Object getExecutor() {
        return this.executor;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        boolean res = super.onCreateOptionsMenu(menu);
        if (this.executor != null) {
            return this.executor.onCreateOptionsMenu(menu);
        }
        return res;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        boolean res = super.onOptionsItemSelected(item);
        if (this.executor != null) {
            return this.executor.onOptionsItemSelected(item);
        }
        return res;
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (this.executor != null) {
            this.executor.beforeStartActivityForResult(intent, requestCode, null);
        }
        super.startActivityForResult(intent, requestCode);
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        if (this.executor != null) {
            this.executor.beforeStartActivityForResult(intent, requestCode, options);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            super.startActivityForResult(intent, requestCode, options);
        } else {
            super.startActivityForResult(intent, requestCode);
        }
    }

    private boolean fixOrientation() {
        if (Build.VERSION.SDK_INT > 27) {
            return false;
        }
        try {
            Field field = Activity.class.getDeclaredField("mActivityInfo");
            field.setAccessible(true);
            ActivityInfo o = (ActivityInfo)field.get((Object)this);
            o.screenOrientation = -1;
            field.setAccessible(false);
            return true;
        }
        catch (Exception e) {
            MobLog.getInstance().w(e, (Object)"Fix orientation for 8.0 encountered exception", new Object[0]);
            return false;
        }
    }

    private boolean isTranslucentOrFloating() {
        if (Build.VERSION.SDK_INT > 27) {
            return false;
        }
        boolean isTranslucentOrFloating = false;
        try {
            int[] styleableRes = (int[])Class.forName("com.android.internal.R$styleable").getField("Window").get(null);
            TypedArray ta = this.executor.activity.obtainStyledAttributes(styleableRes);
            Method m = ActivityInfo.class.getMethod("isTranslucentOrFloating", TypedArray.class);
            m.setAccessible(true);
            isTranslucentOrFloating = (Boolean)m.invoke(null, ta);
            m.setAccessible(false);
        }
        catch (Exception e) {
            MobLog.getInstance().w(e);
        }
        return isTranslucentOrFloating;
    }

    static {
        MobLog.getInstance().d("===============================", new Object[0]);
        String version = "2020-09-02".replace("-0", "-");
        version = version.replace("-", ".");
        MobLog.getInstance().d("MobTools " + version, new Object[0]);
        MobLog.getInstance().d("===============================", new Object[0]);
    }
}

