/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.utils.Hashon;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;

public class SharePrefrenceHelper {
    private Context context;
    private MobSharePreference prefrence;

    public SharePrefrenceHelper(Context c) {
        if (c != null) {
            this.context = c.getApplicationContext();
        }
    }

    public void open(String name) {
        this.open(name, 0);
    }

    public void open(String name, int version) {
        String fileName = name + "_" + version;
        this.prefrence = new MobSharePreference(this.context, fileName);
    }

    public void putString(String key, String value) {
        if (this.prefrence != null) {
            this.prefrence.putString(key, value);
        }
    }

    public String getString(String key) {
        String defaultValue = "";
        if (this.prefrence != null) {
            return this.prefrence.getString(key, defaultValue);
        }
        return defaultValue;
    }

    public String getString(String key, String defValue) {
        if (this.prefrence != null) {
            return this.prefrence.getString(key, defValue);
        }
        return defValue;
    }

    public void putBoolean(String key, Boolean value) {
        if (this.prefrence != null) {
            this.prefrence.putBoolean(key, value);
        }
    }

    public boolean getBoolean(String key) {
        if (this.prefrence != null) {
            return this.prefrence.getBoolean(key, false);
        }
        return false;
    }

    public boolean getBoolean(String key, boolean defValue) {
        if (this.prefrence != null) {
            return this.prefrence.getBoolean(key, defValue);
        }
        return defValue;
    }

    public void putLong(String key, Long value) {
        if (this.prefrence != null) {
            this.prefrence.putLong(key, value);
        }
    }

    public long getLong(String key) {
        long defaultValue = 0L;
        if (this.prefrence != null) {
            return this.prefrence.getLong(key, defaultValue);
        }
        return defaultValue;
    }

    public long getLong(String key, long defValue) {
        if (this.prefrence != null) {
            return this.prefrence.getLong(key, defValue);
        }
        return defValue;
    }

    public void putInt(String key, Integer value) {
        if (this.prefrence != null) {
            this.prefrence.putInt(key, value);
        }
    }

    public int getInt(String key) {
        int defaultValue = 0;
        if (this.prefrence != null) {
            return this.prefrence.getInt(key, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key, int defValue) {
        if (this.prefrence != null) {
            return this.prefrence.getInt(key, defValue);
        }
        return defValue;
    }

    public void putFloat(String key, Float value) {
        if (this.prefrence != null) {
            this.prefrence.putFloat(key, value.floatValue());
        }
    }

    public float getFloat(String key) {
        float defaultValue = 0.0f;
        if (this.prefrence != null) {
            return this.prefrence.getFloat(key, defaultValue);
        }
        return defaultValue;
    }

    public float getFloat(String key, float defValue) {
        if (this.prefrence != null) {
            return this.prefrence.getFloat(key, defValue);
        }
        return defValue;
    }

    public void put(String key, Object value) {
        if (value == null) {
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            oos.close();
            byte[] data = baos.toByteArray();
            String base64 = Base64.encodeToString((byte[])data, (int)2);
            this.putString(key, base64);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    public Object get(String key) {
        try {
            String base64 = this.getString(key);
            if (TextUtils.isEmpty((CharSequence)base64)) {
                return null;
            }
            byte[] data = Base64.decode((String)base64, (int)2);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object value = ois.readObject();
            ois.close();
            return value;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public HashMap<String, Object> getAll() {
        if (this.prefrence != null) {
            return this.prefrence.getAll();
        }
        return new HashMap<String, Object>();
    }

    public void putAll(HashMap<String, Object> all) {
        if (this.prefrence != null) {
            this.prefrence.putAll(all);
        }
    }

    public void remove(String key) {
        if (this.prefrence != null) {
            this.prefrence.remove(key);
        }
    }

    public void clear() {
        if (this.prefrence != null) {
            this.prefrence.clear();
        }
    }

    public void setOnCommitListener(OnCommitListener listener) {
        if (this.prefrence != null) {
            this.prefrence.setOnCommitListener(listener);
        }
    }

    public static interface OnCommitListener {
        public void onCommit(Throwable var1);
    }

    private static final class MobSharePreference {
        private File spFile;
        private HashMap<String, Object> spMap;
        private Hashon hashon;
        private static Handler handler = MobHandlerThread.newHandler("s", new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                block5: {
                    OnCommitListener listener = null;
                    try {
                        listener = (OnCommitListener)msg.obj;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Bundle data = msg.getData();
                        String json = data.getString("json");
                        String filePath = data.getString("file");
                        FileOutputStream fos = new FileOutputStream(filePath);
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
                        osw.append(json);
                        osw.flush();
                        osw.close();
                        if (listener != null) {
                            listener.onCommit(null);
                        }
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().w(t);
                        if (listener == null) break block5;
                        listener.onCommit(t);
                    }
                }
                return false;
            }
        });
        private OnCommitListener listener;

        public MobSharePreference(Context context, String name) {
            try {
                if (context != null) {
                    File folder = new File(context.getFilesDir(), "Mob");
                    this.spFile = new File(folder, name);
                    if (!this.spFile.getParentFile().exists()) {
                        this.spFile.getParentFile().mkdirs();
                    }
                }
                this.spMap = new HashMap();
                this.hashon = new Hashon();
                this.open();
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void open() {
            HashMap<String, Object> hashMap = this.spMap;
            synchronized (hashMap) {
                if (this.spFile.exists()) {
                    try {
                        FileInputStream fis = new FileInputStream(this.spFile);
                        InputStreamReader isr = new InputStreamReader((InputStream)fis, "utf-8");
                        BufferedReader br = new BufferedReader(isr);
                        StringBuilder sb = new StringBuilder();
                        String line = br.readLine();
                        while (line != null) {
                            if (sb.length() > 0) {
                                sb.append("\n");
                            }
                            sb.append(line);
                            line = br.readLine();
                        }
                        br.close();
                        this.spMap = this.hashon.fromJson(sb.toString());
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().w(t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object get(String key) {
            HashMap<String, Object> hashMap = this.spMap;
            synchronized (hashMap) {
                return this.spMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void put(String key, Object value) {
            HashMap<String, Object> hashMap = this.spMap;
            synchronized (hashMap) {
                this.spMap.put(key, value);
                if (handler != null) {
                    Message msg = new Message();
                    Bundle data = new Bundle();
                    data.putString("json", this.hashon.fromHashMap(this.spMap));
                    data.putString("file", this.spFile.getAbsolutePath());
                    msg.setData(data);
                    msg.what = 1;
                    msg.obj = this.listener;
                    handler.sendMessage(msg);
                }
            }
        }

        public byte getByte(String key, byte defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).byteValue();
            }
            return defValue;
        }

        public void putByte(String key, byte value) {
            this.put(key, value);
        }

        public short getShort(String key, short defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).shortValue();
            }
            return defValue;
        }

        public void putShort(String key, short value) {
            this.put(key, value);
        }

        public int getInt(String key, int defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).intValue();
            }
            return defValue;
        }

        public void putInt(String key, int value) {
            this.put(key, value);
        }

        public long getLong(String key, long defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).longValue();
            }
            return defValue;
        }

        public void putLong(String key, long value) {
            this.put(key, value);
        }

        public float getFloat(String key, float defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).floatValue();
            }
            return defValue;
        }

        public void putFloat(String key, float value) {
            this.put(key, Float.valueOf(value));
        }

        public double getDouble(String key, double defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).doubleValue();
            }
            return defValue;
        }

        public void putDouble(String key, double value) {
            this.put(key, value);
        }

        public char getChar(String key, char defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((String)o).charAt(0);
            }
            return defValue;
        }

        public void putChar(String key, char value) {
            this.putString(key, String.valueOf(value));
        }

        public boolean getBoolean(String key, boolean defValue) {
            Object o = this.get(key);
            if (o != null) {
                return ((Number)o).byteValue() == 1;
            }
            return defValue;
        }

        public void putBoolean(String key, boolean value) {
            this.putByte(key, (byte)(value ? 1 : 0));
        }

        public String getString(String key, String defValue) {
            Object o = this.get(key);
            if (o != null) {
                return (String)o;
            }
            return defValue;
        }

        public void putString(String key, String value) {
            this.put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, Object> getAll() {
            HashMap<String, Object> hashMap = this.spMap;
            synchronized (hashMap) {
                HashMap<String, Object> all = new HashMap<String, Object>();
                all.putAll(this.spMap);
                return all;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(HashMap<String, Object> all) {
            HashMap<String, Object> hashMap = this.spMap;
            synchronized (hashMap) {
                this.spMap.putAll(all);
            }
            if (handler != null) {
                Message msg = new Message();
                Bundle data = new Bundle();
                data.putString("json", this.hashon.fromHashMap(this.spMap));
                data.putString("file", this.spFile.getAbsolutePath());
                msg.setData(data);
                msg.what = 1;
                msg.obj = this.listener;
                handler.sendMessage(msg);
            }
        }

        public void remove(String key) {
            this.put(key, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            HashMap<String, Object> hashMap = this.spMap;
            synchronized (hashMap) {
                this.spMap.clear();
            }
            if (handler != null) {
                Message msg = new Message();
                Bundle data = new Bundle();
                data.putString("json", this.hashon.fromHashMap(this.spMap));
                data.putString("file", this.spFile.getAbsolutePath());
                msg.setData(data);
                msg.what = 1;
                msg.obj = this.listener;
                handler.sendMessage(msg);
            }
        }

        public void setOnCommitListener(OnCommitListener listener) {
            this.listener = listener;
        }
    }
}

