/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.newlog;

import android.util.Log;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.newlog.FsLogAdapter;
import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;

public class AndroidLogAdapter
implements FsLogAdapter {
    @Override
    public boolean isLoggable(int priority, String tag) {
        return true;
    }

    @Override
    public void log(int priority, String tag, String message) {
        Log.println((int)priority, (String)this.getFormatTag(tag), (String)this.formatMessage(message));
    }

    private String formatMessage(String message) {
        if (FsFoundationInitializer.isDebug()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[9];
            return Strings.lenientFormat((String)"<tid:%s>(%s:%s) - %s", (Object[])new Object[]{Thread.currentThread().getId(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), message});
        }
        return message;
    }

    @Override
    public String getFormatTag(String tag) {
        String onceOnlyTag = AndroidLogAdapter.class.getSimpleName();
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            onceOnlyTag = onceOnlyTag + "-" + tag;
        }
        return onceOnlyTag;
    }
}

