/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.fshows.android.stark.exception.FsException;
import com.fshows.android.stark.utils.CommonUtil;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.MD5Util;
import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FileUtil {
    private static final String TAG = FileUtil.class.getSimpleName();
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    public static final File INVALID_FILE = new File("");
    private static final int BUFFER_SIZE = 1024;
    private static final long MIN_SPACE = 0L;
    private static String mRootPath;

    public static String genKeyForUrl(String url) {
        if (url == null) {
            return null;
        }
        String cacheKey = MD5Util.getStringMD5(url.trim());
        if (Strings.isNullOrEmpty((String)cacheKey)) {
            cacheKey = String.valueOf(url.hashCode());
        }
        return cacheKey;
    }

    public static String genKeyForUrl(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        String cacheKey = MD5Util.getFileMD5(file);
        if (Strings.isNullOrEmpty((String)cacheKey)) {
            cacheKey = String.valueOf(file.hashCode());
        }
        return cacheKey;
    }

    private static String getRootPathWithSdcard(Context context) {
        StringBuilder builder = new StringBuilder();
        File dirFile = Environment.getExternalStorageDirectory();
        if (dirFile == null || !dirFile.canWrite()) {
            return null;
        }
        builder.append(dirFile.getAbsolutePath()).append(File.separator).append("Download").append(File.separator).append(context.getPackageName());
        File file = new File(builder.toString());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static String getRootPathWithoutSdcard(Context context) {
        String rootPath = context.getCacheDir().getAbsolutePath() + File.separator + "apps";
        String[] args1 = new String[]{"chmod", "705", rootPath};
        CommonUtil.exec(args1);
        return rootPath;
    }

    public static synchronized String getRootPath(Context context) {
        if (mRootPath == null) {
            String rootPath = null;
            try {
                if (rootPath == null && Build.VERSION.SDK_INT >= 23 && !FileUtil.canCreateFile(rootPath = FileUtil.getRootPathForApi19(context))) {
                    rootPath = null;
                }
                if (rootPath == null && Environment.getExternalStorageState().equals("mounted") && FileUtil.hasEnoughSpaceOnSDCard() && !FileUtil.canCreateFile(rootPath = FileUtil.getRootPathWithSdcard(context))) {
                    rootPath = null;
                }
                if (rootPath == null && Build.VERSION.SDK_INT >= 19 && !FileUtil.canCreateFile(rootPath = FileUtil.getRootPathForApi19(context))) {
                    rootPath = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (rootPath == null) {
                rootPath = FileUtil.getRootPathWithoutSdcard(context);
            }
            mRootPath = rootPath;
        } else if (mRootPath.startsWith(context.getCacheDir().getAbsolutePath())) {
            String[] args1 = new String[]{"chmod", "705", mRootPath};
            CommonUtil.exec(args1);
        }
        return mRootPath;
    }

    @TargetApi(value=19)
    public static String getRootPathForApi19(Context context) {
        String rootPath = null;
        File[] fs = context.getExternalFilesDirs(null);
        if (fs == null || fs.length == 0) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(fs.length);
        for (File f : fs) {
            if (f == null) continue;
            if (!f.exists()) {
                f.mkdirs();
            }
            if (!f.isDirectory() || !f.canWrite() || !f.canRead()) continue;
            fileList.add(f);
        }
        if (fileList.size() == 0) {
            return null;
        }
        if (fileList.size() == 1) {
            ((File)fileList.get(0)).mkdirs();
            rootPath = ((File)fileList.get(0)).getAbsolutePath();
        } else {
            long max = 0L;
            for (int i = 0; i < fileList.size(); ++i) {
                long[] l = FileUtil.getStorageSpacesLong(context, ((File)fileList.get(i)).getAbsolutePath());
                if (l[1] <= max) continue;
                max = l[1];
                ((File)fileList.get(i)).mkdirs();
                rootPath = ((File)fileList.get(i)).getAbsolutePath();
            }
        }
        return rootPath;
    }

    private static boolean canCreateFile(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path, "file.test");
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            file.delete();
            return true;
        }
        try {
            boolean b = file.createNewFile();
            file.delete();
            return b;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @TargetApi(value=18)
    public static long[] getStorageSpacesLong(Context context, String path) {
        String rootPath = FileUtil.getUsbRootPath(context, path);
        File file = new File(rootPath);
        if (!file.exists()) {
            return null;
        }
        long[] l = new long[2];
        StatFs stat = new StatFs(rootPath);
        long blockSize = 0L;
        long blockCount = 0L;
        long availableBlocks = 0L;
        if (Build.VERSION.SDK_INT < 18) {
            blockSize = stat.getBlockSize();
            blockCount = stat.getBlockCount();
            availableBlocks = stat.getAvailableBlocks();
        } else {
            blockSize = stat.getBlockSizeLong();
            blockCount = stat.getBlockCountLong();
            availableBlocks = stat.getAvailableBlocksLong();
        }
        l[0] = blockSize * availableBlocks;
        l[1] = blockSize * blockCount;
        return l;
    }

    public static String getUsbRootPath(Context context, String path) {
        String packageName;
        String usbRootPath = path.contains("Android/data") ? path.substring(0, path.indexOf("Android/data")) : (path.contains(packageName = context.getPackageName()) ? path.substring(0, path.indexOf(packageName)) : path);
        return usbRootPath;
    }

    private static boolean hasEnoughSpaceOnSDCard() {
        File file = Environment.getExternalStorageDirectory();
        if (!(file.exists() && file.canWrite() && file.canRead())) {
            Log.i((String)TAG, (String)"file is not exists");
            return false;
        }
        StatFs stat = new StatFs(file.getAbsolutePath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        Log.i((String)TAG, (String)("space : " + blockSize * availableBlocks));
        return blockSize * availableBlocks > 0L;
    }

    public static File createTempFile(Context context, String key) {
        String rootPath = FileUtil.getRootPath(context);
        File newFile = new File(rootPath, key + TEMP_FILE_SUFFIX);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        return newFile;
    }

    public static void renameFile(File tempFile, File newFile) {
        tempFile.renameTo(newFile);
    }

    public static boolean isCompleteFile(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return false;
        }
        return !path.endsWith(TEMP_FILE_SUFFIX);
    }

    public static File getRootPath() {
        File path = null;
        path = FileUtil.sdCardIsAvailable() ? Environment.getExternalStorageDirectory() : Environment.getDataDirectory();
        return path;
    }

    public static boolean sdCardIsAvailable() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File sd = new File(Environment.getExternalStorageDirectory().getPath());
            return sd.canWrite();
        }
        return false;
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtil.createOrExistsDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtil.createOrExistsFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File getFileByPath(String filePath) {
        return FileUtil.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static File copyFileFromAssets(Context context, String sourceFileName, String destFileName) throws FsException {
        File destFile = new File(destFileName);
        File srcFile = new File(sourceFileName);
        return FileUtil.copyFileFromAssets(context, srcFile, destFile);
    }

    /*
     * Exception decompiling
     */
    public static File copyFileFromAssets(Context context, File srcFile, File destFile) throws FsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] assetsFileToBytes(Context context, File file) throws FsException {
        FsLogUtil.debug(TAG, "read Assets File, {}", file.toString());
        try (InputStream is = context.getAssets().open(file.toString());){
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
        catch (Exception e) {
            throw new FsException(e);
        }
    }

    @Beta
    public static boolean deleteDir(File file, boolean deleteSelf) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i != children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(file, children[i]), true);
                if (success) continue;
                return false;
            }
            if (deleteSelf) {
                return file.delete();
            }
        } else if (file.isFile()) {
            return file.delete();
        }
        return true;
    }

    private static final class FileSearchComp
    implements FilenameFilter {
        private String key;

        public FileSearchComp(String key) {
            this.key = key;
        }

        @Override
        public boolean accept(File dir, String filename) {
            if (null == this.key) {
                return false;
            }
            if (null == filename) {
                return false;
            }
            return filename.startsWith(this.key);
        }
    }
}

