/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview.adapter;

import androidx.recyclerview.widget.RecyclerView;
import com.fshows.android.parker.recyclerview.BaseRecyclerRepository;
import com.fshows.android.parker.recyclerview.adapter.BaseRecyclerViewHolder;
import com.fshows.android.parker.recyclerview.callback.ItemClickPresenter;
import com.fshows.android.parker.recyclerview.callback.ItemLongClickPresenter;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRecyclerViewAdapter<T>
extends RecyclerView.Adapter<BaseRecyclerViewHolder> {
    protected List<T> data = new ArrayList<T>();
    protected ItemClickPresenter itemClickPresenter;
    protected ItemLongClickPresenter itemLongClickPresenter;
    protected int headersCount = 0;

    public void onBindViewHolder(BaseRecyclerViewHolder holder, int position) {
        holder.onBaseBindViewHolder(this.getItem(position), position);
        if (this.itemClickPresenter != null) {
            holder.itemView.setOnClickListener(v -> this.itemClickPresenter.onItemClick(v, this.data.get(position), position));
        }
        if (this.itemLongClickPresenter != null) {
            holder.itemView.setOnLongClickListener(v -> {
                this.itemLongClickPresenter.onItemLongClick(v, this.data.get(position), position);
                return false;
            });
        }
    }

    public void setItemClickPresenter(ItemClickPresenter itemClickPresenter) {
        this.itemClickPresenter = itemClickPresenter;
    }

    public void setItemLongClickPresenter(ItemLongClickPresenter itemLongClickPresenter) {
        this.itemLongClickPresenter = itemLongClickPresenter;
    }

    public int getItemViewType(int position) {
        if (this.getItem(position) instanceof BaseRecyclerRepository && this.getItemCount() > 0 && this.data.get(position) != null) {
            return ((BaseRecyclerRepository)this.data.get((int)position)).viewType;
        }
        return super.getItemViewType(position);
    }

    public T getItem(int position) {
        return this.data.get(position);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void setNewAll(List<T> data) {
        this.data.clear();
        this.data.addAll(data);
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> data) {
        this.data.addAll(data);
        this.notifyItemRangeInserted(this.data.size() - data.size() + this.getHeadersCount(), data.size());
    }

    public void add(T t) {
        this.data.add(t);
    }

    public void add(int position, T t) {
        this.data.add(position, t);
    }

    public void set(int position, T t) {
        this.data.set(position, t);
    }

    public void clear() {
        this.data.clear();
    }

    public void remove(T t) {
        this.data.remove(t);
    }

    public void remove(int position) {
        this.data.remove(position);
    }

    public void removeAll(List<T> data) {
        this.data.removeAll(data);
    }

    public List<T> getData() {
        return this.data;
    }

    public boolean isPinnedPosition(int position) {
        return false;
    }

    public void setHeadersCount(int headersCount) {
        this.headersCount = headersCount;
    }

    public int getHeadersCount() {
        return this.headersCount;
    }
}

