/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.fshows.android.parker.R;
import com.fshows.android.parker.recyclerview.IRefreshHeader;

public class YunRefreshHeader
extends LinearLayout
implements IRefreshHeader {
    private Context mContext;
    private AnimationDrawable animationDrawable;
    private TextView msg;
    private int mState = 0;
    private int mMeasuredHeight;
    private LinearLayout mContainer;
    private RelativeLayout mLoadingRl;

    public YunRefreshHeader(Context context) {
        this(context, null);
    }

    public YunRefreshHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YunRefreshHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.kaws_refresh_header, (ViewGroup)this);
        ImageView img = (ImageView)this.findViewById(R.id.img);
        this.animationDrawable = (AnimationDrawable)img.getDrawable();
        if (this.animationDrawable != null && this.animationDrawable.isRunning()) {
            this.animationDrawable.stop();
        }
        this.mLoadingRl = (RelativeLayout)this.findViewById(R.id.gif_container);
        this.msg = (TextView)this.findViewById(R.id.msg);
        this.measure(-2, -2);
        this.mMeasuredHeight = this.getMeasuredHeight();
        this.setGravity(1);
        this.mContainer = (LinearLayout)this.findViewById(R.id.container);
        this.setVisibleHeight(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }

    @Override
    public void onMove(float delta) {
        if (this.getVisibleHeight() > 0 || delta > 0.0f) {
            this.setVisibleHeight((int)delta + this.getVisibleHeight());
            if (this.mState <= 1) {
                if (this.getVisibleHeight() > this.mMeasuredHeight) {
                    this.setState(1);
                } else {
                    this.setState(0);
                }
            }
        }
    }

    @Override
    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        switch (state) {
            case 0: {
                if (this.animationDrawable != null && this.animationDrawable.isRunning()) {
                    this.animationDrawable.stop();
                }
                this.msg.setText(R.string.listview_header_hint_normal);
                break;
            }
            case 1: {
                if (this.mState == 1) break;
                if (this.animationDrawable != null && !this.animationDrawable.isRunning()) {
                    this.animationDrawable.start();
                }
                this.msg.setText(R.string.listview_header_hint_release);
                break;
            }
            case 2: {
                this.msg.setText(R.string.refreshing);
                break;
            }
            case 3: {
                this.msg.setText(R.string.refresh_done);
                break;
            }
        }
        this.mState = state;
    }

    @Override
    public boolean releaseAction() {
        boolean isOnRefresh = false;
        int height = this.getVisibleHeight();
        if (height == 0) {
            isOnRefresh = false;
        }
        if (this.getVisibleHeight() > this.mMeasuredHeight && this.mState < 2) {
            this.setState(2);
            isOnRefresh = true;
        }
        if (this.mState != 2 || height <= this.mMeasuredHeight) {
            // empty if block
        }
        int destHeight = 0;
        if (this.mState == 2) {
            destHeight = this.mMeasuredHeight;
        }
        this.smoothScrollTo(destHeight);
        return isOnRefresh;
    }

    @Override
    public void refreshComplete() {
        this.setState(3);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                YunRefreshHeader.this.reset();
            }
        }, 500L);
    }

    public void reset() {
        this.smoothScrollTo(0);
        this.setState(0);
    }

    private void smoothScrollTo(int destHeight) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getVisibleHeight(), destHeight});
        animator.setDuration(300L).start();
        animator.addUpdateListener(animation -> this.setVisibleHeight((Integer)animation.getAnimatedValue()));
        animator.start();
    }

    @Override
    public void setVisibleHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 0);
        lp.height = height;
        this.mLoadingRl.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public int getVisibleHeight() {
        return this.mLoadingRl.getHeight();
    }

    @Override
    public int getState() {
        return this.mState;
    }
}

