/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsvideo;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.CountDownTimer;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.fshows.fsvideo.IFsVideoPlayerController;
import com.fshows.fsvideo.R;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

public class FsVideoPlayerController
extends IFsVideoPlayerController
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    private Context mContext;
    private ImageView mCenterStart;
    private ImageView mImage;
    private LinearLayout mTop;
    private ImageView mBack;
    private TextView mTitle;
    private LinearLayout mBatteryTime;
    private ImageView mBattery;
    private TextView mTime;
    private LinearLayout mBottom;
    private ImageView mRestartPause;
    private TextView mPosition;
    private TextView mDuration;
    private SeekBar mSeek;
    private ImageView mFullScreen;
    private TextView mLength;
    private LinearLayout mLoading;
    private TextView mLoadText;
    private LinearLayout mChangePosition;
    private TextView mChangePositionCurrent;
    private ProgressBar mChangePositionProgress;
    private LinearLayout mChangeBrightness;
    private ProgressBar mChangeBrightnessProgress;
    private LinearLayout mChangeVolume;
    private ProgressBar mChangeVolumeProgress;
    private LinearLayout mError;
    private TextView mRetry;
    private LinearLayout mCompleted;
    private TextView mReplay;
    private CountDownTimer mDismissTopBottomCountDownTimer;
    private boolean topBottomVisible;
    private boolean hasRegisterBatteryReceiver;
    private boolean normalCanBack;
    private BroadcastReceiver mBatterReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra("status", 1);
            if (status == 2) {
                FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_charging);
            } else if (status == 5) {
                FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_full);
            } else {
                int scale;
                int level = intent.getIntExtra("level", 0);
                int percentage = (int)((float)level / (float)(scale = intent.getIntExtra("scale", 0)) * 100.0f);
                if (percentage <= 10) {
                    FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_10);
                } else if (percentage <= 20) {
                    FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_20);
                } else if (percentage <= 50) {
                    FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_50);
                } else if (percentage <= 80) {
                    FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_80);
                } else if (percentage <= 100) {
                    FsVideoPlayerController.this.mBattery.setImageResource(R.mipmap.ic_battery_100);
                }
            }
        }
    };
    private int newPosition;

    public FsVideoPlayerController(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.fs_video_palyer_controller, (ViewGroup)this, true);
        this.mCenterStart = (ImageView)this.findViewById(R.id.center_start);
        this.mImage = (ImageView)this.findViewById(R.id.image);
        this.mTop = (LinearLayout)this.findViewById(R.id.top);
        this.mBack = (ImageView)this.findViewById(R.id.back);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mBatteryTime = (LinearLayout)this.findViewById(R.id.battery_time);
        this.mBattery = (ImageView)this.findViewById(R.id.battery);
        this.mTime = (TextView)this.findViewById(R.id.time);
        this.mBottom = (LinearLayout)this.findViewById(R.id.bottom);
        this.mRestartPause = (ImageView)this.findViewById(R.id.restart_or_pause);
        this.mPosition = (TextView)this.findViewById(R.id.position);
        this.mDuration = (TextView)this.findViewById(R.id.duration);
        this.mSeek = (SeekBar)this.findViewById(R.id.seek);
        this.mFullScreen = (ImageView)this.findViewById(R.id.full_screen);
        this.mLength = (TextView)this.findViewById(R.id.length);
        this.mLoading = (LinearLayout)this.findViewById(R.id.loading);
        this.mLoadText = (TextView)this.findViewById(R.id.load_text);
        this.mChangePosition = (LinearLayout)this.findViewById(R.id.change_position);
        this.mChangePositionCurrent = (TextView)this.findViewById(R.id.change_position_current);
        this.mChangePositionProgress = (ProgressBar)this.findViewById(R.id.change_position_progress);
        this.mChangeBrightness = (LinearLayout)this.findViewById(R.id.change_brightness);
        this.mChangeBrightnessProgress = (ProgressBar)this.findViewById(R.id.change_brightness_progress);
        this.mChangeVolume = (LinearLayout)this.findViewById(R.id.change_volume);
        this.mChangeVolumeProgress = (ProgressBar)this.findViewById(R.id.change_volume_progress);
        this.mError = (LinearLayout)this.findViewById(R.id.error);
        this.mRetry = (TextView)this.findViewById(R.id.retry);
        this.mCompleted = (LinearLayout)this.findViewById(R.id.completed);
        this.mReplay = (TextView)this.findViewById(R.id.replay);
        this.mCenterStart.setOnClickListener((View.OnClickListener)this);
        this.mBack.setOnClickListener((View.OnClickListener)this);
        this.mRestartPause.setOnClickListener((View.OnClickListener)this);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mRetry.setOnClickListener((View.OnClickListener)this);
        this.mReplay.setOnClickListener((View.OnClickListener)this);
        this.mSeek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.setOnClickListener(this);
    }

    @Override
    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    @Override
    public void setStartImage(int resId) {
        this.mImage.setImageResource(resId);
    }

    @Override
    public ImageView imageView() {
        return this.mImage;
    }

    @Override
    public void setLength(int length) {
        this.mLength.setText((CharSequence)FsVideoPlayerController.formatTime(length));
    }

    @Override
    protected void onPlayStateChanged(int playState) {
        switch (playState) {
            case 0: {
                break;
            }
            case 1: {
                this.mImage.setVisibility(8);
                this.mLoading.setVisibility(0);
                this.mLoadText.setText((CharSequence)"\u6b63\u5728\u51c6\u5907...");
                this.mError.setVisibility(8);
                this.mCompleted.setVisibility(8);
                this.mTop.setVisibility(8);
                this.mBottom.setVisibility(8);
                this.mCenterStart.setVisibility(8);
                this.mLength.setVisibility(8);
                break;
            }
            case 2: {
                this.startUpdateProgressTimer();
                break;
            }
            case 3: {
                this.mLoading.setVisibility(8);
                this.mRestartPause.setImageResource(R.mipmap.ic_player_pause);
                this.startDismissTopBottomTimer();
                break;
            }
            case 4: {
                this.mLoading.setVisibility(8);
                this.mRestartPause.setImageResource(R.mipmap.ic_player_start);
                this.cancelDismissTopBottomTimer();
                break;
            }
            case 5: {
                this.mLoading.setVisibility(0);
                this.mRestartPause.setImageResource(R.mipmap.ic_player_pause);
                this.mLoadText.setText((CharSequence)"\u6b63\u5728\u7f13\u51b2...");
                this.startDismissTopBottomTimer();
                break;
            }
            case 6: {
                this.mLoading.setVisibility(0);
                this.mRestartPause.setImageResource(R.mipmap.ic_player_start);
                this.mLoadText.setText((CharSequence)"\u6b63\u5728\u7f13\u51b2...");
                this.cancelDismissTopBottomTimer();
                break;
            }
            case -1: {
                this.cancelDismissTopBottomTimer();
                this.setTopBottomVisible(false);
                this.mTop.setVisibility(0);
                this.mError.setVisibility(0);
                break;
            }
            case 7: {
                this.cancelDismissTopBottomTimer();
                this.setTopBottomVisible(false);
                this.mTop.setVisibility(0);
                this.mImage.setVisibility(0);
                this.mCompleted.setVisibility(0);
                break;
            }
        }
    }

    @Override
    protected void onPlayModeChanged(int playMode) {
        switch (playMode) {
            case 11: {
                this.mBack.setVisibility(0);
                this.mFullScreen.setVisibility(8);
                this.mFullScreen.setImageResource(R.mipmap.ic_player_shrink);
                this.mBatteryTime.setVisibility(0);
                if (this.hasRegisterBatteryReceiver) break;
                this.mContext.registerReceiver(this.mBatterReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                this.hasRegisterBatteryReceiver = true;
                break;
            }
            case 10: {
                if (this.normalCanBack) {
                    this.mBack.setVisibility(0);
                } else {
                    this.mBack.setVisibility(8);
                }
                this.mFullScreen.setImageResource(R.mipmap.ic_player_enlarge);
                this.mFullScreen.setVisibility(0);
                this.mBatteryTime.setVisibility(8);
                if (!this.hasRegisterBatteryReceiver) break;
                this.mContext.unregisterReceiver(this.mBatterReceiver);
                this.hasRegisterBatteryReceiver = false;
                break;
            }
        }
    }

    @Override
    protected void reset() {
        this.topBottomVisible = false;
        this.cancelUpdateProgressTimer();
        this.cancelDismissTopBottomTimer();
        this.mSeek.setProgress(0);
        this.mSeek.setSecondaryProgress(0);
        this.mCenterStart.setVisibility(0);
        this.mImage.setVisibility(0);
        this.mBottom.setVisibility(8);
        this.mFullScreen.setImageResource(R.mipmap.ic_player_enlarge);
        this.mLength.setVisibility(0);
        this.mTop.setVisibility(0);
        if (this.normalCanBack) {
            this.mBack.setVisibility(0);
        } else {
            this.mBack.setVisibility(8);
        }
        this.mLoading.setVisibility(8);
        this.mError.setVisibility(8);
        this.mCompleted.setVisibility(8);
    }

    @Override
    protected void updateProgress() {
        long position = this.mIFsVideoPlayer.getCurrentPosition();
        long duration = this.mIFsVideoPlayer.getDuration();
        int bufferPercentage = this.mIFsVideoPlayer.getBufferPercentage();
        this.mSeek.setSecondaryProgress(bufferPercentage);
        int progress = (int)(100.0f * (float)position / (float)duration);
        this.mSeek.setProgress(progress);
        this.mPosition.setText((CharSequence)FsVideoPlayerController.formatTime(position));
        this.mDuration.setText((CharSequence)FsVideoPlayerController.formatTime(duration));
        this.mTime.setText((CharSequence)new SimpleDateFormat("HH:mm", Locale.CHINA).format(new Date()));
    }

    @Override
    protected void showChangeVolume(int newVolumeProgress) {
        this.mChangeVolume.setVisibility(0);
        this.mChangeVolumeProgress.setProgress(newVolumeProgress);
    }

    @Override
    protected void hideChangeVolume() {
        this.mChangeVolume.setVisibility(8);
    }

    @Override
    protected void showChangeBrightness(int newBrightnessProgress) {
        this.mChangeBrightness.setVisibility(0);
        this.mChangeBrightnessProgress.setProgress(newBrightnessProgress);
    }

    @Override
    protected void hideChangeBrightness() {
        this.mChangeBrightness.setVisibility(8);
    }

    @Override
    protected void showChangePosition(long duration, int newPositionProgress) {
        this.mChangePosition.setVisibility(0);
        long newPosition = (long)((float)(duration * (long)newPositionProgress) / 100.0f);
        this.mChangePositionCurrent.setText((CharSequence)FsVideoPlayerController.formatTime(newPosition));
        this.mChangePositionProgress.setProgress(newPositionProgress);
        this.mSeek.setProgress(newPositionProgress);
        this.mPosition.setText((CharSequence)FsVideoPlayerController.formatTime(newPosition));
    }

    @Override
    protected void hideChangePosition() {
        this.mChangePosition.setVisibility(8);
    }

    @Override
    public void isAbleFullScreen(boolean isAble) {
        if (isAble) {
            this.mFullScreen.setVisibility(0);
        } else {
            this.mFullScreen.setVisibility(8);
        }
    }

    public void onClick(View view) {
        if (view == this.mCenterStart) {
            this.startPlay();
        } else if (view == this.mBack) {
            if (this.mIFsVideoPlayer.isFullScreen()) {
                this.mIFsVideoPlayer.exitFullScreen();
            } else {
                try {
                    ((Activity)this.mContext).finish();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (view == this.mRestartPause) {
            if (this.mIFsVideoPlayer.getPlayState() == 3 || this.mIFsVideoPlayer.getPlayState() == 5) {
                this.mIFsVideoPlayer.pause();
            } else if (this.mIFsVideoPlayer.getPlayState() == 4 || this.mIFsVideoPlayer.getPlayState() == 6) {
                this.mIFsVideoPlayer.reStart();
            }
        } else if (view == this.mFullScreen) {
            if (this.mIFsVideoPlayer.isNormal()) {
                this.mIFsVideoPlayer.enterFullScreen();
            }
        } else if (view == this.mRetry) {
            this.mIFsVideoPlayer.reStart();
        } else if (view == this.mReplay) {
            this.mRetry.performClick();
        } else if (view == this && (this.mIFsVideoPlayer.getPlayState() == 3 || this.mIFsVideoPlayer.getPlayState() == 4 || this.mIFsVideoPlayer.getPlayState() == 6 || this.mIFsVideoPlayer.getPlayState() == 5)) {
            this.setTopBottomVisible(!this.topBottomVisible);
        }
    }

    public void startPlay() {
        if (this.mIFsVideoPlayer.getPlayState() == 0) {
            this.mIFsVideoPlayer.start();
        }
    }

    private void startDismissTopBottomTimer() {
        this.cancelDismissTopBottomTimer();
        if (this.mDismissTopBottomCountDownTimer == null) {
            this.mDismissTopBottomCountDownTimer = new CountDownTimer(8000L, 8000L){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    FsVideoPlayerController.this.setTopBottomVisible(false);
                }
            };
        }
        this.mDismissTopBottomCountDownTimer.start();
    }

    private void cancelDismissTopBottomTimer() {
        if (this.mDismissTopBottomCountDownTimer != null) {
            this.mDismissTopBottomCountDownTimer.cancel();
        }
    }

    private void setTopBottomVisible(boolean visible) {
        this.mTop.setVisibility(visible ? 0 : 8);
        this.mBottom.setVisibility(visible ? 0 : 8);
        this.topBottomVisible = visible;
        if (visible) {
            if (this.mIFsVideoPlayer.getPlayState() != 4 && this.mIFsVideoPlayer.getPlayState() != 6) {
                this.startDismissTopBottomTimer();
            }
        } else {
            this.cancelDismissTopBottomTimer();
        }
    }

    public static String formatTime(long milliseconds) {
        if (milliseconds <= 0L || milliseconds >= 86400000L) {
            return "00:00";
        }
        long totalSeconds = milliseconds / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0L) {
            return mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
        if (b) {
            long duration = this.mIFsVideoPlayer.getDuration();
            this.newPosition = (int)(duration * (long)i / 100L);
            this.showChangePosition(duration, i);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        this.mIFsVideoPlayer.seekTo(this.newPosition);
        this.hideChangePosition();
        this.startUpdateProgressTimer();
        this.newPosition = 0;
    }

    public void setStartImg(Uri uri) {
        Glide.with((Context)this.mContext).load(uri).into(this.mImage);
    }

    public void setNormalCanBack(boolean back) {
        this.normalCanBack = back;
    }
}

