/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework;

import android.text.TextUtils;
import cn.sharesdk.framework.utils.e;
import com.mob.MobSDK;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.SharePrefrenceHelper;
import java.util.HashMap;

public class PlatformDb {
    private static final String DB_NAME = "cn_sharesdk_weibodb";
    private SharePrefrenceHelper sp = new SharePrefrenceHelper(MobSDK.getContext());
    private String platformNname;
    private int platformVersion;

    public PlatformDb(String name, int version) {
        this.sp.open("cn_sharesdk_weibodb_" + name, version);
        this.platformNname = name;
        this.platformVersion = version;
    }

    public void put(String key, String value) {
        this.sp.putString(key, value);
    }

    public String get(String key) {
        return this.sp.getString(key);
    }

    public String getToken() {
        return this.sp.getString("token");
    }

    public void putToken(String token) {
        this.sp.putString("token", token);
    }

    public String getTokenSecret() {
        return this.sp.getString("secret");
    }

    public void putTokenSecret(String secret) {
        this.sp.putString("secret", secret);
    }

    public long getExpiresIn() {
        long l2 = 0L;
        try {
            l2 = this.sp.getLong("expiresIn");
        }
        catch (Throwable throwable) {
            try {
                l2 = this.sp.getInt("expiresIn");
            }
            catch (Throwable throwable2) {
                l2 = 0L;
            }
        }
        return l2;
    }

    public void putExpiresIn(long expires) {
        this.sp.putLong("expiresIn", Long.valueOf(expires));
        this.sp.putLong("expiresTime", Long.valueOf(System.currentTimeMillis()));
    }

    public long getExpiresTime() {
        long l2 = this.sp.getLong("expiresTime");
        long l3 = this.getExpiresIn();
        return l2 + l3 * 1000L;
    }

    public int getPlatformVersion() {
        return this.platformVersion;
    }

    public String getPlatformNname() {
        return this.platformNname;
    }

    public void putUserId(String platformId) {
        this.sp.putString("userID", platformId);
    }

    public String getUserId() {
        String string = this.sp.getString("userID");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.sp.getString("weibo");
        }
        return string;
    }

    public String getUserName() {
        return this.sp.getString("nickname");
    }

    public String getUserIcon() {
        return this.sp.getString("icon");
    }

    public void removeAccount() {
        this.sp.clear();
    }

    public String exportData() {
        try {
            HashMap hashMap = new HashMap();
            hashMap.putAll(this.sp.getAll());
            return new Hashon().fromHashMap(hashMap);
        }
        catch (Throwable throwable) {
            e.b().d(throwable);
            return null;
        }
    }

    public void importData(String json) {
        try {
            HashMap hashMap = new Hashon().fromJson(json);
            if (hashMap != null) {
                this.sp.putAll(hashMap);
            }
        }
        catch (Throwable throwable) {
            e.b().d(throwable);
        }
    }

    public boolean isValid() {
        String string = this.getToken();
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (this.getExpiresIn() == 0L) {
            return true;
        }
        return this.getExpiresTime() > System.currentTimeMillis();
    }

    public String getUserGender() {
        String string = this.sp.getString("gender");
        if ("0".equals(string)) {
            return "m";
        }
        if ("1".equals(string)) {
            return "f";
        }
        return null;
    }
}

