/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.visitor;

import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.org.objectweb.asm.Label;
import com.mob.mobapm.org.objectweb.asm.MethodVisitor;
import com.mob.mobapm.org.objectweb.asm.Type;
import com.mob.mobapm.org.objectweb.asm.commons.AdviceAdapter;
import com.mob.mobapm.org.objectweb.asm.commons.Method;
import java.util.ArrayList;

public class TraceMethodVisitor
extends AdviceAdapter {
    public static final String TRACE_MACHINE_INTERNAL_CLASSNAME = "com/mob/mobapm/tracing/TraceMachine";
    protected final InstrumentationContext context;
    private String name;
    protected Boolean unloadContext = Boolean.FALSE;
    protected Boolean startTracing = Boolean.FALSE;
    private int access;

    public TraceMethodVisitor(MethodVisitor mv, int access, String name, String desc, InstrumentationContext context) {
        super(327680, mv, access, name, desc);
        this.access = access;
        this.context = context;
        this.name = name;
    }

    public void setUnloadContext() {
        this.unloadContext = Boolean.TRUE;
    }

    public void setStartTracing() {
        this.startTracing = Boolean.TRUE;
    }

    @Override
    protected void onMethodEnter() {
        Type targetType = Type.getObjectType(TRACE_MACHINE_INTERNAL_CLASSNAME);
        if (this.startTracing.booleanValue()) {
            this.visitLdcInsn(this.context.getSimpleClassName());
            this.invokeStatic(targetType, new Method("startTracing", "(Ljava/lang/String;)V"));
        }
        if ((this.access & 8) != 0) {
            this.visitInsn(1);
            this.visitLdcInsn(this.context.getSimpleClassName() + "#" + this.name);
            this.emitAnnotationParamsList(this.name);
            this.invokeStatic(targetType, new Method("enterMethod", "(Lcom/mob/mobapm/tracing/Trace;Ljava/lang/String;Ljava/util/ArrayList;)V"));
        } else {
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label tryHandler = new Label();
            this.visitLabel(tryStart);
            this.loadThis();
            this.getField(Type.getObjectType(this.context.getClassName()), "_nr_trace", Type.getType("Lcom/mob/mobapm/tracing/Trace;"));
            this.visitLdcInsn(this.context.getSimpleClassName() + "#" + this.name);
            this.emitAnnotationParamsList(this.name);
            this.invokeStatic(targetType, new Method("enterMethod", "(Lcom/mob/mobapm/tracing/Trace;Ljava/lang/String;Ljava/util/ArrayList;)V"));
            this.goTo(tryEnd);
            this.visitLabel(tryHandler);
            this.pop();
            this.visitInsn(1);
            this.visitLdcInsn(this.context.getSimpleClassName() + "#" + this.name);
            this.emitAnnotationParamsList(this.name);
            this.invokeStatic(targetType, new Method("enterMethod", "(Lcom/mob/mobapm/tracing/Trace;Ljava/lang/String;Ljava/util/ArrayList;)V"));
            this.visitLabel(tryEnd);
            this.visitTryCatchBlock(tryStart, tryEnd, tryHandler, "java/lang/NoSuchFieldError");
        }
    }

    private void emitAnnotationParamsList(String name) {
        ArrayList<String> annotationParameters = this.context.getTracedMethodParameters(name);
        if (annotationParameters == null || annotationParameters.size() == 0) {
            this.visitInsn(1);
            return;
        }
        Method constructor = Method.getMethod("void <init> ()");
        Method add = Method.getMethod("boolean add(java.lang.Object)");
        Type arrayListType = Type.getObjectType("java/util/ArrayList");
        this.newInstance(arrayListType);
        this.dup();
        this.invokeConstructor(arrayListType, constructor);
        for (String parameterEntry : annotationParameters) {
            this.dup();
            this.visitLdcInsn(parameterEntry);
            this.invokeVirtual(arrayListType, add);
            this.pop();
        }
    }

    @Override
    protected void onMethodExit(int opcode) {
        Type targetType = Type.getObjectType(TRACE_MACHINE_INTERNAL_CLASSNAME);
        this.invokeStatic(targetType, new Method("exitMethod", "()V"));
        if (this.unloadContext.booleanValue()) {
            this.loadThis();
            targetType = Type.getObjectType(TRACE_MACHINE_INTERNAL_CLASSNAME);
            this.invokeStatic(targetType, new Method("unloadTraceContext", "(Ljava/lang/Object;)V"));
        }
    }
}

