/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.visitor;

import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.apm.visitor.ActivityClassAdapter;
import com.mob.mobapm.apm.visitor.TraceClassDecorator;
import com.mob.mobapm.apm.visitor.TraceMethodVisitor;
import com.mob.mobapm.org.objectweb.asm.ClassVisitor;
import com.mob.mobapm.org.objectweb.asm.MethodVisitor;
import com.mob.mobapm.org.objectweb.asm.Type;
import com.mob.mobapm.org.objectweb.asm.commons.GeneratorAdapter;
import com.mob.mobapm.org.objectweb.asm.commons.Method;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class ActivityClassVisitor
extends ActivityClassAdapter {
    static final Type applicationStateMonitorType = Type.getObjectType("com/mob/mobapm/background/ApplicationStateMonitor");
    static final Type gestureObserverType = Type.getObjectType("com/mob/mobapm/gestures/GestureObserver");
    static final ImmutableSet<String> ACTIVITY_CLASSES = ImmutableSet.of((Object)"^(android\\/.*\\/)(.*Activity)", (Object)"^(android\\/app\\/)(ActivityGroup)", (Object)"^(android\\/.*\\/)(.*Activity)([DGH].*)", (Object)"^(androidx\\/.*\\/)(.*Activity)", (Object)"^(androidx\\/)(ActivityCompat)");
    public static final ImmutableMap<String, Integer> methodAccessMap = ImmutableMap.of((Object)"onStart", (Object)4, (Object)"onStop", (Object)4);
    public static final Map<Method, Method> methodDelegateMap = ImmutableMap.of((Object)new Method("onStart", "()V"), (Object)new Method("activityStarted", "()V"), (Object)new Method("onStop", "()V"), (Object)new Method("activityStopped", "()V"));

    public ActivityClassVisitor(ClassVisitor cv, InstrumentationContext context) {
        super(cv, context, (Set<String>)ACTIVITY_CLASSES, methodDelegateMap);
        this.access = 0;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.instrument = this.shouldInstrumentClass(name, superName);
        if (this.instrument) {
            interfaces = TraceClassDecorator.addInterface(interfaces);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    protected void injectCodeIntoMethod(GeneratorAdapter generatorAdapter, Method method, Method monitorMethod) {
        if (method.getName().equalsIgnoreCase("onStart")) {
            generatorAdapter.invokeStatic(applicationStateMonitorType, new Method("getInstance", applicationStateMonitorType, new Type[0]));
            generatorAdapter.invokeVirtual(applicationStateMonitorType, monitorMethod);
        } else if (method.getName().equalsIgnoreCase("onStop")) {
            generatorAdapter.invokeStatic(applicationStateMonitorType, new Method("getInstance", applicationStateMonitorType, new Type[0]));
            generatorAdapter.invokeVirtual(applicationStateMonitorType, monitorMethod);
        } else if (method.getName().equalsIgnoreCase("onBackPressed")) {
            // empty if block
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        if (!this.context.isSkippedMethod(methodName, desc) && this.instrument && traceMethodMap.containsKey((Object)methodName) && ((String)traceMethodMap.get((Object)methodName)).equals(desc)) {
            MethodVisitor methodVisitor = super.visitMethod(access, methodName, desc, signature, exceptions);
            TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, methodName, desc, this.context);
            if (startTracingOn.contains((Object)methodName)) {
                traceMethodVisitor.setStartTracing();
            }
            return traceMethodVisitor;
        }
        return super.visitMethod(access, methodName, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.instrument) {
            TraceClassDecorator decorator = new TraceClassDecorator(this);
            decorator.addTraceField();
            if ((this.access & 0x400) != 0) {
                decorator.addTraceInterface(Type.getObjectType(this.context.getClassName()));
            }
        }
        this.access = 0;
        super.visitEnd();
    }

    @Override
    protected int provideAccessForMethod(String methodName) {
        Integer v = (Integer)methodAccessMap.get((Object)methodName);
        return v != null ? v : 4;
    }
}

