/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.visitor;

import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.org.objectweb.asm.ClassVisitor;
import com.mob.mobapm.org.objectweb.asm.MethodVisitor;
import com.mob.mobapm.org.objectweb.asm.Type;
import com.mob.mobapm.org.objectweb.asm.commons.GeneratorAdapter;
import com.mob.mobapm.org.objectweb.asm.commons.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class ActivityClassAdapter
extends ClassVisitor {
    public static final ImmutableMap<String, String> traceMethodMap = ImmutableMap.of((Object)"onCreate", (Object)"(Landroid/os/Bundle;)V", (Object)"onCreateView", (Object)"(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;");
    public static final ImmutableSet<String> startTracingOn = ImmutableSet.of((Object)"onCreate");
    protected final Map<String, Pattern> baseClassPatterns;
    private final Map<Method, MethodVisitorFactory> methodVisitors;
    protected final InstrumentationContext context;
    protected String superName;
    protected boolean instrument = false;
    protected int access = 0;
    private Pattern androidPackagePattern = Pattern.compile("^android[x]{0,1}/.*");

    public ActivityClassAdapter(ClassVisitor cv, InstrumentationContext context, Set<String> baseClasses, Map<Method, Method> methodMappings) {
        super(327680, cv);
        this.context = context;
        this.methodVisitors = new HashMap<Method, MethodVisitorFactory>();
        for (Map.Entry<Method, Method> entry : methodMappings.entrySet()) {
            this.methodVisitors.put(entry.getKey(), new MethodVisitorFactory(entry.getValue()));
        }
        this.baseClassPatterns = new HashMap<String, Pattern>();
        for (String pattern : baseClasses) {
            this.baseClassPatterns.put(pattern, Pattern.compile(pattern));
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
        this.access = access;
        this.instrument = this.shouldInstrumentClass(name, superName);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.instrument) {
            return mv;
        }
        Method method = new Method(name, desc);
        MethodVisitorFactory v = this.methodVisitors.get(method);
        if (v != null) {
            this.methodVisitors.remove(method);
            return v.createMethodVisitor(access, method, mv, false);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.instrument) {
            super.visitEnd();
            return;
        }
        this.context.markModified();
        for (Map.Entry<Method, MethodVisitorFactory> entry : this.methodVisitors.entrySet()) {
            String className = entry.getKey().getName();
            String classDescr = entry.getKey().getDescriptor();
            int access = this.provideAccessForMethod(className);
            MethodVisitor mv = super.visitMethod(access, className, classDescr, null, null);
            mv = entry.getValue().createMethodVisitor(access, entry.getKey(), mv, true);
            mv.visitCode();
            Type methodReturn = entry.getValue().monitorMethod.getReturnType();
            if (methodReturn == Type.VOID_TYPE) {
                mv.visitInsn(177);
            } else if (methodReturn == Type.BOOLEAN_TYPE) {
                mv.visitInsn(172);
            } else {
                mv.visitInsn(173);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    protected abstract void injectCodeIntoMethod(GeneratorAdapter var1, Method var2, Method var3);

    protected abstract int provideAccessForMethod(String var1);

    protected boolean shouldInstrumentClass(String className, String superName) {
        if (!this.androidPackagePattern.matcher(className.toLowerCase()).matches()) {
            for (Pattern baseClassPattern : this.baseClassPatterns.values()) {
                Matcher matcher = baseClassPattern.matcher(superName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected class MethodVisitorFactory {
        final Method monitorMethod;

        public MethodVisitorFactory(Method monitorMethod) {
            this.monitorMethod = monitorMethod;
        }

        public MethodVisitor createMethodVisitor(int access, final Method method, MethodVisitor mv, final boolean callSuper) {
            return new GeneratorAdapter(327680, mv, access, method.getName(), method.getDescriptor()){

                @Override
                public void visitCode() {
                    super.visitCode();
                    if (callSuper) {
                        this.loadThis();
                        for (int i = 0; i < method.getArgumentTypes().length; ++i) {
                            this.loadArg(i);
                        }
                        this.visitMethodInsn(183, ActivityClassAdapter.this.superName, method.getName(), method.getDescriptor(), false);
                    }
                    ActivityClassAdapter.this.injectCodeIntoMethod(this, method, MethodVisitorFactory.this.monitorMethod);
                }
            };
        }
    }
}

