/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm;

import com.mob.mobapm.apm.InvocationDispatcher;
import com.mob.mobapm.apm.transform.DexClassTransformer;
import com.mob.mobapm.apm.transform.ModifyClassTransformer;
import com.mob.mobapm.apm.transform.NoOpClassTransformer;
import com.mob.mobapm.apm.utils.Log;
import com.mob.mobapm.apm.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MobAgent {
    public static final String VERSION = "1.0.0";
    private static String agentArgs;
    private static Map<String, String> agentOptions;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        MobAgent.agentArgs = agentArgs;
        try {
            agentOptions = MobAgent.parseAgentArgs(agentArgs);
        }
        catch (Throwable t) {
            Log.e(t.toString());
        }
        try {
            ModifyClassTransformer dexClassTransformer;
            if (agentOptions.containsKey("deinstrument")) {
                Log.i("Deinstrumenting...");
                dexClassTransformer = new NoOpClassTransformer();
            } else {
                dexClassTransformer = new DexClassTransformer();
                MobAgent.createInvocationDispatcher();
            }
            instrumentation.addTransformer(dexClassTransformer, true);
            ArrayList<Class> classes = new ArrayList<Class>();
            for (Class clazz : instrumentation.getAllLoadedClasses()) {
                if (!dexClassTransformer.modifies(clazz)) continue;
                classes.add(clazz);
            }
            if (!classes.isEmpty() && instrumentation.isRetransformClassesSupported()) {
                instrumentation.retransformClasses(classes.toArray(new Class[classes.size()]));
            }
            if (!agentOptions.containsKey("deinstrument")) {
                MobAgent.redefineClass(instrumentation, dexClassTransformer, ProcessBuilder.class);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getAgentJarPath() throws URISyntaxException {
        return new File(MobAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
    }

    public static String getProxyInvocationKey(String className, String methodName) {
        return className + "." + methodName;
    }

    private static void redefineClass(Instrumentation instrumentation, ClassFileTransformer classTransformer, Class<?> klass) throws IOException, IllegalClassFormatException, ClassNotFoundException, UnmodifiableClassException {
        String internalClassName = klass.getName().replace('.', '/');
        String classPath = internalClassName + ".class";
        ClassLoader cl = klass.getClassLoader() == null ? MobAgent.class.getClassLoader() : klass.getClassLoader();
        InputStream stream = cl.getResourceAsStream(classPath);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.copy(stream, output);
        stream.close();
        byte[] newBytes = classTransformer.transform(klass.getClassLoader(), internalClassName, klass, null, output.toByteArray());
        ClassDefinition def = new ClassDefinition(klass, newBytes);
        instrumentation.redefineClasses(def);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        MobAgent.premain(agentArgs, instrumentation);
    }

    public static String getAgentArgs() {
        return agentArgs;
    }

    public static Object getVersion() {
        return VERSION;
    }

    public static Map<String, String> parseAgentArgs(String agentArgs) {
        if (agentArgs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (String arg : agentArgs.split(";")) {
            String[] keyValue = arg.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Invalid argument: " + arg);
            }
            options.put(keyValue[0], keyValue[1]);
        }
        return options;
    }

    private static void createInvocationDispatcher() throws Exception {
        Field field = InvocationDispatcher.INVOCATION_DISPATCHER_CLASS.getDeclaredField("treeLock");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        if (!(field.get(null) instanceof InvocationDispatcher)) {
            field.set(null, new InvocationDispatcher());
        }
    }

    static {
        agentOptions = Collections.emptyMap();
    }
}

