/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm;

import com.mob.mobapm.apm.ClassData;
import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.apm.MobAgent;
import com.mob.mobapm.apm.utils.Log;
import com.mob.mobapm.apm.visitor.ActivityClassVisitor;
import com.mob.mobapm.apm.visitor.AnnotatingClassVisitor;
import com.mob.mobapm.apm.visitor.AsyncTaskClassVisitor;
import com.mob.mobapm.apm.visitor.ContextInitializationClassVisitor;
import com.mob.mobapm.apm.visitor.FragmentClassVisitor;
import com.mob.mobapm.apm.visitor.MobClassVisitor;
import com.mob.mobapm.apm.visitor.PrefilterClassVisitor;
import com.mob.mobapm.apm.visitor.TraceAnnotationClassVisitor;
import com.mob.mobapm.apm.visitor.WrapMethodClassVisitor;
import com.mob.mobapm.org.objectweb.asm.ClassReader;
import com.mob.mobapm.org.objectweb.asm.ClassWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class InvocationDispatcher
implements InvocationHandler {
    public static final Class INVOCATION_DISPATCHER_CLASS = Logger.class;
    public static final Set<String> DX_COMMAND_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dx", "dx.bat")));
    public static final Set<String> JAVA_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java", "java.exe")));
    private static final Set<String> AGENT_JAR_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("obfuscated.jar")));
    public static final HashSet<String> EXCLUDED_PACKAGES = new HashSet<String>(){
        {
            this.add("com/mob/mobapm");
        }
    };
    public static final HashSet<String> INCLUDED_PACKAGES = new HashSet<String>(){
        {
            this.add("androidx/appcompat/app/AppCompatActivity");
            this.add("androidx/core/app/ActivityCompat");
            this.add("androidx/fragment/app/");
            this.add("androidx/fragment/app/Fragment");
            this.add("androidx/fragment/app/FragmentActivity");
            this.add("androidx/leanback/app/Fragment");
            this.add("androidx/legacy/app/ActivityCompat");
            this.add("androidx/legacy/app/FragmentCompat");
            this.add("androidx/preference/Fragment");
            this.add("androidx/sqlite/");
            this.add("org.json");
        }
    };
    private final InstrumentationContext context;
    private final Map<String, InvocationHandler> invocationHandlers;
    private boolean writeDisabledMessage = true;
    private final String agentJarPath;
    private boolean disableInstrumentation = false;
    private Pattern androidPackagePattern = Pattern.compile("^android[x]{0,1}/.*");
    private Pattern kotlinPackagePattern = Pattern.compile("^kotlin[x]{0,1}/.*");

    public InvocationDispatcher() throws IOException, ClassNotFoundException, URISyntaxException {
        this.context = new InstrumentationContext();
        this.agentJarPath = MobAgent.getAgentJarPath();
        this.invocationHandlers = Collections.unmodifiableMap(new HashMap<String, InvocationHandler>(){
            {
                this.put(MobAgent.getProxyInvocationKey("com/android/dx/command/dexer/Main", "processClass"), new InvocationHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        byte[] bytes = (byte[])args[1];
                        Log.e("ssss dexerMain.proceeClass");
                        if (!InvocationDispatcher.this.isInstrumentationDisabled()) {
                            boolean unused = InvocationDispatcher.this.writeDisabledMessage = true;
                            InstrumentationContext instrumentationContext = InvocationDispatcher.this.context;
                            synchronized (instrumentationContext) {
                                ClassData classData = InvocationDispatcher.this.visitClassBytes(bytes);
                                if (classData != null && classData.getMainClassBytes() != null && classData.isModified()) {
                                    bytes = classData.getMainClassBytes();
                                }
                            }
                        } else if (InvocationDispatcher.this.writeDisabledMessage) {
                            boolean bl = InvocationDispatcher.this.writeDisabledMessage = false;
                        }
                        return bytes;
                    }
                });
                this.put(MobAgent.getProxyInvocationKey("com/android/ant/DexExecTask", "preDexLibraries"), new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        List files = (List)args[0];
                        for (File file : files) {
                            if (!AGENT_JAR_NAMES.contains(file.getName().toLowerCase())) continue;
                            return file;
                        }
                        return null;
                    }
                });
                this.put("SET_INSTRUMENTATION_DISABLED_FLAG", new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        boolean z = false;
                        InvocationDispatcher invocationDispatcher = InvocationDispatcher.this;
                        if (args != null && args[0] == null) {
                            z = true;
                        }
                        boolean unused = invocationDispatcher.disableInstrumentation = z;
                        return null;
                    }
                });
                this.put(MobAgent.getProxyInvocationKey("java/lang/ProcessBuilder", "start"), new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        Log.e("ssss processbuilder start");
                        List list = (List)args[0];
                        File commandFile = new File((String)list.get(0));
                        if (InvocationDispatcher.this.isInstrumentationDisabled()) {
                            Log.e("ssss isInstrumentationDisabled");
                        } else {
                            String javaagentString = null;
                            if (DX_COMMAND_NAMES.contains(commandFile.getName().toLowerCase())) {
                                javaagentString = "-Jjavaagent:" + InvocationDispatcher.this.agentJarPath;
                            } else if (JAVA_NAMES.contains(commandFile.getName().toLowerCase())) {
                                javaagentString = "-javaagent:" + InvocationDispatcher.this.agentJarPath;
                            }
                            if (javaagentString != null) {
                                String agentArgs = MobAgent.getAgentArgs();
                                if (agentArgs != null) {
                                    javaagentString = javaagentString + "=" + agentArgs;
                                }
                                Log.e("ssss " + javaagentString);
                                list.add(1, this.quoteProperty(javaagentString));
                            }
                        }
                        return null;
                    }

                    private String quoteProperty(String string) {
                        if (System.getProperty("os.name").toLowerCase().contains("win")) {
                            return "\"" + string + "\"";
                        }
                        return string;
                    }
                });
                this.put(MobAgent.getProxyInvocationKey("com/mob/mobapm/apm/ClassTransformer", "transformClassBytes"), new InvocationHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        String filename = (String)args[0];
                        byte[] bytes = (byte[])args[1];
                        if (!InvocationDispatcher.this.isInstrumentationDisabled()) {
                            boolean unused = InvocationDispatcher.this.writeDisabledMessage = true;
                            InstrumentationContext instrumentationContext = InvocationDispatcher.this.context;
                            synchronized (instrumentationContext) {
                                ClassData classData = InvocationDispatcher.this.visitClassBytes(bytes);
                                if (!InvocationDispatcher.this.context.isClassModified() || classData == null || classData.getMainClassBytes() == null) {
                                    return null;
                                }
                                if (bytes.length != classData.getMainClassBytes().length) {
                                    // empty if block
                                }
                                byte[] bytes2 = classData.getMainClassBytes();
                                return bytes2;
                            }
                        }
                        if (!InvocationDispatcher.this.writeDisabledMessage) {
                            return bytes;
                        }
                        boolean unused2 = InvocationDispatcher.this.writeDisabledMessage = false;
                        return bytes;
                    }
                });
            }
        });
    }

    private boolean isInstrumentationDisabled() {
        return this.disableInstrumentation || System.getProperty("mob.instrumentation.disabled") != null;
    }

    private boolean isIncludedPackage(String packageName) {
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : INCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedPackage(String packageName) {
        if (this.isIncludedPackage(packageName)) {
            return false;
        }
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : EXCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    boolean isKotlinSDKPackage(String className) {
        return this.kotlinPackagePattern.matcher(className.toLowerCase()).matches();
    }

    boolean isAndroidSDKPackage(String className) {
        return this.androidPackagePattern.matcher(className.toLowerCase()).matches() || this.isKotlinSDKPackage(className);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Log.e("ssss invoke" + proxy);
        InvocationHandler handler = this.invocationHandlers.get(proxy);
        if (handler == null) {
            return null;
        }
        try {
            return handler.invoke(proxy, method, args);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ClassData visitClassBytes(byte[] bytes) {
        return this.visitClassBytesWithOptions(bytes, 2);
    }

    private ClassData visitClassBytesWithOptions(byte[] bytes, int classWriterFlags) {
        String className = "an unknown class";
        try {
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(cr, classWriterFlags);
            this.context.reset();
            cr.accept(new PrefilterClassVisitor(this.context), 7);
            className = this.context.getClassName();
            if (!this.context.hasTag("Lcom/mob/mobapm/instrumentation/MobInstrumented;")) {
                MobClassVisitor mobClassVisitor = null;
                WrapMethodClassVisitor wrapMethodClassVisitor = null;
                ClassWriter classWriter = cw;
                if (className.startsWith("com/mob/mobapm")) {
                    mobClassVisitor = new MobClassVisitor(classWriter, this.context);
                } else {
                    ActivityClassVisitor activityClassVisitor = null;
                    if (this.isAndroidSDKPackage(className)) {
                        activityClassVisitor = new ActivityClassVisitor(mobClassVisitor, this.context);
                    } else {
                        if (this.isExcludedPackage(className)) {
                            return null;
                        }
                        AnnotatingClassVisitor annotatingClassVisitor = new AnnotatingClassVisitor(activityClassVisitor, this.context);
                        FragmentClassVisitor fragmentClassVisitor = new FragmentClassVisitor(annotatingClassVisitor, this.context);
                        ActivityClassVisitor activityClassVisitor1 = new ActivityClassVisitor(fragmentClassVisitor, this.context);
                        AsyncTaskClassVisitor asyncTaskClassVisitor = new AsyncTaskClassVisitor(activityClassVisitor1, this.context);
                        TraceAnnotationClassVisitor traceAnnotationClassVisitor = new TraceAnnotationClassVisitor(asyncTaskClassVisitor, this.context);
                        wrapMethodClassVisitor = new WrapMethodClassVisitor(traceAnnotationClassVisitor, this.context);
                    }
                }
                ContextInitializationClassVisitor contextInitializationClassVisitor = new ContextInitializationClassVisitor(wrapMethodClassVisitor, this.context);
                try {
                    cr.accept(contextInitializationClassVisitor, 12);
                }
                catch (Exception e) {
                    if (classWriterFlags != 1) {
                        return this.visitClassBytesWithOptions(bytes, 1);
                    }
                    return new ClassData(bytes, false);
                }
                if (!this.context.isClassModified() || bytes.length != cw.toByteArray().length) {
                    // empty if block
                }
            }
            return this.context.newClassData(cw.toByteArray());
        }
        catch (Throwable e) {
            Log.e(e.getMessage() + e);
            return new ClassData(bytes, false);
        }
    }
}

