/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;

public class LocationHelper {
    private Handler handler = MobHandlerThread.newHandler("h", this.newCallback());
    private Location res;
    private int gpsTimeoutSec;
    private int networkTimeoutSec;
    private LocationManager lm;
    private boolean gpsRequesting;
    private boolean networkRequesting;
    private DeviceHelper deviceHelper;
    private LocationListener listener;

    public LocationHelper() {
        this.newLocationListener();
    }

    private Handler.Callback newCallback() {
        return new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                try {
                    if (LocationHelper.this.deviceHelper.checkPermission("android.permission.ACCESS_FINE_LOCATION")) {
                        if (msg.what == 0) {
                            LocationHelper.this.onRequest();
                        } else if (LocationHelper.this.gpsRequesting) {
                            LocationHelper.this.onGPSTimeout();
                        } else if (LocationHelper.this.networkRequesting) {
                            if (LocationHelper.this.lm != null) {
                                LocationHelper.this.lm.removeUpdates(LocationHelper.this.listener);
                            }
                            LocationHelper.this.quit();
                        }
                    } else {
                        LocationHelper.this.quit();
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                    LocationHelper.this.quit();
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit() {
        try {
            LocationHelper locationHelper = this;
            synchronized (locationHelper) {
                this.notifyAll();
            }
            this.handler.getLooper().quit();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    private void newLocationListener() {
        this.listener = new LocationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLocationChanged(Location location) {
                try {
                    LocationHelper locationHelper = LocationHelper.this;
                    synchronized (locationHelper) {
                        try {
                            LocationHelper.this.lm.removeUpdates((LocationListener)this);
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().d(t);
                        }
                        LocationHelper.this.res = location;
                        LocationHelper.this.notifyAll();
                    }
                    LocationHelper.this.handler.getLooper().quit();
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
    }

    public Location getLocation(Context context) throws Throwable {
        return this.getLocation(context, 0);
    }

    public Location getLocation(Context context, int GPSTimeoutSec) throws Throwable {
        return this.getLocation(context, GPSTimeoutSec, 0);
    }

    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec) throws Throwable {
        return this.getLocation(context, GPSTimeoutSec, networkTimeoutSec, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec, boolean useLastKnown) throws Throwable {
        this.deviceHelper = DeviceHelper.getInstance(context);
        this.gpsTimeoutSec = GPSTimeoutSec;
        this.networkTimeoutSec = networkTimeoutSec;
        this.lm = (LocationManager)this.deviceHelper.getSystemServiceSafe("location");
        if (this.lm == null) {
            return null;
        }
        LocationHelper locationHelper = this;
        synchronized (locationHelper) {
            this.handler.sendEmptyMessageDelayed(0, 50L);
            this.wait();
        }
        if (this.res == null && useLastKnown) {
            this.res = this.lm.getLastKnownLocation("gps");
            if (this.res == null) {
                this.res = this.lm.getLastKnownLocation("network");
            }
        }
        return this.res;
    }

    private void onRequest() {
        boolean preferNetwork;
        boolean preferGPS = this.gpsTimeoutSec != 0;
        boolean bl = preferNetwork = this.networkTimeoutSec != 0;
        if (this.lm != null) {
            if (preferGPS && this.lm.isProviderEnabled("gps")) {
                this.gpsRequesting = true;
                try {
                    this.lm.requestLocationUpdates("gps", 1000L, 0.0f, this.listener);
                    if (this.gpsTimeoutSec > 0) {
                        this.handler.sendEmptyMessageDelayed(1, (long)(this.gpsTimeoutSec * 1000));
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                    this.handler.sendEmptyMessage(1);
                }
                return;
            }
            if (preferNetwork && this.lm.isProviderEnabled("network")) {
                this.networkRequesting = true;
                try {
                    this.lm.requestLocationUpdates("network", 1000L, 0.0f, this.listener);
                    if (this.networkTimeoutSec > 0) {
                        this.handler.sendEmptyMessageDelayed(1, (long)(this.networkTimeoutSec * 1000));
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                    this.handler.sendEmptyMessage(1);
                }
                return;
            }
        }
        this.quit();
    }

    private void onGPSTimeout() {
        boolean preferNetwork;
        this.lm.removeUpdates(this.listener);
        this.gpsRequesting = false;
        boolean bl = preferNetwork = this.networkTimeoutSec != 0;
        if (preferNetwork && this.lm.isProviderEnabled("network")) {
            this.networkRequesting = true;
            this.lm.requestLocationUpdates("network", 1000L, 0.0f, this.listener);
            if (this.networkTimeoutSec > 0) {
                this.handler.sendEmptyMessageDelayed(1, (long)(this.networkTimeoutSec * 1000));
            }
        } else {
            this.quit();
        }
    }
}

