/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;

@SuppressLint(value={"MissingPermission"})
public class LHelper {
    private static final int CACHE_LIFE_CYCLE = 5000;
    private static final int START_LOCATING = 0;
    private static final int CANCEL_GPS_LOCATING = 1;
    private static final int CANCEL_NETWORK_LOCATING = 2;
    private static LHelper instance;
    private Handler handler = MobHandlerThread.newHandler("T-lct", new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 0: {
                        LHelper.this.onRequest();
                        break;
                    }
                    case 1: {
                        LHelper.this.onGPSTimeout();
                        break;
                    }
                    case 2: {
                        LHelper.this.onNetworkTimeout();
                    }
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                LHelper.this.finished();
            }
            return false;
        }
    });
    private Location cache;
    private int gpsTimeoutSec;
    private int networkTimeoutSec;
    private LocationManager lm;
    private LocationListener listener = new LocationListener(){

        public void onLocationChanged(Location location) {
            try {
                LHelper.this.lm.removeUpdates((LocationListener)this);
                LHelper.this.cache = location;
                LHelper.this.requestAt = System.currentTimeMillis();
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
            finally {
                LHelper.this.finished();
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };
    private long requestAt;

    private LHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LHelper getInstance() {
        if (instance != null) return instance;
        Class<LHelper> clazz = LHelper.class;
        synchronized (LHelper.class) {
            if (instance != null) return instance;
            instance = new LHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Location getLocation(Context context) {
        return this.getLocation(context, 0);
    }

    public Location getLocation(Context context, int GPSTimeoutSec) {
        return this.getLocation(context, GPSTimeoutSec, 0);
    }

    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec) {
        return this.getLocation(context, GPSTimeoutSec, networkTimeoutSec, true);
    }

    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec, boolean useLastKnown) {
        return this.getLocation(context, GPSTimeoutSec, networkTimeoutSec, useLastKnown, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Location getLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec, boolean useLastKnown, boolean forceReObtain) {
        Location location = this.quickResponse(forceReObtain);
        if (location != null) return location;
        Class<LHelper> clazz = LHelper.class;
        synchronized (LHelper.class) {
            location = this.quickResponse(forceReObtain);
            if (location != null) return location;
            return this.requestLocation(context, GPSTimeoutSec, networkTimeoutSec, useLastKnown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location requestLocation(Context context, int GPSTimeoutSec, int networkTimeoutSec, boolean useLastKnown) {
        Location location;
        block8: {
            location = null;
            try {
                DeviceHelper device = DeviceHelper.getInstance(context);
                boolean granted = device.checkPermission("android.permission.ACCESS_FINE_LOCATION");
                if (!granted) break block8;
                this.gpsTimeoutSec = GPSTimeoutSec;
                this.networkTimeoutSec = networkTimeoutSec;
                if (this.lm == null) {
                    this.lm = (LocationManager)device.getSystemServiceSafe("location");
                }
                if (this.lm == null) {
                    return null;
                }
                LHelper lHelper = this;
                synchronized (lHelper) {
                    this.handler.sendEmptyMessageDelayed(0, 50L);
                    this.wait();
                }
                if (this.cache == null && useLastKnown) {
                    this.cache = this.onRequestLastKnown();
                    this.requestAt = System.currentTimeMillis();
                }
                location = this.cache;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().d(throwable);
            }
        }
        return location;
    }

    private Location quickResponse(boolean forceReObtain) {
        Location location = null;
        if (!forceReObtain && this.cache != null && System.currentTimeMillis() - this.requestAt <= 5000L) {
            location = this.cache;
        }
        return location;
    }

    private void onRequest() {
        boolean preferNetwork;
        boolean preferGPS = this.gpsTimeoutSec != 0;
        boolean bl = preferNetwork = this.networkTimeoutSec != 0;
        if (this.lm != null) {
            if (preferGPS && this.lm.isProviderEnabled("gps")) {
                this.onRequestGps();
            } else if (preferNetwork && this.lm.isProviderEnabled("network")) {
                this.onRequestNetwork();
            } else {
                this.finished();
            }
        } else {
            this.finished();
        }
    }

    private void onRequestGps() {
        try {
            this.lm.requestLocationUpdates("gps", 1000L, 0.0f, this.listener);
            if (this.gpsTimeoutSec > 0) {
                this.handler.sendEmptyMessageDelayed(1, (long)(this.gpsTimeoutSec * 1000));
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            this.handler.sendEmptyMessage(1);
        }
    }

    private void onRequestNetwork() {
        try {
            this.lm.requestLocationUpdates("network", 1000L, 0.0f, this.listener);
            if (this.networkTimeoutSec > 0) {
                this.handler.sendEmptyMessageDelayed(2, (long)(this.networkTimeoutSec * 1000));
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            this.handler.sendEmptyMessage(2);
        }
    }

    private Location onRequestLastKnown() {
        Location location = null;
        try {
            location = this.lm.getLastKnownLocation("gps");
            if (location == null) {
                location = this.lm.getLastKnownLocation("network");
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return location;
    }

    private void onGPSTimeout() {
        if (this.lm != null) {
            boolean preferNetwork;
            this.lm.removeUpdates(this.listener);
            boolean bl = preferNetwork = this.networkTimeoutSec != 0;
            if (preferNetwork && this.lm.isProviderEnabled("network")) {
                this.onRequestNetwork();
            } else {
                this.finished();
            }
        }
    }

    private void onNetworkTimeout() {
        if (this.lm != null) {
            this.lm.removeUpdates(this.listener);
        }
        this.finished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished() {
        try {
            LHelper lHelper = this;
            synchronized (lHelper) {
                this.notifyAll();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }
}

