/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.opengl.GLES10;
import android.text.TextUtils;
import android.view.View;
import com.mob.tools.MobLog;
import com.mob.tools.network.HttpConnection;
import com.mob.tools.network.HttpResponseCallback;
import com.mob.tools.network.NetworkHelper;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.FileUtils;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.ResHelper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitmapHelper {
    private static final int DEFAULT_MAX_BITMAP_DIMENSION = 2048;
    private static int maxBitmapWidth;
    private static int maxBitmapHeight;

    public static Bitmap getBitmapByCompressSize(String path, int desiredWidth, int desiredHeight) throws Throwable {
        BitmapFactory.Options measureOptions = new BitmapFactory.Options();
        measureOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)measureOptions);
        int realWidth = measureOptions.outWidth;
        int realHeight = measureOptions.outHeight;
        int inSampleSize = 1;
        if (desiredWidth > 1 && desiredHeight > 1) {
            float minSideScale = 1.0f * (float)Math.min(realWidth, realHeight) / (float)Math.min(desiredWidth, desiredHeight);
            float maxSideScale = 1.0f * (float)Math.max(realWidth, realHeight) / (float)Math.max(desiredWidth, desiredHeight);
            float ratio = realWidth / realHeight;
            if (ratio > 2.0f || (double)ratio < 0.5) {
                float n = 1.0f;
                while (n * 2.0f <= minSideScale) {
                    n *= 2.0f;
                }
                inSampleSize = (int)n;
            } else {
                float minScale = Math.min(minSideScale, maxSideScale);
                float n = 1.0f;
                while (n * 2.0f <= minScale) {
                    n *= 2.0f;
                }
                inSampleSize = (int)n;
            }
        }
        if (inSampleSize < 1) {
            inSampleSize = 1;
        }
        while (realWidth / inSampleSize > maxBitmapWidth || realHeight / inSampleSize > maxBitmapHeight) {
            ++inSampleSize;
        }
        BitmapFactory.Options decodingOptions = new BitmapFactory.Options();
        decodingOptions.inPreferredConfig = Bitmap.Config.RGB_565;
        decodingOptions.inSampleSize = inSampleSize;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)decodingOptions);
    }

    public static Bitmap getBitmapByCompressQuality(String path, int desiredWidth, int desiredHeight, int quality, long maxBytes) throws Throwable {
        Bitmap compressedSizeBitmap = BitmapHelper.getBitmapByCompressSize(path, desiredWidth, desiredHeight);
        if (quality < 10 || quality > 100) {
            quality = 100;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Bitmap.CompressFormat format = BitmapHelper.getBmpFormat(path);
        compressedSizeBitmap.compress(format, quality, (OutputStream)baos);
        byte[] compressedBytes = baos.toByteArray();
        if (maxBytes < 10240L) {
            Bitmap qualityBitmap = BitmapFactory.decodeByteArray((byte[])compressedBytes, (int)0, (int)compressedBytes.length);
            try {
                baos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return qualityBitmap;
        }
        while ((long)compressedBytes.length > maxBytes && quality >= 11) {
            baos.reset();
            compressedSizeBitmap.compress(format, quality -= 6, (OutputStream)baos);
            compressedBytes = baos.toByteArray();
        }
        Bitmap newBitmap = quality == 100 ? compressedSizeBitmap : BitmapFactory.decodeByteArray((byte[])compressedBytes, (int)0, (int)compressedBytes.length);
        if (baos != null) {
            try {
                baos.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return newBitmap;
    }

    public static String saveBitmapByCompress(String path, int desiredWidth, int desiredHeight, int quality) throws Throwable {
        Bitmap compressedSizeBitmap = BitmapHelper.getBitmapByCompressSize(path, desiredWidth, desiredHeight);
        if (quality > 100) {
            quality = 100;
        } else if (quality < 10) {
            quality = 10;
        }
        Bitmap.CompressFormat format = BitmapHelper.getBmpFormat(path);
        String extension = ".jpg";
        if (format == Bitmap.CompressFormat.PNG) {
            extension = ".png";
        }
        File newFile = new File(new File(path).getParent(), String.valueOf(System.currentTimeMillis()) + extension);
        FileOutputStream fos = new FileOutputStream(newFile);
        compressedSizeBitmap.compress(format, quality, (OutputStream)fos);
        fos.flush();
        fos.close();
        return newFile.getAbsolutePath();
    }

    public static Bitmap getBitmap(String path, int inSampleSize) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return BitmapHelper.getBitmap(new File(path), inSampleSize);
    }

    public static Bitmap getBitmap(File file, int inSampleSize) throws Throwable {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        Bitmap bm = BitmapHelper.getBitmap(fis, inSampleSize);
        fis.close();
        return bm;
    }

    public static Bitmap getBitmap(InputStream is, int inSampleSize) {
        if (is == null) {
            return null;
        }
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inPreferredConfig = Bitmap.Config.ARGB_8888;
        opt.inPurgeable = true;
        opt.inInputShareable = true;
        opt.inSampleSize = inSampleSize;
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opt);
    }

    public static Bitmap getBitmap(String path) throws Throwable {
        return BitmapHelper.getBitmap(path, 1);
    }

    public static Bitmap getBitmap(Context context, String url) throws Throwable {
        String path = BitmapHelper.downloadBitmap(context, url);
        return BitmapHelper.getBitmap(path);
    }

    public static String downloadBitmap(Context context, final String imageUrl) throws Throwable {
        String name;
        final String path = ResHelper.getCachePath(context, "images");
        File cache = new File(path, name = Data.MD5(imageUrl));
        if (cache.exists()) {
            return cache.getAbsolutePath();
        }
        final HashMap buffer = new HashMap();
        NetworkHelper helper = new NetworkHelper();
        helper.rawGet(imageUrl, new HttpResponseCallback(){

            @Override
            public void onResponse(HttpConnection conn) throws Throwable {
                int status = conn.getResponseCode();
                if (status == 200) {
                    String name = BitmapHelper.getFileName(conn, imageUrl);
                    File cache = new File(path, name);
                    if (cache.exists()) {
                        buffer.put("bitmap", cache.getAbsolutePath());
                    } else {
                        if (!cache.getParentFile().exists()) {
                            cache.getParentFile().mkdirs();
                        }
                        if (cache.exists()) {
                            cache.delete();
                        }
                        Bitmap bitmap = null;
                        try {
                            FilterInputStream fis = new FilterInputStream(conn.getInputStream()){

                                @Override
                                public long skip(long n) throws IOException {
                                    long m;
                                    long mm;
                                    for (m = 0L; m < n && (mm = this.in.skip(n - m)) != 0L; m += mm) {
                                    }
                                    return m;
                                }
                            };
                            bitmap = BitmapHelper.getBitmap(fis, 1);
                        }
                        catch (Throwable t) {
                            if (cache.exists()) {
                                cache.delete();
                            }
                            throw t;
                        }
                        if (bitmap != null && !bitmap.isRecycled()) {
                            FileOutputStream fos = new FileOutputStream(cache);
                            if (name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png")) {
                                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                            } else {
                                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fos);
                            }
                            fos.flush();
                            fos.close();
                            buffer.put("bitmap", cache.getAbsolutePath());
                        }
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
                    BufferedReader br = new BufferedReader(isr);
                    String txt = br.readLine();
                    while (txt != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(txt);
                        txt = br.readLine();
                    }
                    br.close();
                    HashMap<String, Object> errMap = new HashMap<String, Object>();
                    errMap.put("error", sb.toString());
                    errMap.put("status", status);
                    throw new Throwable(new Hashon().fromHashMap(errMap));
                }
            }
        }, null);
        return (String)buffer.get("bitmap");
    }

    private static String getFileName(HttpConnection conn, String url) throws Throwable {
        String value;
        List<String> headers;
        String name = null;
        Map<String, List<String>> map = conn.getHeaderFields();
        if (map != null && (headers = map.get("Content-Disposition")) != null && headers.size() > 0) {
            String[] parts;
            value = headers.get(0);
            for (String part : parts = value.split(";")) {
                if (!part.trim().startsWith("filename") || !(name = part.split("=")[1]).startsWith("\"") || !name.endsWith("\"")) continue;
                name = name.substring(1, name.length() - 1);
            }
        }
        if (name == null) {
            name = Data.MD5(url);
            if (map != null && (headers = map.get("Content-Type")) != null && headers.size() > 0) {
                value = headers.get(0);
                String string = value = value == null ? "" : value.trim();
                if (value.startsWith("image/")) {
                    String type = value.substring("image/".length());
                    name = name + "." + ("jpeg".equals(type) ? "jpg" : type);
                } else {
                    int dot;
                    int index = url.lastIndexOf(47);
                    String lastPart = null;
                    if (index > 0) {
                        lastPart = url.substring(index + 1);
                    }
                    if (lastPart != null && lastPart.length() > 0 && (dot = lastPart.lastIndexOf(46)) > 0 && lastPart.length() - dot < 10) {
                        name = name + lastPart.substring(dot);
                    }
                }
            }
        }
        return name;
    }

    public static String saveViewToImage(View view) throws Throwable {
        if (view == null) {
            return null;
        }
        int width = view.getWidth();
        int height = view.getHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        return BitmapHelper.saveViewToImage(view, width, height);
    }

    public static String saveViewToImage(View view, int width, int height) throws Throwable {
        Bitmap bm = BitmapHelper.captureView(view, width, height);
        if (bm == null || bm.isRecycled()) {
            return null;
        }
        String path = ResHelper.getCachePath(view.getContext(), "screenshot");
        File ss = new File(path, String.valueOf(System.currentTimeMillis()) + ".jpg");
        FileOutputStream fos = new FileOutputStream(ss);
        bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
        fos.flush();
        fos.close();
        return ss.getAbsolutePath();
    }

    public static Bitmap captureView(View view, int width, int height) throws Throwable {
        Bitmap bm = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        view.draw(new Canvas(bm));
        return bm;
    }

    public static Bitmap blur(Bitmap bm, int radius, int scale) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        int scaledRadius = (int)((float)radius / (float)scale + 0.5f);
        int scaledWidth = (int)((float)width / (float)scale + 0.5f);
        int scaledHeight = (int)((float)height / (float)scale + 0.5f);
        Bitmap overlay = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(overlay);
        canvas.scale(1.0f / (float)scale, 1.0f / (float)scale);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(bm, 0.0f, 0.0f, paint);
        BitmapHelper.blur(overlay, scaledRadius, true);
        return overlay;
    }

    private static Bitmap blur(Bitmap sentBitmap, int radius, boolean canReuseInBitmap) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        Bitmap bitmap = canReuseInBitmap ? sentBitmap : sentBitmap.copy(sentBitmap.getConfig(), true);
        if (radius < 1) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pix = new int[w * h];
        bitmap.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        bitmap.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap;
    }

    public static Bitmap roundBitmap(Bitmap orginal, int width, int height, float leftTop, float rightTop, float rightBottom, float leftBottom) throws Throwable {
        int oriWidth = orginal.getWidth();
        int oriHeight = orginal.getHeight();
        Rect src = new Rect(0, 0, oriWidth, oriHeight);
        Bitmap output = oriWidth != width || oriHeight != height ? Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)orginal.getWidth(), (int)orginal.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect dst = new Rect(0, 0, width, height);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        float[] outerRadii = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
        RectF inset = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        RoundRectShape shape = new RoundRectShape(outerRadii, inset, outerRadii);
        ShapeDrawable draweable = new ShapeDrawable((Shape)shape);
        draweable.setBounds(dst);
        draweable.draw(canvas);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(orginal, src, dst, paint);
        return output;
    }

    public static int[] fixRect(int[] src, int[] target) {
        int[] dst = new int[2];
        float rs = (float)src[0] / (float)src[1];
        float rt = (float)target[0] / (float)target[1];
        if (rs > rt) {
            dst[0] = target[0];
            dst[1] = (int)((float)src[1] * (float)target[0] / (float)src[0] + 0.5f);
        } else {
            dst[1] = target[1];
            dst[0] = (int)((float)src[0] * (float)target[1] / (float)src[1] + 0.5f);
        }
        return dst;
    }

    public static int[] fixRect_2(int[] src, int[] target) {
        int[] dst = new int[2];
        float rs = (float)src[0] / (float)src[1];
        float rt = (float)target[0] / (float)target[1];
        if (rs > rt) {
            dst[1] = target[1];
            dst[0] = (int)((float)src[0] * (float)target[1] / (float)src[1] + 0.5f);
        } else {
            dst[0] = target[0];
            dst[1] = (int)((float)src[1] * (float)target[0] / (float)src[0] + 0.5f);
        }
        return dst;
    }

    public static String saveBitmap(Context context, Bitmap bm, Bitmap.CompressFormat format, int quality) throws Throwable {
        String path = ResHelper.getCachePath(context, "images");
        String ext = ".jpg";
        if (format == Bitmap.CompressFormat.PNG) {
            ext = ".png";
        }
        File ss = new File(path, String.valueOf(System.currentTimeMillis()) + ext);
        FileOutputStream fos = new FileOutputStream(ss);
        bm.compress(format, quality, (OutputStream)fos);
        fos.flush();
        fos.close();
        return ss.getAbsolutePath();
    }

    public static String saveBitmap(Context context, Bitmap bm) throws Throwable {
        return BitmapHelper.saveBitmap(context, bm, Bitmap.CompressFormat.JPEG, 80);
    }

    public static Bitmap.CompressFormat getBmpFormat(byte[] data) {
        String mime = BitmapHelper.getMime(data);
        Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
        if (mime != null && (mime.endsWith("png") || mime.endsWith("gif"))) {
            format = Bitmap.CompressFormat.PNG;
        }
        return format;
    }

    public static Bitmap.CompressFormat getBmpFormat(String filePath) {
        String mime;
        String pathLower = filePath.toLowerCase();
        Bitmap.CompressFormat format = pathLower.endsWith("png") || pathLower.endsWith("gif") ? Bitmap.CompressFormat.PNG : (pathLower.endsWith("jpg") || pathLower.endsWith("jpeg") || pathLower.endsWith("bmp") || pathLower.endsWith("tif") ? Bitmap.CompressFormat.JPEG : ((mime = BitmapHelper.getMime(filePath)).endsWith("png") || mime.endsWith("gif") ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG));
        return format;
    }

    public static String getMime(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] bytes = new byte[8];
            fis.read(bytes);
            fis.close();
            return BitmapHelper.getMime(bytes);
        }
        catch (Exception e) {
            MobLog.getInstance().w(e);
            return "";
        }
    }

    private static String getMime(byte[] bytes) {
        byte[] jpeg = new byte[]{-1, -40, -1, -32};
        byte[] jpeg2 = new byte[]{-1, -40, -1, -31};
        if (BitmapHelper.bytesStartWith(bytes, jpeg) || BitmapHelper.bytesStartWith(bytes, jpeg2)) {
            return "jpg";
        }
        byte[] png = new byte[]{-119, 80, 78, 71};
        if (BitmapHelper.bytesStartWith(bytes, png)) {
            return "png";
        }
        byte[] gif = "GIF".getBytes();
        if (BitmapHelper.bytesStartWith(bytes, gif)) {
            return "gif";
        }
        byte[] bmp = "BM".getBytes();
        if (BitmapHelper.bytesStartWith(bytes, bmp)) {
            return "bmp";
        }
        byte[] tiff = new byte[]{73, 73, 42};
        byte[] tiff2 = new byte[]{77, 77, 42};
        if (BitmapHelper.bytesStartWith(bytes, tiff) || BitmapHelper.bytesStartWith(bytes, tiff2)) {
            return "tif";
        }
        return "";
    }

    private static boolean bytesStartWith(byte[] target, byte[] prefix) {
        if (target == prefix) {
            return true;
        }
        if (target == null || prefix == null) {
            return false;
        }
        if (target.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (target[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static Bitmap cropBitmap(Bitmap orginal, int left, int top, int right, int bottom) throws Throwable {
        int width = orginal.getWidth() - left - right;
        int height = orginal.getHeight() - top - bottom;
        if (width == orginal.getWidth() && height == orginal.getHeight()) {
            return orginal;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        canvas.drawBitmap(orginal, (float)(-left), (float)(-top), paint);
        return output;
    }

    public static boolean isBlackBitmap(Bitmap bm) throws Throwable {
        if (bm == null || bm.isRecycled()) {
            return true;
        }
        int[] pixels = new int[bm.getWidth() * bm.getHeight()];
        bm.getPixels(pixels, 0, bm.getWidth(), 0, 0, bm.getWidth(), bm.getHeight());
        int rgb = 0;
        boolean found = false;
        for (int i = 0; i < pixels.length; ++i) {
            rgb = pixels[i] & 0xFFFFFF;
            if (rgb == 0) continue;
            found = true;
            break;
        }
        return !found;
    }

    public static int mixAlpha(int frontARGB, int backRGB) {
        int fa = frontARGB >>> 24;
        int fr = (0xFF0000 & frontARGB) >>> 16;
        int fg = (0xFF00 & frontARGB) >>> 8;
        int fb = 0xFF & frontARGB;
        int br = (0xFF0000 & backRGB) >>> 16;
        int bg = (0xFF00 & backRGB) >>> 8;
        int bb = 0xFF & backRGB;
        return 0xFF000000 | (fa * fr + (255 - fa) * br) / 255 << 16 | (fa * fg + (255 - fa) * bg) / 255 << 8 | (fa * fb + (255 - fa) * bb) / 255;
    }

    public static Bitmap scaleBitmapByHeight(Context context, int resId, int height) throws Throwable {
        Bitmap bm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        boolean rec = height != bm.getHeight();
        Bitmap dst = BitmapHelper.scaleBitmapByHeight(bm, height);
        if (rec) {
            bm.recycle();
        }
        return dst;
    }

    public static Bitmap scaleBitmapByHeight(Bitmap src, int height) throws Throwable {
        int width = height * src.getWidth() / src.getHeight();
        return Bitmap.createScaledBitmap((Bitmap)src, (int)width, (int)height, (boolean)true);
    }

    public static Bitmap compressByQuality(Bitmap src, int quality) {
        return BitmapHelper.compressByQuality(src, quality, false);
    }

    public static Bitmap compressByQuality(Bitmap src, int quality, boolean recycle) {
        if (BitmapHelper.isEmptyBitmap(src)) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        src.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap compressByQuality(Bitmap src, long maxByteSize) {
        return BitmapHelper.compressByQuality(src, maxByteSize, false);
    }

    public static Bitmap compressByQuality(Bitmap src, long maxByteSize, boolean recycle) {
        byte[] bytes;
        if (BitmapHelper.isEmptyBitmap(src) || maxByteSize <= 0L) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        src.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        if ((long)baos.size() <= maxByteSize) {
            bytes = baos.toByteArray();
        } else {
            baos.reset();
            src.compress(Bitmap.CompressFormat.JPEG, 0, (OutputStream)baos);
            if ((long)baos.size() >= maxByteSize) {
                bytes = baos.toByteArray();
            } else {
                int st = 0;
                int end = 100;
                int mid = 0;
                while (st < end) {
                    mid = (st + end) / 2;
                    baos.reset();
                    src.compress(Bitmap.CompressFormat.JPEG, mid, (OutputStream)baos);
                    int len = baos.size();
                    if ((long)len == maxByteSize) break;
                    if ((long)len > maxByteSize) {
                        end = mid - 1;
                        continue;
                    }
                    st = mid + 1;
                }
                if (end == mid - 1) {
                    baos.reset();
                    src.compress(Bitmap.CompressFormat.JPEG, st, (OutputStream)baos);
                }
                bytes = baos.toByteArray();
            }
        }
        if (recycle && !src.isRecycled()) {
            src.recycle();
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    private static boolean isEmptyBitmap(Bitmap src) {
        return src == null || src.getWidth() == 0 || src.getHeight() == 0;
    }

    public static boolean save(Bitmap src, String filePath, Bitmap.CompressFormat format) {
        return BitmapHelper.save(src, FileUtils.getFileByPath(filePath), format, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean save(Bitmap src, File file, Bitmap.CompressFormat format, boolean recycle) {
        boolean ret;
        BufferedOutputStream os;
        block5: {
            if (BitmapHelper.isEmptyBitmap(src) || !FileUtils.createFileByDeleteOldFile(file)) {
                return false;
            }
            os = null;
            ret = false;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                ret = src.compress(format, 100, (OutputStream)os);
                if (!recycle || src.isRecycled()) break block5;
                src.recycle();
            }
            catch (Throwable t) {
                try {
                    MobLog.getInstance().d(t);
                }
                catch (Throwable throwable) {
                    FileUtils.closeIO(os);
                    throw throwable;
                }
                FileUtils.closeIO(os);
            }
        }
        FileUtils.closeIO(os);
        return ret;
    }

    static {
        int maxBitmapDimension;
        int[] maxTextureSize = new int[1];
        GLES10.glGetIntegerv((int)3379, (int[])maxTextureSize, (int)0);
        maxBitmapWidth = maxBitmapDimension = Math.max(maxTextureSize[0], 2048);
        maxBitmapHeight = maxBitmapDimension;
    }
}

