/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.wechat.utils;

import android.graphics.Bitmap;
import android.os.Bundle;
import cn.sharesdk.framework.utils.e;
import cn.sharesdk.wechat.utils.WXMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WXImageObject
implements WXMediaMessage.IMediaObject {
    public byte[] imageData;
    public String imagePath;
    public String imageUrl;

    public WXImageObject() {
    }

    public WXImageObject(byte[] paramArrayOfByte) {
        this.imageData = paramArrayOfByte;
    }

    public WXImageObject(Bitmap paramBitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            paramBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            e.b().d((Throwable)exception);
            return;
        }
    }

    @Override
    public void serialize(Bundle paramBundle) {
        paramBundle.putByteArray("_wximageobject_imageData", this.imageData);
        paramBundle.putString("_wximageobject_imagePath", this.imagePath);
        paramBundle.putString("_wximageobject_imageUrl", this.imageUrl);
    }

    @Override
    public void unserialize(Bundle paramBundle) {
        this.imageData = paramBundle.getByteArray("_wximageobject_imageData");
        this.imagePath = paramBundle.getString("_wximageobject_imagePath");
        this.imageUrl = paramBundle.getString("_wximageobject_imageUrl");
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0 || this.imageUrl != null && this.imageUrl.length() != 0)) {
            e.b().d((Object)"checkArgs fail, all arguments are null", new Object[0]);
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            e.b().d((Object)"checkArgs fail, content is too large", new Object[0]);
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            e.b().d((Object)"checkArgs fail, path is invalid", new Object[0]);
            return false;
        }
        if (this.imagePath != null && new File(this.imagePath).length() > 0xA00000L) {
            e.b().d((Object)"checkArgs fail, image content is too large", new Object[0]);
            return false;
        }
        if (this.imageUrl != null && this.imageUrl.length() > 10240) {
            e.b().d((Object)"checkArgs fail, url is invalid", new Object[0]);
            return false;
        }
        return true;
    }
}

