/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.onekeyshare.CustomerLogo;
import cn.sharesdk.onekeyshare.themes.classic.IndicatorView;
import cn.sharesdk.onekeyshare.themes.classic.PlatformPage;
import com.mob.tools.gui.ViewPagerAdapter;
import com.mob.tools.utils.ResHelper;
import java.util.ArrayList;

public abstract class PlatformPageAdapter
extends ViewPagerAdapter
implements View.OnClickListener {
    protected static final int MIN_CLICK_INTERVAL = 1000;
    public static final int DESIGN_BOTTOM_HEIGHT = 52;
    protected Object[][] cells;
    private PlatformPage page;
    private IndicatorView vInd;
    protected int bottomHeight;
    protected int panelHeight;
    protected int cellHeight;
    protected int lineSize;
    protected int sepLineWidth;
    protected int paddingTop;
    protected int logoHeight;
    private long lastClickTime;

    public PlatformPageAdapter(PlatformPage page, ArrayList<Object> cells) {
        this.page = page;
        if (cells != null && !cells.isEmpty()) {
            this.calculateSize(page.getContext(), cells);
            this.collectCells(cells);
        }
    }

    protected abstract void calculateSize(Context var1, ArrayList<Object> var2);

    protected abstract void collectCells(ArrayList<Object> var1);

    public int getBottomHeight() {
        return this.bottomHeight;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public int getCount() {
        return this.cells == null ? 0 : this.cells.length;
    }

    public void setIndicator(IndicatorView view) {
        this.vInd = view;
    }

    public void onScreenChange(int currentScreen, int lastScreen) {
        if (this.vInd != null) {
            this.vInd.setScreenCount(this.getCount());
            this.vInd.onScreenChange(currentScreen, lastScreen);
        }
    }

    public View getView(int index, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.createPanel(parent.getContext());
        }
        LinearLayout llPanel = (LinearLayout)ResHelper.forceCast((Object)convertView);
        LinearLayout[] llCells = (LinearLayout[])ResHelper.forceCast((Object)llPanel.getTag());
        this.refreshPanel(llCells, this.cells[index]);
        return convertView;
    }

    private View createPanel(Context context) {
        LinearLayout.LayoutParams lp;
        LinearLayout llPanel = new LinearLayout(context);
        llPanel.setOrientation(1);
        llPanel.setBackgroundColor(-855310);
        int lineCount = this.panelHeight / this.cellHeight;
        LinearLayout[] llCells = new LinearLayout[lineCount * this.lineSize];
        llPanel.setTag((Object)llCells);
        int cellBack = ResHelper.getBitmapRes((Context)context, (String)"ssdk_oks_classic_platform_cell_back");
        for (int i = 0; i < lineCount; ++i) {
            LinearLayout llLine = new LinearLayout(context);
            lp = new LinearLayout.LayoutParams(-1, this.cellHeight);
            llPanel.addView((View)llLine, (ViewGroup.LayoutParams)lp);
            for (int j = 0; j < this.lineSize; ++j) {
                llCells[i * this.lineSize + j] = new LinearLayout(context);
                llCells[i * this.lineSize + j].setBackgroundResource(cellBack);
                llCells[i * this.lineSize + j].setOrientation(1);
                lp = new LinearLayout.LayoutParams(-1, this.cellHeight);
                lp.weight = 1.0f;
                llLine.addView((View)llCells[i * this.lineSize + j], (ViewGroup.LayoutParams)lp);
                if (j >= this.lineSize - 1) continue;
                View vSep = new View(context);
                lp = new LinearLayout.LayoutParams(this.sepLineWidth, -1);
                llLine.addView(vSep, (ViewGroup.LayoutParams)lp);
            }
            View vSep = new View(context);
            lp = new LinearLayout.LayoutParams(-1, this.sepLineWidth);
            llPanel.addView(vSep, (ViewGroup.LayoutParams)lp);
        }
        for (LinearLayout llCell : llCells) {
            ImageView ivLogo = new ImageView(context);
            ivLogo.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            lp = new LinearLayout.LayoutParams(-1, this.logoHeight);
            lp.topMargin = this.paddingTop;
            llCell.addView((View)ivLogo, (ViewGroup.LayoutParams)lp);
            TextView tvName = new TextView(context);
            tvName.setTextColor(-10197916);
            tvName.setTextSize(2, 14.0f);
            tvName.setGravity(17);
            lp = new LinearLayout.LayoutParams(-1, -2);
            lp.weight = 1.0f;
            llCell.addView((View)tvName, (ViewGroup.LayoutParams)lp);
        }
        return llPanel;
    }

    private void refreshPanel(LinearLayout[] llCells, Object[] logos) {
        int cellBack = ResHelper.getBitmapRes((Context)this.page.getContext(), (String)"ssdk_oks_classic_platform_cell_back");
        int disableBack = ResHelper.getBitmapRes((Context)this.page.getContext(), (String)"ssdk_oks_classic_platfrom_cell_back_nor");
        for (int i = 0; i < logos.length; ++i) {
            ImageView ivLogo = (ImageView)ResHelper.forceCast((Object)llCells[i].getChildAt(0));
            TextView tvName = (TextView)ResHelper.forceCast((Object)llCells[i].getChildAt(1));
            if (logos[i] == null) {
                ivLogo.setVisibility(4);
                tvName.setVisibility(4);
                llCells[i].setBackgroundResource(disableBack);
                llCells[i].setOnClickListener(null);
                continue;
            }
            ivLogo.setVisibility(0);
            tvName.setVisibility(0);
            ivLogo.requestLayout();
            tvName.requestLayout();
            llCells[i].setBackgroundResource(cellBack);
            llCells[i].setOnClickListener((View.OnClickListener)this);
            llCells[i].setTag(logos[i]);
            if (logos[i] instanceof CustomerLogo) {
                CustomerLogo logo = (CustomerLogo)ResHelper.forceCast((Object)logos[i]);
                if (logo.logo != null) {
                    ivLogo.setImageBitmap(logo.logo);
                } else {
                    ivLogo.setImageBitmap(null);
                }
                if (logo.label != null) {
                    tvName.setText((CharSequence)logo.label);
                    continue;
                }
                tvName.setText((CharSequence)"");
                continue;
            }
            Platform plat = (Platform)ResHelper.forceCast((Object)logos[i]);
            String name = plat.getName().toLowerCase();
            int resId = ResHelper.getBitmapRes((Context)ivLogo.getContext(), (String)("ssdk_oks_classic_" + name));
            if (resId > 0) {
                ivLogo.setImageResource(resId);
            } else {
                ivLogo.setImageBitmap(null);
            }
            resId = ResHelper.getStringRes((Context)tvName.getContext(), (String)("ssdk_" + name));
            if (resId > 0) {
                tvName.setText(resId);
                continue;
            }
            tvName.setText((CharSequence)"");
        }
    }

    public void onClick(View v) {
        long time = System.currentTimeMillis();
        if (time - this.lastClickTime < 1000L) {
            return;
        }
        this.lastClickTime = time;
        if (v.getTag() instanceof CustomerLogo) {
            CustomerLogo logo = (CustomerLogo)ResHelper.forceCast((Object)v.getTag());
            this.page.performCustomLogoClick(v, logo);
        } else {
            Platform plat = (Platform)ResHelper.forceCast((Object)v.getTag());
            this.page.showEditPage(plat);
        }
    }
}

