/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import cn.sharesdk.framework.CustomPlatform;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.PlatformActionListener;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.onekeyshare.CustomerLogo;
import cn.sharesdk.onekeyshare.ShareContentCustomizeCallback;
import com.mob.MobSDK;
import com.mob.tools.utils.ResHelper;
import com.mob.tools.utils.UIHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class OnekeyShareThemeImpl
implements PlatformActionListener,
Handler.Callback {
    protected boolean dialogMode;
    protected HashMap<String, Object> shareParamsMap;
    protected boolean silent;
    protected ArrayList<CustomerLogo> customerLogos;
    protected HashMap<String, String> hiddenPlatforms;
    protected ShareContentCustomizeCallback customizeCallback;
    protected boolean disableSSO;
    protected Context context;
    public PlatformActionListener callback = this;

    public final void setDialogMode(boolean dialogMode) {
        this.dialogMode = dialogMode;
    }

    public final void setShareParamsMap(HashMap<String, Object> shareParamsMap) {
        this.shareParamsMap = shareParamsMap;
    }

    public final void setSilent(boolean silent) {
        this.silent = silent;
    }

    public final void setCustomerLogos(ArrayList<CustomerLogo> customerLogos) {
        this.customerLogos = customerLogos;
    }

    public final void setHiddenPlatforms(HashMap<String, String> hiddenPlatforms) {
        this.hiddenPlatforms = hiddenPlatforms;
    }

    public final void setPlatformActionListener(PlatformActionListener callback) {
        this.callback = callback == null ? this : callback;
    }

    public final void setShareContentCustomizeCallback(ShareContentCustomizeCallback customizeCallback) {
        this.customizeCallback = customizeCallback;
    }

    public final void disableSSO() {
        this.disableSSO = true;
    }

    public final void show(Context context) {
        this.context = context;
        if (this.shareParamsMap.containsKey("platform")) {
            String name = String.valueOf(this.shareParamsMap.get("platform"));
            Platform platform = ShareSDK.getPlatform((String)name);
            boolean isCustomPlatform = platform instanceof CustomPlatform;
            boolean isUseClientToShare = this.isUseClientToShare(platform);
            if (this.silent || isCustomPlatform || isUseClientToShare) {
                this.shareSilently(platform);
            } else {
                this.prepareForEditPage(platform);
            }
        } else {
            this.showPlatformPage(context);
        }
    }

    final boolean isUseClientToShare(Platform platform) {
        boolean shareByAppClient;
        String name = platform.getName();
        if ("SinaWeibo".equals(name) || "Wechat".equals(name) || "WechatMoments".equals(name) || "WechatFavorite".equals(name) || "ShortMessage".equals(name) || "Email".equals(name) || "Qzone".equals(name) || "QQ".equals(name) || "Pinterest".equals(name) || "Instagram".equals(name) || "Yixin".equals(name) || "YixinMoments".equals(name) || "QZone".equals(name) || "Mingdao".equals(name) || "Line".equals(name) || "KakaoStory".equals(name) || "KakaoTalk".equals(name) || "Bluetooth".equals(name) || "WhatsApp".equals(name) || "BaiduTieba".equals(name) || "Laiwang".equals(name) || "LaiwangMoments".equals(name) || "Alipay".equals(name) || "AlipayMoments".equals(name) || "FacebookMessenger".equals(name) || "GooglePlus".equals(name) || "Dingding".equals(name) || "Youtube".equals(name) || "Meipai".equals(name) || "Telegram".equals(name) || "Douyin".equals(name) || "Oasis".equals(name)) {
            return true;
        }
        if ("Evernote".equals(name)) {
            if ("true".equals(platform.getDevinfo("ShareByAppClient"))) {
                return true;
            }
        } else if ("Facebook".equals(name)) {
            boolean shareByAppClient2 = "true".equals(platform.getDevinfo("ShareByAppClient"));
            if (shareByAppClient2 && platform.isClientValid()) {
                return true;
            }
            if (this.shareParamsMap.containsKey("url") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("url")))) {
                return true;
            }
        } else if ("LinkedIn".equals(name) && (shareByAppClient = "true".equals(platform.getDevinfo("ShareByAppClient"))) && platform.isClientValid()) {
            return true;
        }
        return false;
    }

    final void shareSilently(Platform platform) {
        Platform.ShareParams sp;
        if (this.formateShareData(platform) && (sp = this.shareDataToShareParams(platform)) != null) {
            if (null != this.shareParamsMap) {
                Boolean isDispear = this.shareParamsMap.containsKey("disappearsharetoast") ? (Boolean)this.shareParamsMap.get("disappearsharetoast") : false;
                if (!isDispear.booleanValue()) {
                    this.toast("ssdk_oks_sharing");
                } else {
                    Log.d((String)"ShareSDK", (String)"isDispear is false");
                }
            }
            if (this.customizeCallback != null) {
                this.customizeCallback.onShare(platform, sp);
                Log.d((String)"ShareSDK", (String)"customizeCallback.onShare(platform, sp)");
            }
            if (this.disableSSO) {
                platform.SSOSetting(this.disableSSO);
                Log.d((String)"ShareSDK", (String)"platform.SSOSetting(disableSSO)");
            }
            platform.setPlatformActionListener(this.callback);
            platform.share(sp);
            this.callback = null;
            this.customizeCallback = null;
        }
    }

    private void prepareForEditPage(Platform platform) {
        Platform.ShareParams sp;
        if (this.formateShareData(platform) && (sp = this.shareDataToShareParams(platform)) != null) {
            ShareSDK.logDemoEvent((int)3, (Platform)platform);
            sp.setOpenCustomEven(true);
            if (this.customizeCallback != null) {
                this.customizeCallback.onShare(platform, sp);
            }
            this.showEditPage(this.context, platform, sp);
            this.customizeCallback = null;
        }
    }

    final boolean formateShareData(Platform plat) {
        boolean isWechat;
        boolean isYixin;
        boolean isAlipay;
        String name = plat.getName();
        boolean bl = isAlipay = "Alipay".equals(name) || "AlipayMoments".equals(name);
        if (isAlipay && !plat.isClientValid()) {
            this.toast("ssdk_alipay_client_inavailable");
            return false;
        }
        boolean isKakaoTalk = "KakaoTalk".equals(name);
        if (isKakaoTalk && !plat.isClientValid()) {
            this.toast("ssdk_kakaotalk_client_inavailable");
            return false;
        }
        boolean isKakaoStory = "KakaoStory".equals(name);
        if (isKakaoStory && !plat.isClientValid()) {
            this.toast("ssdk_kakaostory_client_inavailable");
            return false;
        }
        boolean isLine = "Line".equals(name);
        if (isLine && !plat.isClientValid()) {
            this.toast("ssdk_line_client_inavailable");
            return false;
        }
        boolean isWhatsApp = "WhatsApp".equals(name);
        if (isWhatsApp && !plat.isClientValid()) {
            this.toast("ssdk_whatsapp_client_inavailable");
            return false;
        }
        boolean isPinterest = "Pinterest".equals(name);
        if (isPinterest && !plat.isClientValid()) {
            this.toast("ssdk_pinterest_client_inavailable");
            return false;
        }
        if ("Instagram".equals(name) && !plat.isClientValid()) {
            this.toast("ssdk_instagram_client_inavailable");
            return false;
        }
        if ("QZone".equals(name) && !plat.isClientValid()) {
            this.toast("ssdk_qq_client_inavailable");
            return false;
        }
        boolean isLaiwang = "Laiwang".equals(name);
        boolean isLaiwangMoments = "LaiwangMoments".equals(name);
        if ((isLaiwang || isLaiwangMoments) && !plat.isClientValid()) {
            this.toast("ssdk_laiwang_client_inavailable");
            return false;
        }
        boolean bl2 = isYixin = "YixinMoments".equals(name) || "Yixin".equals(name);
        if (isYixin && !plat.isClientValid()) {
            this.toast("ssdk_yixin_client_inavailable");
            return false;
        }
        boolean bl3 = isWechat = "WechatFavorite".equals(name) || "Wechat".equals(name) || "WechatMoments".equals(name);
        if (isWechat && !plat.isClientValid()) {
            this.toast("ssdk_wechat_client_inavailable");
            return false;
        }
        if ("FacebookMessenger".equals(name) && !plat.isClientValid()) {
            this.toast("ssdk_facebookmessenger_client_inavailable");
            return false;
        }
        if ("Telegram".equals(name) && !plat.isClientValid()) {
            this.toast("ssdk_telegram_client_inavailable");
            return false;
        }
        if (!this.shareParamsMap.containsKey("shareType")) {
            int shareType = 1;
            String imagePath = String.valueOf(this.shareParamsMap.get("imagePath"));
            if (imagePath != null && new File(imagePath).exists()) {
                shareType = 2;
                if (imagePath.endsWith(".gif") && isWechat) {
                    shareType = 9;
                } else if (this.shareParamsMap.containsKey("url") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("url")))) {
                    shareType = 4;
                    if (this.shareParamsMap.containsKey("musicUrl") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("musicUrl"))) && isWechat) {
                        shareType = 5;
                    }
                }
            } else {
                Bitmap viewToShare = (Bitmap)ResHelper.forceCast((Object)this.shareParamsMap.get("viewToShare"));
                if (viewToShare != null && !viewToShare.isRecycled()) {
                    shareType = 2;
                    if (this.shareParamsMap.containsKey("url") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("url")))) {
                        shareType = 4;
                        if (this.shareParamsMap.containsKey("musicUrl") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("musicUrl"))) && isWechat) {
                            shareType = 5;
                        }
                    }
                } else {
                    Object imageUrl = this.shareParamsMap.get("imageUrl");
                    if (imageUrl != null && !TextUtils.isEmpty((CharSequence)String.valueOf(imageUrl))) {
                        shareType = 2;
                        if (String.valueOf(imageUrl).endsWith(".gif") && isWechat) {
                            shareType = 9;
                        } else if (this.shareParamsMap.containsKey("url") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("url")))) {
                            shareType = 4;
                            if (this.shareParamsMap.containsKey("musicUrl") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("musicUrl"))) && isWechat) {
                                shareType = 5;
                            }
                        }
                    } else {
                        Bitmap imageData = (Bitmap)this.shareParamsMap.get("imageData");
                        if (imageData != null) {
                            shareType = 2;
                            if (String.valueOf(imageUrl).endsWith(".gif") && isWechat) {
                                shareType = 9;
                            } else if (this.shareParamsMap.containsKey("url") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("url")))) {
                                shareType = 4;
                                if (this.shareParamsMap.containsKey("musicUrl") && !TextUtils.isEmpty((CharSequence)((String)this.shareParamsMap.get("musicUrl"))) && isWechat) {
                                    shareType = 5;
                                }
                            }
                        }
                    }
                }
            }
            this.shareParamsMap.put("shareType", shareType);
        }
        return true;
    }

    final Platform.ShareParams shareDataToShareParams(Platform plat) {
        if (plat == null || this.shareParamsMap == null) {
            this.toast("ssdk_oks_share_failed");
            return null;
        }
        try {
            String imagePath = (String)ResHelper.forceCast((Object)this.shareParamsMap.get("imagePath"));
            Bitmap viewToShare = (Bitmap)ResHelper.forceCast((Object)this.shareParamsMap.get("viewToShare"));
            if (TextUtils.isEmpty((CharSequence)imagePath) && viewToShare != null && !viewToShare.isRecycled()) {
                String path = ResHelper.getCachePath((Context)MobSDK.getContext(), (String)"screenshot");
                File ss = new File(path, String.valueOf(System.currentTimeMillis()) + ".jpg");
                FileOutputStream fos = new FileOutputStream(ss);
                viewToShare.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
                fos.flush();
                fos.close();
                this.shareParamsMap.put("imagePath", ss.getAbsolutePath());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.toast("ssdk_oks_share_failed");
            return null;
        }
        return new Platform.ShareParams(this.shareParamsMap);
    }

    private void toast(final String resOrName) {
        UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                int resId = ResHelper.getStringRes((Context)OnekeyShareThemeImpl.this.context, (String)resOrName);
                if (resId > 0) {
                    Toast.makeText((Context)OnekeyShareThemeImpl.this.context, (int)resId, (int)0).show();
                } else {
                    Toast.makeText((Context)OnekeyShareThemeImpl.this.context, (CharSequence)resOrName, (int)0).show();
                }
                return false;
            }
        });
    }

    protected abstract void showPlatformPage(Context var1);

    protected abstract void showEditPage(Context var1, Platform var2, Platform.ShareParams var3);

    public final void onComplete(Platform platform, int action, HashMap<String, Object> res) {
        Message msg = new Message();
        msg.arg1 = 1;
        msg.arg2 = action;
        msg.obj = platform;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
    }

    public final void onError(Platform platform, int action, Throwable t) {
        t.printStackTrace();
        Message msg = new Message();
        msg.arg1 = 2;
        msg.arg2 = action;
        msg.obj = t;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
        ShareSDK.logDemoEvent((int)4, (Platform)platform);
    }

    public final void onCancel(Platform platform, int action) {
        Message msg = new Message();
        msg.arg1 = 3;
        msg.arg2 = action;
        msg.obj = platform;
        UIHandler.sendMessage((Message)msg, (Handler.Callback)this);
        ShareSDK.logDemoEvent((int)5, (Platform)platform);
    }

    public final boolean handleMessage(Message msg) {
        switch (msg.arg1) {
            case 1: {
                int resId = ResHelper.getStringRes((Context)this.context, (String)"ssdk_oks_share_completed");
                if (resId <= 0) break;
                this.toast(this.context.getString(resId));
                break;
            }
            case 2: {
                String expName = msg.obj.getClass().getSimpleName();
                if ("WechatClientNotExistException".equals(expName) || "WechatTimelineNotSupportedException".equals(expName) || "WechatFavoriteNotSupportedException".equals(expName)) {
                    this.toast("ssdk_wechat_client_inavailable");
                    break;
                }
                if ("GooglePlusClientNotExistException".equals(expName)) {
                    this.toast("ssdk_google_plus_client_inavailable");
                    break;
                }
                if ("QQClientNotExistException".equals(expName)) {
                    this.toast("ssdk_qq_client_inavailable");
                    break;
                }
                if ("YixinClientNotExistException".equals(expName) || "YixinTimelineNotSupportedException".equals(expName)) {
                    this.toast("ssdk_yixin_client_inavailable");
                    break;
                }
                if ("KakaoTalkClientNotExistException".equals(expName)) {
                    this.toast("ssdk_kakaotalk_client_inavailable");
                    break;
                }
                if ("KakaoStoryClientNotExistException".equals(expName)) {
                    this.toast("ssdk_kakaostory_client_inavailable");
                    break;
                }
                if ("WhatsAppClientNotExistException".equals(expName)) {
                    this.toast("ssdk_whatsapp_client_inavailable");
                    break;
                }
                if ("FacebookMessengerClientNotExistException".equals(expName)) {
                    this.toast("ssdk_facebookmessenger_client_inavailable");
                    break;
                }
                this.toast("ssdk_oks_share_failed");
                break;
            }
            case 3: {
                this.toast("ssdk_oks_share_canceled");
            }
        }
        return false;
    }
}

