/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare.themes.classic.land;

import android.content.Context;
import cn.sharesdk.onekeyshare.themes.classic.PlatformPage;
import cn.sharesdk.onekeyshare.themes.classic.PlatformPageAdapter;
import com.mob.tools.utils.ResHelper;
import java.util.ArrayList;

public class PlatformPageAdapterLand
extends PlatformPageAdapter {
    private static final int DESIGN_SCREEN_WIDTH_L = 1280;
    private static final int DESIGN_CELL_WIDTH_L = 160;
    private static final int DESIGN_SEP_LINE_WIDTH = 1;
    private static final int DESIGN_LOGO_HEIGHT = 76;
    private static final int DESIGN_PADDING_TOP = 20;

    public PlatformPageAdapterLand(PlatformPage page, ArrayList<Object> cells) {
        super(page, cells);
    }

    @Override
    protected void calculateSize(Context context, ArrayList<Object> plats) {
        int screenWidth = ResHelper.getScreenWidth((Context)context);
        float ratio = (float)screenWidth / 1280.0f;
        int cellWidth = (int)(160.0f * ratio);
        this.lineSize = screenWidth / cellWidth;
        this.sepLineWidth = (int)(1.0f * ratio);
        this.sepLineWidth = this.sepLineWidth < 1 ? 1 : this.sepLineWidth;
        this.logoHeight = (int)(76.0f * ratio);
        this.paddingTop = (int)(20.0f * ratio);
        this.bottomHeight = (int)(52.0f * ratio);
        this.cellHeight = (screenWidth - this.sepLineWidth * 3) / (this.lineSize - 1);
        this.panelHeight = this.cellHeight + this.sepLineWidth;
    }

    @Override
    protected void collectCells(ArrayList<Object> plats) {
        int count = plats.size();
        if (count < this.lineSize) {
            int lineCount = count / this.lineSize;
            if (count % this.lineSize != 0) {
                ++lineCount;
            }
            this.cells = new Object[1][lineCount * this.lineSize];
        } else {
            int pageCount = count / this.lineSize;
            if (count % this.lineSize != 0) {
                ++pageCount;
            }
            this.cells = new Object[pageCount][this.lineSize];
        }
        for (int i = 0; i < count; ++i) {
            int p = i / this.lineSize;
            this.cells[p][i - this.lineSize * p] = plats.get(i);
        }
    }
}

