/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.apache.dubbo.rpc.RpcException;

public class ConsulRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConsulRegistry.class);
    private ConsulClient client;
    private long checkPassInterval;
    private ExecutorService notifierExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("dubbo-consul-notifier", true));
    private ConcurrentMap<URL, ConsulNotifier> notifiers = new ConcurrentHashMap<URL, ConsulNotifier>();
    private ScheduledExecutorService ttlConsulCheckExecutor;
    private String token;

    public ConsulRegistry(URL url) {
        super(url);
        this.token = url.getParameter("token", (String)null);
        String host = url.getHost();
        int port = url.getPort() != 0 ? url.getPort() : 8500;
        this.client = new ConsulClient(host, port);
        this.checkPassInterval = url.getParameter("consul-check-pass-interval", 16000L);
        this.ttlConsulCheckExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Ttl-Consul-Check-Executor", true));
        this.ttlConsulCheckExecutor.scheduleAtFixedRate(this::checkPass, this.checkPassInterval / 8L, this.checkPassInterval / 8L, TimeUnit.MILLISECONDS);
    }

    public void register(URL url) {
        if (this.isConsumerSide(url)) {
            return;
        }
        super.register(url);
    }

    public void doRegister(URL url) {
        if (this.token == null) {
            this.client.agentServiceRegister(this.buildService(url));
        } else {
            this.client.agentServiceRegister(this.buildService(url), this.token);
        }
    }

    public void unregister(URL url) {
        if (this.isConsumerSide(url)) {
            return;
        }
        super.unregister(url);
    }

    public void doUnregister(URL url) {
        if (this.token == null) {
            this.client.agentServiceDeregister(this.buildId(url));
        } else {
            this.client.agentServiceDeregister(this.buildId(url), this.token);
        }
    }

    public void subscribe(URL url, NotifyListener listener) {
        if (this.isProviderSide(url)) {
            return;
        }
        super.subscribe(url, listener);
    }

    public void doSubscribe(URL url, NotifyListener listener) {
        List<URL> urls;
        Long index;
        if ("*".equals(url.getServiceInterface())) {
            Response<Map<String, List<String>>> response = this.getAllServices(-1L, this.buildWatchTimeout(url));
            index = response.getConsulIndex();
            List<HealthService> services = this.getHealthServices((Map)response.getValue());
            urls = this.convert(services, url);
        } else {
            String service = url.getServiceInterface();
            Response<List<HealthService>> response = this.getHealthServices(service, -1L, this.buildWatchTimeout(url));
            index = response.getConsulIndex();
            urls = this.convert((List)response.getValue(), url);
        }
        this.notify(url, listener, urls);
        ConsulNotifier notifier = this.notifiers.computeIfAbsent(url, k -> new ConsulNotifier(url, index));
        this.notifierExecutor.submit(notifier);
    }

    public void unsubscribe(URL url, NotifyListener listener) {
        if (this.isProviderSide(url)) {
            return;
        }
        super.unsubscribe(url, listener);
    }

    public void doUnsubscribe(URL url, NotifyListener listener) {
        ConsulNotifier notifier = (ConsulNotifier)this.notifiers.remove(url);
        notifier.stop();
    }

    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        try {
            String service = url.getServiceKey();
            Response<List<HealthService>> result = this.getHealthServices(service, -1L, this.buildWatchTimeout(url));
            if (result == null || result.getValue() == null || ((List)result.getValue()).isEmpty()) {
                return new ArrayList<URL>();
            }
            return this.convert((List)result.getValue(), url);
        }
        catch (Throwable e) {
            throw new RpcException("Failed to lookup " + url + " from consul " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return this.client.getAgentSelf() != null;
    }

    public void destroy() {
        super.destroy();
        this.notifierExecutor.shutdown();
        this.ttlConsulCheckExecutor.shutdown();
    }

    private void checkPass() {
        for (URL url : this.getRegistered()) {
            String checkId = this.buildId(url);
            try {
                if (this.token == null) {
                    this.client.agentCheckPass("service:" + checkId);
                } else {
                    this.client.agentCheckPass("service:" + checkId, null, this.token);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("check pass for url: " + url + " with check id: " + checkId);
            }
            catch (Throwable t) {
                logger.warn("fail to check pass for url: " + url + ", check id is: " + checkId, t);
            }
        }
    }

    private Response<List<HealthService>> getHealthServices(String service, long index, int watchTimeout) {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag("dubbo").setQueryParams(new QueryParams((long)watchTimeout, index)).setPassing(true).setToken(this.token).build();
        return this.client.getHealthServices(service, request);
    }

    private Response<Map<String, List<String>>> getAllServices(long index, int watchTimeout) {
        CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setQueryParams(new QueryParams((long)watchTimeout, index)).setToken(this.token).build();
        return this.client.getCatalogServices(request);
    }

    private List<HealthService> getHealthServices(Map<String, List<String>> services) {
        return services.entrySet().stream().filter(s -> ((List)s.getValue()).contains("dubbo")).map(s -> (List)this.getHealthServices((String)s.getKey(), -1L, -1).getValue()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isConsumerSide(URL url) {
        return url.getProtocol().equals("consumer");
    }

    private boolean isProviderSide(URL url) {
        return url.getProtocol().equals("provider");
    }

    private List<URL> convert(List<HealthService> services, URL consumerURL) {
        if (CollectionUtils.isEmpty(services)) {
            return this.emptyURL(consumerURL);
        }
        return services.stream().map(HealthService::getService).filter(Objects::nonNull).map(HealthService.Service::getMeta).filter(m -> m != null && m.containsKey("url")).map(m -> (String)m.get("url")).map(URL::valueOf).filter(url -> UrlUtils.isMatch((URL)consumerURL, (URL)url)).collect(Collectors.toList());
    }

    private List<URL> emptyURL(URL consumerURL) {
        URL empty = URLBuilder.from((URL)consumerURL).setProtocol("empty").removeParameter("category").build();
        ArrayList<URL> result = new ArrayList<URL>();
        result.add(empty);
        return result;
    }

    private NewService buildService(URL url) {
        NewService service = new NewService();
        service.setAddress(url.getHost());
        service.setPort(Integer.valueOf(url.getPort()));
        service.setId(this.buildId(url));
        service.setName(url.getServiceInterface());
        service.setCheck(this.buildCheck(url));
        service.setTags(this.buildTags(url));
        service.setMeta(Collections.singletonMap("url", url.toFullString()));
        return service;
    }

    private List<String> buildTags(URL url) {
        Map params = url.getParameters();
        List<String> tags = params.entrySet().stream().map(k -> (String)k.getKey() + "=" + (String)k.getValue()).collect(Collectors.toList());
        tags.add("dubbo");
        return tags;
    }

    private String buildId(URL url) {
        return Integer.toHexString(url.hashCode());
    }

    private NewService.Check buildCheck(URL url) {
        NewService.Check check = new NewService.Check();
        check.setTtl(this.checkPassInterval / 1000L + "s");
        check.setDeregisterCriticalServiceAfter(url.getParameter("consul-deregister-critical-service-after", "20s"));
        return check;
    }

    private int buildWatchTimeout(URL url) {
        return url.getParameter("consul-watch-timeout", 60000) / 1000;
    }

    private class ConsulNotifier
    implements Runnable {
        private URL url;
        private long consulIndex;
        private boolean running;

        ConsulNotifier(URL url, long consulIndex) {
            this.url = url;
            this.consulIndex = consulIndex;
            this.running = true;
        }

        @Override
        public void run() {
            while (this.running) {
                if ("*".equals(this.url.getServiceInterface())) {
                    this.processServices();
                    continue;
                }
                this.processService();
            }
        }

        private void processService() {
            String service = this.url.getServiceKey();
            Response response = ConsulRegistry.this.getHealthServices(service, this.consulIndex, ConsulRegistry.this.buildWatchTimeout(this.url));
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                this.consulIndex = currentIndex;
                List services = (List)response.getValue();
                List urls = ConsulRegistry.this.convert(services, this.url);
                for (NotifyListener listener : (Set)ConsulRegistry.this.getSubscribed().get(this.url)) {
                    ConsulRegistry.this.doNotify(this.url, listener, urls);
                }
            }
        }

        private void processServices() {
            Response response = ConsulRegistry.this.getAllServices(this.consulIndex, ConsulRegistry.this.buildWatchTimeout(this.url));
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                this.consulIndex = currentIndex;
                List services = ConsulRegistry.this.getHealthServices((Map)response.getValue());
                List urls = ConsulRegistry.this.convert(services, this.url);
                for (NotifyListener listener : (Set)ConsulRegistry.this.getSubscribed().get(this.url)) {
                    ConsulRegistry.this.doNotify(this.url, listener, urls);
                }
            }
        }

        void stop() {
            this.running = false;
        }
    }
}

