/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.proxy;

import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

public class RemoteMetadataServiceProxy
implements MetadataService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String serviceName;
    private final String revision;

    public RemoteMetadataServiceProxy(ServiceInstance serviceInstance) {
        this.serviceName = serviceInstance.getServiceName();
        this.revision = serviceInstance.getMetadata(ServiceInstanceMetadataUtils.EXPORTED_SERVICES_REVISION_PROPERTY_NAME, "X");
    }

    public String serviceName() {
        return this.serviceName;
    }

    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        SortedSet exportedURLs = this.getMetadataReport().getExportedURLs(this.serviceName, this.revision);
        if ("*".equals(serviceInterface)) {
            return exportedURLs;
        }
        return Collections.unmodifiableSortedSet(exportedURLs.stream().map(URL::valueOf).filter(url -> serviceInterface == null || serviceInterface.equals(url.getServiceInterface())).filter(url -> group == null || group.equals(url.getParameter("group"))).filter(url -> version == null || version.equals(url.getParameter("version"))).filter(url -> protocol == null || protocol.equals(url.getProtocol())).map(URL::toFullString).collect(TreeSet::new, Set::add, Set::addAll));
    }

    public String getServiceDefinition(String interfaceName, String version, String group) {
        return this.getMetadataReport().getServiceDefinition(new MetadataIdentifier(interfaceName, version, group, "provider", this.serviceName));
    }

    public String getServiceDefinition(String serviceDefinitionKey) {
        String[] services = UrlUtils.parseServiceKey((String)serviceDefinitionKey);
        String serviceInterface = services[0];
        String version = null;
        if (services.length > 1) {
            version = services[1];
        }
        String group = null;
        if (services.length > 2) {
            group = services[2];
        }
        return this.getMetadataReport().getServiceDefinition(new MetadataIdentifier(serviceInterface, version, group, "provider", this.serviceName));
    }

    MetadataReport getMetadataReport() {
        return MetadataReportInstance.getMetadataReport((boolean)true);
    }
}

