/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.JavadocTokenTypes;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.InvalidJavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.BlockTagUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.InlineTagUtils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.TagInfo;
import com.puppycrawl.tools.checkstyle.utils.BlockCommentPosition;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;

public final class JavadocUtils {
    private static final Map<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final String[] TOKEN_VALUE_TO_NAME;
    private static final String UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE = "Unknown javadoc token id. Given id: ";
    private static final Pattern NEWLINE;
    private static final Pattern RETURN;
    private static final Pattern TAB;

    private JavadocUtils() {
    }

    public static JavadocTags getJavadocTags(TextBlock textBlock, JavadocTagType tagType) {
        boolean getBlockTags = tagType == JavadocTagType.ALL || tagType == JavadocTagType.BLOCK;
        boolean getInlineTags = tagType == JavadocTagType.ALL || tagType == JavadocTagType.INLINE;
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        if (getBlockTags) {
            tags.addAll(BlockTagUtils.extractBlockTags(textBlock.getText()));
        }
        if (getInlineTags) {
            tags.addAll(InlineTagUtils.extractInlineTags(textBlock.getText()));
        }
        ArrayList<JavadocTag> validTags = new ArrayList<JavadocTag>();
        ArrayList<InvalidJavadocTag> invalidTags = new ArrayList<InvalidJavadocTag>();
        for (TagInfo tag : tags) {
            int col = tag.getPosition().getColumn();
            int line = textBlock.getStartLineNo() + tag.getPosition().getLine() - 1;
            if (JavadocTagInfo.isValidName(tag.getName())) {
                validTags.add(new JavadocTag(line, col, tag.getName(), tag.getValue()));
                continue;
            }
            invalidTags.add(new InvalidJavadocTag(line, col, tag.getName()));
        }
        return new JavadocTags(validTags, invalidTags);
    }

    public static boolean isJavadocComment(String commentContent) {
        boolean result = false;
        if (!commentContent.isEmpty()) {
            char docCommentIdentifier = commentContent.charAt(0);
            result = docCommentIdentifier == '*';
        }
        return result;
    }

    public static boolean isJavadocComment(DetailAST blockCommentBegin) {
        String commentContent = JavadocUtils.getBlockCommentContent(blockCommentBegin);
        return JavadocUtils.isJavadocComment(commentContent) && JavadocUtils.isCorrectJavadocPosition(blockCommentBegin);
    }

    private static String getBlockCommentContent(DetailAST blockCommentBegin) {
        DetailAST commentContent = blockCommentBegin.getFirstChild();
        return commentContent.getText();
    }

    public static String getJavadocCommentContent(DetailAST javadocCommentBegin) {
        DetailAST commentContent = javadocCommentBegin.getFirstChild();
        return commentContent.getText().substring(1);
    }

    public static DetailNode findFirstToken(DetailNode detailNode, int type) {
        DetailNode returnValue = null;
        DetailNode node = JavadocUtils.getFirstChild(detailNode);
        while (node != null) {
            if (node.getType() == type) {
                returnValue = node;
                break;
            }
            node = JavadocUtils.getNextSibling(node);
        }
        return returnValue;
    }

    public static DetailNode getFirstChild(DetailNode node) {
        DetailNode resultNode = null;
        if (node.getChildren().length > 0) {
            resultNode = node.getChildren()[0];
        }
        return resultNode;
    }

    public static boolean containsInBranch(DetailNode node, int type) {
        boolean result = true;
        DetailNode curNode = node;
        while (type != curNode.getType()) {
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                toVisit = JavadocUtils.getNextSibling(curNode);
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            if (curNode == toVisit) {
                result = false;
                break;
            }
            curNode = toVisit;
        }
        return result;
    }

    public static DetailNode getNextSibling(DetailNode node) {
        DetailNode[] children;
        int nextSiblingIndex;
        DetailNode nextSibling = null;
        DetailNode parent = node.getParent();
        if (parent != null && (nextSiblingIndex = node.getIndex() + 1) <= (children = parent.getChildren()).length - 1) {
            nextSibling = children[nextSiblingIndex];
        }
        return nextSibling;
    }

    public static DetailNode getNextSibling(DetailNode node, int tokenType) {
        DetailNode nextSibling = JavadocUtils.getNextSibling(node);
        while (nextSibling != null && nextSibling.getType() != tokenType) {
            nextSibling = JavadocUtils.getNextSibling(nextSibling);
        }
        return nextSibling;
    }

    public static DetailNode getPreviousSibling(DetailNode node) {
        DetailNode previousSibling = null;
        int previousSiblingIndex = node.getIndex() - 1;
        if (previousSiblingIndex >= 0) {
            DetailNode parent = node.getParent();
            DetailNode[] children = parent.getChildren();
            previousSibling = children[previousSiblingIndex];
        }
        return previousSibling;
    }

    public static String getTokenName(int id) {
        String name;
        if (id == -1) {
            name = "EOF";
        } else {
            if (id > TOKEN_VALUE_TO_NAME.length - 1) {
                throw new IllegalArgumentException(UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE + id);
            }
            name = TOKEN_VALUE_TO_NAME[id];
            if (name == null) {
                throw new IllegalArgumentException(UNKNOWN_JAVADOC_TOKEN_ID_EXCEPTION_MESSAGE + id);
            }
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = TOKEN_NAME_TO_VALUE.get(name);
        if (id == null) {
            throw new IllegalArgumentException("Unknown javadoc token name. Given name " + name);
        }
        return id;
    }

    public static String getTagName(DetailNode javadocTagSection) {
        String javadocTagName = javadocTagSection.getType() == 10072 ? JavadocUtils.getNextSibling(JavadocUtils.getFirstChild(javadocTagSection)).getText() : JavadocUtils.getFirstChild(javadocTagSection).getText();
        return javadocTagName;
    }

    public static String escapeAllControlChars(String text) {
        String textWithoutNewlines = NEWLINE.matcher(text).replaceAll("\\\\n");
        String textWithoutReturns = RETURN.matcher(textWithoutNewlines).replaceAll("\\\\r");
        return TAB.matcher(textWithoutReturns).replaceAll("\\\\t");
    }

    private static boolean isCorrectJavadocPosition(DetailAST blockComment) {
        DetailAST sibling = blockComment.getNextSibling();
        while (sibling != null) {
            if (sibling.getType() == 145) {
                if (JavadocUtils.isJavadocComment(JavadocUtils.getBlockCommentContent(sibling))) break;
                sibling = sibling.getNextSibling();
                continue;
            }
            if (sibling.getType() == 144) {
                sibling = sibling.getNextSibling();
                continue;
            }
            sibling = null;
        }
        return sibling == null && (BlockCommentPosition.isOnType(blockComment) || BlockCommentPosition.isOnMember(blockComment));
    }

    static {
        NEWLINE = Pattern.compile("\n");
        RETURN = Pattern.compile("\r");
        TAB = Pattern.compile("\t");
        TOKEN_NAME_TO_VALUE = TokenUtils.nameToValueMapFromPublicIntFields(JavadocTokenTypes.class);
        TOKEN_VALUE_TO_NAME = TokenUtils.valueToNameArrayFromNameToValueMap(TOKEN_NAME_TO_VALUE);
    }

    public static enum JavadocTagType {
        BLOCK,
        INLINE,
        ALL;

    }
}

