/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.EDTFormatterMode;
import com.helger.commons.datetime.PDTFormatter;
import com.helger.commons.string.StringHelper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDTFromString {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PDTFromString.class);
    private static final PDTFromString s_aInstance = new PDTFromString();

    private PDTFromString() {
    }

    private static void _onParseException(@Nonnull String string, @Nonnull String string2, @Nullable DateTimeFormatter dateTimeFormatter, @Nonnull DateTimeParseException dateTimeParseException) {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Failed to parse " + string + " '" + string2 + "'" + (dateTimeFormatter == null ? "" : " with " + dateTimeFormatter) + ": " + dateTimeParseException.getMessage());
        }
    }

    @Nullable
    public static ZonedDateTime getZonedDateTimeFromString(@Nullable String string, @Nonnull String string2) {
        return PDTFromString.getZonedDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    @Nullable
    public static ZonedDateTime getZonedDateTimeFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull(dateTimeFormatter, "DateTimeFormatter");
        if (StringHelper.hasText(string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, ZonedDateTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("ZonedDateTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    @Nullable
    public static LocalDate getLocalDateFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalDateFromString(string, PDTFormatter.getFormatterDate(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    @Nullable
    public static LocalDate getLocalDateFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull(dateTimeFormatter, "DateTimeFormatter");
        if (StringHelper.hasText(string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, LocalDate::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("LocalDate", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    @Nullable
    public static LocalDate getLocalDateFromString(@Nullable String string, @Nonnull String string2) {
        return PDTFromString.getLocalDateFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    @Nullable
    public static LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalDateTimeFromString(string, PDTFormatter.getFormatterDateTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    @Nullable
    public static LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull(dateTimeFormatter, "DateTimeFormatter");
        if (StringHelper.hasText(string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, LocalDateTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("LocalDateTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    @Nullable
    public static LocalDateTime getLocalDateTimeFromString(@Nullable String string, @Nonnull String string2) {
        return PDTFromString.getLocalDateTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    @Nullable
    public static LocalTime getLocalTimeFromString(@Nullable String string, @Nullable Locale locale) {
        return PDTFromString.getLocalTimeFromString(string, PDTFormatter.getFormatterTime(PDTFormatter.DEFAULT_STYLE, locale, EDTFormatterMode.PARSE));
    }

    @Nullable
    public static LocalTime getLocalTimeFromString(@Nullable String string, @Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull(dateTimeFormatter, "DateTimeFormatter");
        if (StringHelper.hasText(string)) {
            try {
                return dateTimeFormatter.parse((CharSequence)string, LocalTime::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                PDTFromString._onParseException("LocalTime", string, dateTimeFormatter, dateTimeParseException);
            }
        }
        return null;
    }

    @Nullable
    public static LocalTime getLocalTimeFromString(@Nullable String string, @Nonnull String string2) {
        return PDTFromString.getLocalTimeFromString(string, PDTFormatter.getForPattern(string2, null));
    }

    @Nullable
    public static Duration getDurationFromString(@Nullable String string) {
        try {
            return Duration.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            PDTFromString._onParseException("Duration", string, null, dateTimeParseException);
            return null;
        }
    }

    @Nullable
    public static Period getPeriodFromString(@Nullable String string) {
        try {
            return Period.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            PDTFromString._onParseException("Period", string, null, dateTimeParseException);
            return null;
        }
    }
}

