/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.dataloaders;

import cn.dalgen.mybatis.gen.common.FileNameSelector;
import cn.dalgen.mybatis.gen.dataloaders.AbstractDalgenLoader;
import cn.dalgen.mybatis.gen.enums.MultiplicityEnum;
import cn.dalgen.mybatis.gen.enums.PagingCntTypeEnum;
import cn.dalgen.mybatis.gen.enums.ParamTypeEnum;
import cn.dalgen.mybatis.gen.enums.TypeMapEnum;
import cn.dalgen.mybatis.gen.model.Gen;
import cn.dalgen.mybatis.gen.model.config.CfColumn;
import cn.dalgen.mybatis.gen.model.config.CfOperation;
import cn.dalgen.mybatis.gen.model.config.CfResultMap;
import cn.dalgen.mybatis.gen.model.config.CfTable;
import cn.dalgen.mybatis.gen.model.dbtable.Column;
import cn.dalgen.mybatis.gen.model.dbtable.Table;
import cn.dalgen.mybatis.gen.model.java.Base;
import cn.dalgen.mybatis.gen.model.java.DAO;
import cn.dalgen.mybatis.gen.model.java.DO;
import cn.dalgen.mybatis.gen.model.java.DOMapper;
import cn.dalgen.mybatis.gen.model.java.Filelds;
import cn.dalgen.mybatis.gen.model.java.Paging;
import cn.dalgen.mybatis.gen.model.java.ResultMap;
import cn.dalgen.mybatis.gen.model.java.XmlMapper;
import cn.dalgen.mybatis.gen.model.java.domapper.DOMapperMethod;
import cn.dalgen.mybatis.gen.model.java.domapper.DOMapperMethodParam;
import cn.dalgen.mybatis.gen.model.repository.CfTableRepository;
import cn.dalgen.mybatis.gen.model.repository.IgnoreDTDEntityResolver;
import cn.dalgen.mybatis.gen.model.repository.TableRepository;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import cn.dalgen.mybatis.gen.utils.StringDalUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.EntityResolver;

public class DalgenLoader
extends AbstractDalgenLoader {
    private static final Log LOG = new SystemStreamLog();
    private static final String RESULT_MANY = "List<{0}>";
    private TableRepository tableRepository = new TableRepository();
    private CfTableRepository cfTableRepository = new CfTableRepository();

    @Override
    public void load(Gen gen, Connection connection, File tablesFile) throws Exception {
        String cmd = ConfigUtil.getCmd();
        HashMap cfTableMap = Maps.newHashMap();
        HashMap xmltableMap = Maps.newHashMap();
        HashMap cfSqlMap = Maps.newHashMap();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        for (File tableFile : tablesFile.listFiles(new FileNameSelector("xml"))) {
            Document document = saxReader.read(tableFile);
            DefaultElement tableElement = (DefaultElement)document.getRootElement();
            String tableName = StringUtils.upperCase((String)tableElement.attributeValue("sqlname"));
            xmltableMap.put(tableName, tableElement);
            List sqlElements = tableElement.elements("sql");
            if (!CollectionUtils.isNotEmpty((Collection)sqlElements)) continue;
            for (Object sqlElement : sqlElements) {
                cfSqlMap.put(tableName + "." + sqlElement.attributeValue("id"), sqlElement);
            }
        }
        for (Map.Entry entry : xmltableMap.entrySet()) {
            cfTableMap.put(entry.getKey(), this.cfTableRepository.gainCfTable((DefaultElement)entry.getValue(), cfSqlMap));
        }
        gen.setTmpCfTables(Lists.newArrayList(cfTableMap.values()));
        for (String string : cfTableMap.keySet()) {
            Table table = this.tableRepository.gainTable(connection, string, (CfTable)cfTableMap.get(string));
            gen.addTmpTable(table);
        }
        List<String> needGenTableNames = this.preNeedGenTableNames(cmd, cfTableMap);
        HashMap hashMap = Maps.newHashMap();
        for (String tbName : needGenTableNames) {
            hashMap.put(StringUtils.upperCase((String)tbName), this.tableRepository.gainTable(connection, tbName, (CfTable)cfTableMap.get(tbName)));
        }
        for (String tbName : needGenTableNames) {
            CfTable cfTable = (CfTable)cfTableMap.get(tbName);
            Table table = (Table)hashMap.get(tbName);
            DO doClass = this.preDo(table, cfTable.getColumns());
            gen.addDO(doClass);
            XmlMapper xmlMapper = new XmlMapper();
            HashMap tbColumMap = Maps.newHashMap();
            for (Column column : table.getColumnList()) {
                tbColumMap.put(column.getSqlName(), column);
            }
            HashMap fileldsMap = Maps.newHashMap();
            for (Filelds filelds : doClass.getFieldses()) {
                fileldsMap.put(filelds.getName(), filelds);
            }
            HashMap hashMap2 = Maps.newHashMap();
            this.preResultMap(gen, tbName, cfTable, table, xmlMapper, tbColumMap, fileldsMap, hashMap2);
            xmlMapper.setSqlMap(cfTable.getSqlMap());
            DOMapper doMapper = this.preDOMapper(gen, cfTable, table, doClass, hashMap2);
            gen.addDOMapper(doMapper);
            DAO dao = this.preDAO(gen, cfTable, table, doClass, hashMap2);
            this.getClassAndImport(dao, doMapper.getPackageName() + "." + doMapper.getClassName(), "load1");
            this.getClassAndImport(doClass, doClass.getPackageName() + "." + doClass.getClassName(), "load2");
            dao.setDoMapper(doMapper);
            dao.setaDo(doClass);
            gen.addDao(dao);
            this.replaceRefid(cfSqlMap, cfTable, doMapper);
            xmlMapper.setCfTable(cfTable);
            xmlMapper.setDoClass(doClass);
            xmlMapper.setDoMapper(doMapper);
            xmlMapper.setTable(table);
            gen.addXmlMapper(xmlMapper);
        }
    }

    private void replaceRefid(Map<String, Element> cfSqlMap, CfTable cfTable, DOMapper doMapper) {
        if (CollectionUtils.isNotEmpty(cfTable.getOperations())) {
            for (CfOperation cfOperation : cfTable.getOperations()) {
                String cdata = cfOperation.getCdata();
                if (MapUtils.isNotEmpty(cfSqlMap)) {
                    for (String otTableRefid : cfSqlMap.keySet()) {
                        String[] splits = StringUtils.split((String)otTableRefid, (String)".", (int)2);
                        String className = null;
                        String logicName = splits[0];
                        String _pre = "";
                        for (String pre : ConfigUtil.getCurrentDb().getTablePrefixs().keySet()) {
                            if (!StringUtils.startsWith((String)logicName, (String)StringUtils.upperCase((String)pre)) || pre.length() <= _pre.length()) continue;
                            _pre = pre;
                        }
                        if (StringUtils.isNotBlank((String)_pre)) {
                            String toTableName = ConfigUtil.getCurrentDb().getTablePrefixs().get(_pre) + StringUtils.substring((String)logicName, (int)_pre.length());
                            className = CamelCaseUtils.toCapitalizeCamelCase(toTableName);
                        }
                        if (StringUtils.isBlank(className)) {
                            className = CamelCaseUtils.toCapitalizeCamelCase(logicName);
                        }
                        String relNameSpace = doMapper.getPackageName() + "." + className + "DOMapper";
                        cdata = cdata.replaceAll("refid=\"" + otTableRefid, "refid=\"" + relNameSpace + "." + splits[1]);
                    }
                }
                cfOperation.setCdata(cdata);
            }
        }
    }

    private List<String> preNeedGenTableNames(String cmd, Map<String, CfTable> cfTableMap) {
        ArrayList needGenTableNames = Lists.newArrayList();
        if (StringUtils.equals((String)StringUtils.trim((String)cmd), (String)"*")) {
            needGenTableNames = Lists.newArrayList(cfTableMap.keySet());
        } else {
            for (String tableName : Lists.newArrayList((Object[])StringUtils.split((String)StringUtils.upperCase((String)cmd), (String)";"))) {
                boolean flag = true;
                for (String splitTableSuffix : ConfigUtil.getConfig().getSplitTableSuffixs()) {
                    if (!StringUtils.endsWithIgnoreCase((String)tableName, (String)splitTableSuffix)) continue;
                    needGenTableNames.add(StringUtils.replace((String)tableName, (String)splitTableSuffix, (String)""));
                    flag = false;
                    break;
                }
                if (!flag) continue;
                needGenTableNames.add(tableName);
            }
        }
        return needGenTableNames;
    }

    private void preResultMap(Gen gen, String tbName, CfTable cfTable, Table table, XmlMapper xmlMapper, Map<String, Column> tbColumMap, Map<String, Filelds> fileldsMap, Map<String, ResultMap> resultMaps) {
        for (CfResultMap cfResultMap : cfTable.getResultMaps()) {
            ResultMap resultMap = new ResultMap();
            resultMap.setTableName(table.getSqlName());
            resultMap.setName(cfResultMap.getName());
            resultMap.setType(cfResultMap.getType());
            resultMap.setExtend(cfResultMap.getExtend());
            resultMap.setClassName(cfResultMap.getType());
            resultMap.setPackageName(ConfigUtil.getCurrentDb().getGenPackage("resultmap"));
            resultMap.setDesc(cfResultMap.getRemark());
            if (CollectionUtils.isNotEmpty(cfResultMap.getImports())) {
                for (String classz : cfResultMap.getImports()) {
                    resultMap.addImport(classz);
                }
            }
            for (CfColumn cfColumn : cfResultMap.getColumns()) {
                Validate.notEmpty((String)cfColumn.getName(), (String)(tbName + "xml \u914d\u7f6e\u6709\u8bef DalgenLoader.preResultMap Gen=" + gen));
                Column column = new Column();
                column.setJavaName(CamelCaseUtils.toCamelCase(cfColumn.getName()));
                column.setJavaType(cfColumn.getJavatype());
                column.setSqlName(cfColumn.getName());
                column.setSqlType(cfColumn.getSqlType());
                column.setTestVal(cfColumn.getTestVal());
                column.setRemarks(cfColumn.getRemark());
                resultMap.addColumn(column);
                resultMap.addImport(cfColumn.getJavatype());
                Filelds filelds = new Filelds();
                filelds.setJavaType(this.getClassAndImport(resultMap, column.getJavaType(), column.getSqlName()));
                filelds.setName(column.getJavaName());
                filelds.setDesc(column.getRemarks());
                filelds.setTestVal(cfColumn.getTestVal());
                resultMap.addFields(filelds);
            }
            resultMap.setAssociations(cfResultMap.getAssociations());
            resultMap.setCollections(cfResultMap.getCollections());
            resultMaps.put(cfResultMap.getName(), resultMap);
            xmlMapper.addResultMap(resultMap);
            gen.addResultMap(resultMap);
        }
    }

    private DAO preDAO(Gen gen, CfTable cfTable, Table table, DO doClass, Map<String, ResultMap> resultMaps) {
        DAO dao = new DAO();
        dao.setClassName(table.getJavaName() + "DAO");
        dao.setPackageName(ConfigUtil.getCurrentDb().getGenPackage("dao"));
        dao.setDesc(cfTable.getRemark());
        dao.setTableName(cfTable.getSqlname());
        HashMap columnTypeMap = Maps.newHashMap();
        HashMap columnDescMap = Maps.newHashMap();
        for (Column column : table.getColumnList()) {
            columnTypeMap.put(column.getJavaName(), column.getJavaType());
            columnDescMap.put(column.getJavaName(), column.getRemarks());
        }
        for (CfOperation operation : cfTable.getOperations()) {
            this.preDAOMethod(doClass, resultMaps, dao, operation, columnTypeMap, cfTable.getOperations());
        }
        return dao;
    }

    private void preDAOMethod(DO doClass, Map<String, ResultMap> resultMaps, DAO dao, CfOperation operation, Map<String, String> columnMap, List<CfOperation> cfOperations) {
        String resultType;
        DOMapperMethod method = new DOMapperMethod();
        method.setName(operation.getName());
        method.setDesc(operation.getRemark());
        method.setSql(operation.getSqlDesc());
        if (CollectionUtils.isNotEmpty(cfOperations)) {
            for (CfOperation cfOperation : cfOperations) {
                if (!StringUtils.equals((String)operation.getName(), (String)cfOperation.getPagingCntOperation())) continue;
                return;
            }
        }
        if (operation.getMultiplicity() == MultiplicityEnum.paging) {
            Paging paging = new Paging();
            paging.setClassName(StringDalUtil.upperFirst(operation.getPaging()) + "Page");
            paging.setPackageName(ConfigUtil.getCurrentDb().getGenPackage("paging"));
            resultType = this.getClassAndImport(dao, paging.getPackageName() + "." + paging.getClassName(), operation.getName());
            DOMapperMethodParam param = new DOMapperMethodParam(resultType, StringDalUtil.lowerFirst(operation.getPaging()), null);
            method.setPagingFlag("true");
            if (operation.getPagingCntType() == PagingCntTypeEnum.pagingCustom) {
                method.setPagingCustomFlag("true");
            }
            method.setPagingCntOperation(operation.getPagingCntOperation());
            method.addParam(param);
        } else {
            this.preMethodParam(doClass, dao, operation, method, columnMap, null);
            resultType = this.operationResultType(doClass, dao, operation, resultMaps);
        }
        method.setReturnClass(resultType);
        method.setKvMap(operation.getKvMap());
        if (!StringUtils.equals((String)method.getKvMap(), (String)"false")) {
            method.setMapV(operation.getMapV());
            method.setMapK(operation.getMapK());
            method.setMapKType(this.getClassAndImport(dao, this.trunColunType(operation.getMapK(), resultMaps.get(operation.getResultmap()), columnMap), operation.getName()));
            method.setMapVType(this.getClassAndImport(dao, this.trunColunType(operation.getMapV(), resultMaps.get(operation.getResultmap()), columnMap), operation.getName()));
            this.getClassAndImport(dao, "java.util.Map", operation.getName());
            this.getClassAndImport(dao, "java.util.Set", operation.getName());
            this.getClassAndImport(dao, "java.util.List", operation.getName());
            this.getClassAndImport(dao, "java.util.LinkedHashMap", operation.getName());
            this.getClassAndImport(dao, "java.util.ArrayList", operation.getName());
            this.getClassAndImport(dao, "java.util.HashSet", operation.getName());
        }
        dao.addMothed(method);
    }

    private String trunColunType(String columnName, ResultMap resultMap, Map<String, String> columnMap) {
        String result = null;
        if (StringUtils.isNotBlank((String)columnName)) {
            if (resultMap != null) {
                List<Column> columnList = resultMap.getColumnList();
                for (Column column : columnList) {
                    if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)columnName)) continue;
                    result = column.getJavaType();
                    break;
                }
            }
            if (resultMap == null || StringUtils.isBlank(result)) {
                String columnType = columnMap.get(CamelCaseUtils.toCamelCase(columnName));
                String custJavaType = ConfigUtil.getConfig().getTypeMap().get(columnType);
                result = StringUtils.isNotBlank((String)custJavaType) ? custJavaType : columnType;
            }
        }
        return result;
    }

    private DOMapper preDOMapper(Gen gen, CfTable cfTable, Table table, DO doClass, Map<String, ResultMap> resultMaps) {
        DOMapper doMapper = new DOMapper();
        if (StringUtils.equals((String)"DO", (String)ConfigUtil.getConfig().getExtParam("DoMapperName"))) {
            doMapper.setClassName(doClass.getClassName() + "Mapper");
        } else {
            doMapper.setClassName(table.getJavaName() + "Mapper");
        }
        doMapper.setPackageName(ConfigUtil.getCurrentDb().getGenPackage("mapper"));
        doMapper.setXmlPackageName(ConfigUtil.getCurrentDb().getGenPackage("mapper.xml"));
        doMapper.setDesc(cfTable.getRemark());
        doMapper.setTableName(cfTable.getSqlname());
        HashMap columnTypeMap = Maps.newHashMap();
        HashMap columnDescMap = Maps.newHashMap();
        for (Column column : table.getColumnList()) {
            columnTypeMap.put(column.getJavaName(), column.getJavaType());
            columnDescMap.put(column.getJavaName(), column.getRemarks());
        }
        for (CfOperation operation : cfTable.getOperations()) {
            if (operation.getMultiplicity() == MultiplicityEnum.paging) {
                this.prePagingMethod(gen, cfTable, table, doClass, resultMaps, doMapper, columnTypeMap, columnDescMap, operation);
                continue;
            }
            this.preMethod(doClass, resultMaps, doMapper, operation, columnTypeMap, cfTable.getOperations());
        }
        return doMapper;
    }

    private void prePagingMethod(Gen gen, CfTable cfTable, Table table, DO doClass, Map<String, ResultMap> resultMaps, DOMapper doMapper, Map<String, String> columnTypeMap, Map<String, String> columnDescMap, CfOperation operation) {
        DOMapperMethod pagingResultMethod = new DOMapperMethod();
        pagingResultMethod.setName(operation.getName() + "Result");
        pagingResultMethod.setPagingName(operation.getName());
        pagingResultMethod.setDesc(operation.getRemark());
        pagingResultMethod.setSql(operation.getSqlDesc());
        pagingResultMethod.setPagingFlag("true");
        pagingResultMethod.setPagingCntOperation(operation.getPagingCntOperation());
        Paging paging = new Paging();
        paging.setClassName(StringDalUtil.upperFirst(operation.getPaging()) + "Page");
        paging.setPackageName(ConfigUtil.getCurrentDb().getGenPackage("paging"));
        String basePackage = ConfigUtil.getCurrentDb().getGenDalCommonPackage() + "." + ConfigUtil.getCurrentDb().getSubPackage("paging");
        if (StringUtils.startsWith((String)ConfigUtil.getCurrentDb().getSubPackage("paging"), (String)"/")) {
            basePackage = StringUtils.substring((String)ConfigUtil.getCurrentDb().getSubPackage("paging"), (int)1);
        }
        paging.setBasePackageName(basePackage);
        this.getClassAndImport(paging, paging.getBasePackageName() + ".BasePage", paging.getClassName());
        paging.setDesc(StringDalUtil.join(table.getSqlName(), cfTable.getRemark()));
        paging.setTableName(cfTable.getSqlname());
        String pagingResultType = this.operationResultType(doClass, paging, operation, resultMaps);
        paging.setResultType(pagingResultType);
        List<DOMapperMethodParam> params = this.preMethodParams(paging, operation, columnTypeMap);
        for (DOMapperMethodParam param : params) {
            Filelds filelds = new Filelds();
            filelds.setName(param.getParam());
            filelds.setJavaType(param.getParamType());
            filelds.setDesc(columnDescMap.get(param.getParam()));
            paging.addFields(filelds);
        }
        gen.addPaging(paging);
        this.getClassAndImport(doMapper, paging.getPackageName() + "." + paging.getClassName(), operation.getName());
        this.getClassAndImport(doMapper, "java.util.List", operation.getName());
        DOMapperMethodParam pagingParam = new DOMapperMethodParam(paging.getClassName(), StringDalUtil.lowerFirst(operation.getPaging()), null);
        pagingResultMethod.addParam(pagingParam);
        String resultType = this.operationResultType(doClass, doMapper, operation, resultMaps);
        paging.setResultType(resultType);
        pagingResultMethod.setReturnClass("List<" + resultType + ">");
        try {
            if (operation.getPagingCntType() != PagingCntTypeEnum.pagingCustom) {
                DOMapperMethod pagingCountMethod = (DOMapperMethod)BeanUtils.cloneBean((Object)pagingResultMethod);
                pagingCountMethod.setName(operation.getName() + "Count");
                pagingCountMethod.setReturnClass("int");
                doMapper.addMothed(pagingCountMethod);
            }
        }
        catch (Exception e) {
            LOG.error((CharSequence)"", (Throwable)e);
        }
        doMapper.addMothed(pagingResultMethod);
    }

    private void preMethod(DO doClass, Map<String, ResultMap> resultMaps, DOMapper doMapper, CfOperation operation, Map<String, String> columnMap, List<CfOperation> cfOperations) {
        DOMapperMethod method = new DOMapperMethod();
        method.setName(operation.getName());
        method.setDesc(operation.getRemark());
        method.setSql(operation.getSqlDesc());
        this.preMethodParam(doClass, doMapper, operation, method, columnMap, cfOperations);
        String resultType = this.operationResultType(doClass, doMapper, operation, resultMaps);
        method.setReturnClass(resultType);
        method.setKvMap(operation.getKvMap());
        if (!StringUtils.equals((String)method.getKvMap(), (String)"false")) {
            method.setMapV(operation.getMapV());
            method.setMapK(operation.getMapK());
            method.setMapKType(this.getClassAndImport(doMapper, this.trunColunType(operation.getMapK(), resultMaps.get(operation.getResultmap()), columnMap), operation.getName()));
            method.setMapVType(this.getClassAndImport(doMapper, this.trunColunType(operation.getMapV(), resultMaps.get(operation.getResultmap()), columnMap), operation.getName()));
            this.getClassAndImport(doMapper, "java.util.Map", operation.getName());
            this.getClassAndImport(doMapper, "java.util.List", operation.getName());
        }
        doMapper.addMothed(method);
    }

    private void preMethodParam(DO doClass, Base doMapper, CfOperation operation, DOMapperMethod method, Map<String, String> columnMap, List<CfOperation> cfOperations) {
        boolean isPagingCount = false;
        if (CollectionUtils.isNotEmpty(cfOperations)) {
            for (CfOperation cfOperation : cfOperations) {
                if (!StringUtils.equals((String)cfOperation.getPagingCntOperation(), (String)operation.getName())) continue;
                isPagingCount = true;
                method.addParam(new DOMapperMethodParam(StringDalUtil.upperFirst(cfOperation.getPaging()) + "Page", StringDalUtil.lowerFirst(cfOperation.getPaging()), null));
                break;
            }
        }
        if (!isPagingCount) {
            if (operation.getParamType() == ParamTypeEnum.object) {
                method.addParam(new DOMapperMethodParam(this.getClassAndImport(doMapper, doClass.getPackageName() + "." + doClass.getClassName(), "_preMethodParam"), "entity", null));
            } else if (operation.getParamType() == ParamTypeEnum.objectList) {
                this.getClassAndImport(doMapper, doClass.getPackageName() + "." + doClass.getClassName(), operation.getName());
                this.getClassAndImport(doMapper, "java.util.List", operation.getName());
                method.addParam(new DOMapperMethodParam("List<" + doClass.getClassName() + ">", "list", null));
            } else {
                method.setParams(this.preMethodParams(doMapper, operation, columnMap));
            }
        }
    }

    private List<DOMapperMethodParam> preMethodParams(Base doMapper, CfOperation operation, Map<String, String> columnMap) {
        ArrayList params = Lists.newArrayList();
        ArrayList foreachTmp = Lists.newArrayList();
        for (Map.Entry<String, String> pm : operation.getPrimitiveParams().entrySet()) {
            String pmName = pm.getKey();
            String pmType = pm.getValue();
            DOMapperMethodParam methodParam = null;
            if (StringUtils.contains((String)pmName, (String)".") || operation.getPrimitiveForeachOtherParams().containsKey("list_" + pmName)) {
                String[] splits = StringUtils.split((String)pmName, (String)".");
                if (foreachTmp.contains(splits[0])) continue;
                foreachTmp.add(splits[0]);
                List<String> foreachName_javaType = operation.getPrimitiveForeachOtherParams().get("list_" + splits[0]);
                if (CollectionUtils.isNotEmpty(foreachName_javaType)) {
                    String foreachJavaType = this.getClassAndImport(doMapper, foreachName_javaType.get(1), "_preMethodParams");
                    this.getClassAndImport(doMapper, "java.util.List", "_preMethodParams");
                    methodParam = new DOMapperMethodParam("List<" + foreachJavaType + ">", foreachName_javaType.get(0), operation.getPrimitiveParamTestVals().get(pmName));
                }
            } else {
                TypeMapEnum typeMapEnum;
                String columnType = columnMap.get(pmName);
                if (StringUtils.startsWith((String)pmName, (String)"old")) {
                    String xpnName = pmName.substring(3);
                    columnType = columnMap.get(xpnName.substring(0, 1).toLowerCase() + xpnName.substring(1));
                }
                String paramValType = (typeMapEnum = TypeMapEnum.getByJdbcTypeWithOther(pmType)) == TypeMapEnum.OTHER ? pmType : (StringUtils.isBlank((String)columnType) ? typeMapEnum.getJavaType() : columnType);
                String custJavaType = ConfigUtil.getConfig().getTypeMap().get(paramValType);
                String paramType = this.getClassAndImport(doMapper, custJavaType == null ? paramValType : custJavaType, operation.getName() + "_" + pmName);
                String foreachName = operation.getPrimitiveForeachParams().get(pmName);
                if (StringUtils.isBlank((String)foreachName)) {
                    methodParam = new DOMapperMethodParam(paramType, pmName, operation.getPrimitiveParamTestVals().get(pmName));
                } else if (!StringUtils.contains((String)foreachName, (String)".")) {
                    this.getClassAndImport(doMapper, "java.util.List", "_preMethodParams");
                    methodParam = new DOMapperMethodParam("List<" + paramType + ">", foreachName, operation.getPrimitiveParamTestVals().get(pmName));
                }
            }
            if (methodParam == null) continue;
            params.add(methodParam);
        }
        return params;
    }

    private String operationResultType(DO doClass, Base base, CfOperation operation, Map<String, ResultMap> resultMaps) {
        String resultType;
        if (StringUtils.startsWithIgnoreCase((String)operation.getName(), (String)"insert") || StringUtils.startsWithIgnoreCase((String)operation.getName(), (String)"update") || StringUtils.startsWithIgnoreCase((String)operation.getName(), (String)"delete")) {
            if (StringUtils.isNotBlank((String)ConfigUtil.getConfig().getExtParam("IUD"))) {
                return ConfigUtil.getConfig().getExtParam("IUD");
            }
            return "int";
        }
        if (!StringUtils.isBlank((String)operation.getResulttype())) {
            resultType = this.getClassAndImport(base, operation.getResulttype(), operation.getName());
        } else if (!StringUtils.isBlank((String)operation.getResultmap())) {
            ResultMap resultMap = resultMaps.get(operation.getResultmap());
            Validate.notNull((Object)resultMap, (String)("DalgenLoader.operationResultType \u81ea\u5b9a\u4e49ResultMap\u51fa\u9519 table = " + doClass.getTableName() + " DO=" + doClass));
            resultType = this.getClassAndImport(base, resultMap.getPackageName() + "." + resultMap.getClassName(), operation.getName());
        } else {
            resultType = this.getClassAndImport(base, doClass.getPackageName() + "." + doClass.getClassName(), operation.getName());
        }
        if (MultiplicityEnum.many == operation.getMultiplicity()) {
            base.addImport("java.util.List");
            return MessageFormat.format(RESULT_MANY, resultType);
        }
        return resultType;
    }

    private DO preDo(Table table, List<CfColumn> cfColumns) {
        DO doClass = new DO();
        doClass.setClassName(table.getJavaName() + "DO");
        doClass.setPackageName(ConfigUtil.getCurrentDb().getGenPackage("dataobject"));
        doClass.setDesc(table.getRemark());
        doClass.setTableName(table.getSqlName());
        ArrayList rldcList = Lists.newArrayList();
        for (CfColumn cfColumn : cfColumns) {
            if (StringUtils.isBlank((String)cfColumn.getRelatedColumn())) continue;
            rldcList.add(cfColumn.getRelatedColumn());
        }
        for (Column column : table.getColumnList()) {
            if (rldcList.contains(column.getSqlName())) continue;
            Filelds filelds = new Filelds();
            filelds.setName(column.getJavaName());
            filelds.setDesc(column.getRemarks());
            filelds.setSqlName(column.getSqlName());
            filelds.setTestVal(column.getTestVal());
            filelds.setJavaType(this.getClassAndImport(doClass, column.getJavaType(), column.getSqlName()));
            doClass.addFields(filelds);
        }
        return doClass;
    }

    private String getClassAndImport(Base base, String classType, String clumnOrOption) {
        if (StringUtils.isBlank((String)classType)) {
            return null;
        }
        int lastIdx = StringUtils.lastIndexOf((String)classType, (String)".");
        if (lastIdx > 0) {
            base.addImport(classType);
        }
        if (classType.indexOf("<") > 0 && classType.indexOf(".") > 0) {
            String _importClass = classType.substring(0, classType.indexOf("<"));
            _importClass = StringUtils.substring((String)_importClass, (int)(StringUtils.lastIndexOf((String)_importClass, (String)".") + 1));
            String __importClass = classType.substring(classType.indexOf("<") + 1, classType.indexOf(">"));
            if (StringUtils.isNotBlank((String)__importClass) && __importClass.contains(".")) {
                __importClass = StringUtils.substring((String)__importClass, (int)(StringUtils.lastIndexOf((String)__importClass, (String)".") + 1));
            }
            return _importClass + "<" + __importClass + ">";
        }
        return StringUtils.substring((String)classType, (int)(lastIdx + 1));
    }
}

