/*
 * Decompiled with CFR 0.152.
 */
package wiki.primo.generator.mock.test.maven.plugin;

import com.alibaba.fastjson.JSON;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import wiki.primo.generator.mock.test.core.constant.CommonConstant;
import wiki.primo.generator.mock.test.core.util.PackageUtils;
import wiki.primo.generator.mock.test.core.util.StringUtils;
import wiki.primo.generator.mock.test.data.info.JavaClassInfo;
import wiki.primo.generator.mock.test.maven.plugin.DownFile;
import wiki.primo.generator.mock.test.maven.plugin.GenJava;
import wiki.primo.generator.mock.test.maven.plugin.base.AbstractPlugin;

@Mojo(name="test")
public class UnittestPlugin
extends AbstractPlugin {
    @Parameter
    private String testPackageName;
    @Parameter(defaultValue="")
    private String author;
    @Parameter(defaultValue="true")
    private Boolean isGetChildPackage;
    @Parameter(defaultValue="true")
    private Boolean isMockThisOtherMethod;
    @Parameter(defaultValue="false")
    private Boolean isSetBasicTypesRandomValue;
    @Parameter(defaultValue="10")
    private String setStringRandomRange;
    @Parameter(defaultValue="0,1000")
    private String setIntRandomRange;
    @Parameter(defaultValue="0,10000")
    private String setLongRandomRange;
    @Parameter(defaultValue="true,false")
    private String setBooleanRandomRange;

    public static void main(String[] args) throws IOException {
        UnittestPlugin.builder();
    }

    private static void builder() throws IOException {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        builder.addSource(new File("/Users/chenhx/Desktop/github/auto-generate-test-maven-plugin/agt-core/src/main/java/com/uifuture/maven/plugins/core/model/JavaClassModel.java"));
        JavaClass javaClass1 = builder.getClassByName("JavaClassModel");
        JavaClass javaClass2 = builder.getClassByName("com.uifuture.maven.plugins.returnData.model.JavaClassModel");
        System.out.println(javaClass1 + "====" + javaClass2);
        JavaClass javaClass3 = builder.getClassByName("JavaProjectBuilder");
        JavaClass javaClass4 = builder.getClassByName("com.thoughtworks.qdox.JavaProjectBuilder");
        System.out.println(javaClass3 + "====" + javaClass4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<String> javaList;
            super.execute();
            this.init();
            this.getLog().info((CharSequence)("\u6570\u636e\u521d\u59cb\u5316\u540e\uff0c\u5f00\u59cb\u751f\u6210\u81ea\u52a8\u5316\u6d4b\u8bd5\u4ee3\u7801\n\u5f00\u53d1\u8005\u7684\u914d\u7f6e\u6570\u636e\uff1a" + CommonConstant.CONFIG_ENTITY));
            if (!this.paramCheck()) {
                return;
            }
            HashMap javaListMap = new HashMap();
            this.testPackageName = this.testPackageName.trim();
            if (this.testPackageName.endsWith(".java")) {
                javaList = new ArrayList();
                this.testPackageName = this.testPackageName.substring(0, this.testPackageName.lastIndexOf(".java"));
                String string = this.basedir + "/src/main/java/" + this.testPackageName.replace(".", "/") + ".java";
                this.getLog().info((CharSequence)("\u5f85\u751f\u6210\u5355\u5143\u6d4b\u8bd5\u7c7b\u4ee3\u7801\u7684\u7c7b\u8def\u5f84\u4e3a\uff1a" + string));
                javaList.add(string);
                javaListMap.put(this.testPackageName.substring(0, this.testPackageName.lastIndexOf(".")), javaList);
            } else if (this.testPackageName.contains(";")) {
                String[] packageNames;
                for (String packageName : packageNames = this.testPackageName.split(";")) {
                    if (StringUtils.isEmpty((CharSequence)packageName)) continue;
                    packageName = packageName.replaceAll("\\r|\\n", "").trim();
                    List javaList2 = PackageUtils.getClassName((String)this.basedir.getPath(), (String)packageName, (boolean)this.isGetChildPackage);
                    javaListMap.put(packageName, javaList2);
                }
            } else {
                javaList = PackageUtils.getClassName((String)this.basedir.getPath(), (String)this.testPackageName, (boolean)this.isGetChildPackage);
                javaListMap.put(this.testPackageName, javaList);
            }
            for (String string : javaListMap.keySet()) {
                List javaList3 = (List)javaListMap.get(string);
                this.getLog().info((CharSequence)("\u5f53\u524d\u904d\u5386\u7684\u5305\u540d\u4e3a\uff1a" + string));
                for (String javaNamePath : javaList3) {
                    this.getLog().info((CharSequence)("\u5f53\u524djava\u6587\u4ef6\u7684\u7edd\u5bf9\u8def\u5f84\u4e3a\uff1a" + javaNamePath));
                    if (javaNamePath.endsWith("$1")) {
                        this.getLog().info((CharSequence)("\u8df3\u8fc7\u5185\u90e8\u7c7b\u7684\u751f\u6210:" + javaNamePath));
                        continue;
                    }
                    JavaClassInfo javaClassInfo = new JavaClassInfo();
                    javaClassInfo.setPackageName(string);
                    javaClassInfo.setAbsolutePath(javaNamePath);
                    javaClassInfo.setFullyTypeName(javaClassInfo.getPackageName() + "." + javaClassInfo.getTypeName());
                    String testJavaName = CommonConstant.CONFIG_ENTITY.getBasedir() + "/src/test/java/" + javaClassInfo.getPackageName().replace(".", "/") + "/" + javaClassInfo.getTypeName() + "Test" + ".java";
                    javaClassInfo.setTestAbsolutePath(testJavaName);
                    this.getLog().info((CharSequence)("\u751f\u6210\u7684\u7c7b\u4fe1\u606fjavaClassInfo\uff1a" + JSON.toJSONString((Object)javaClassInfo)));
                    GenJava.genTest(javaClassInfo);
                }
            }
        }
        finally {
            DownFile.removeTemplateFile();
        }
    }

    private void init() {
        CommonConstant.CONFIG_ENTITY.setTestPackageName(this.testPackageName);
        CommonConstant.CONFIG_ENTITY.setAuthor(this.author);
        CommonConstant.CONFIG_ENTITY.setIsGetChildPackage(this.isGetChildPackage);
        CommonConstant.CONFIG_ENTITY.setIsMockThisOtherMethod(this.isMockThisOtherMethod);
        CommonConstant.CONFIG_ENTITY.setIsSetBasicTypesRandomValue(this.isSetBasicTypesRandomValue);
        CommonConstant.CONFIG_ENTITY.setSetStringRandomRange(this.setStringRandomRange);
        CommonConstant.CONFIG_ENTITY.setSetBooleanRandomRange(this.setBooleanRandomRange);
        CommonConstant.CONFIG_ENTITY.setSetIntRandomRange(this.setIntRandomRange);
        CommonConstant.CONFIG_ENTITY.setSetLongRandomRange(this.setLongRandomRange);
        DownFile.downJsonFile();
        DownFile.downTemplateFile();
        this.initJavaProjectBuilder();
    }

    private boolean paramCheck() {
        if (StringUtils.isEmpty((CharSequence)this.testPackageName)) {
            this.getLog().error((CharSequence)"testPackageName\u5fc5\u987b\u8fdb\u884c\u914d\u7f6e\uff08\u9700\u8981\u6d4b\u8bd5\u7684\u9879\u76ee\u5305\u540d\uff09");
            return false;
        }
        return true;
    }

    private void initJavaProjectBuilder() {
        String mainJava = this.basedir.getPath() + "/src/main/java/";
        CommonConstant.javaProjectBuilder.addSourceTree(new File(mainJava));
        this.getLog().info((CharSequence)("\u52a0\u8f7d\u5f53\u524d\u6a21\u5757\u7684\u7c7b\uff1a" + mainJava));
        String testJava = this.basedir.getPath() + "/src/test/java/";
        CommonConstant.javaProjectBuilder.addSourceTree(new File(testJava));
        this.getLog().info((CharSequence)("\u52a0\u8f7d\u5f53\u524d\u6a21\u5757\u7684\u6d4b\u8bd5\u7c7b\uff1a" + testJava));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            CommonConstant.javaProjectBuilder.addClassLoader(loader);
        }
    }
}

