/*
 * Decompiled with CFR 0.152.
 */
package wiki.primo.generator.mock.test.maven.plugin;

import com.alibaba.fastjson.JSON;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import wiki.primo.generator.mock.test.core.build.impl.BuildClassImpl;
import wiki.primo.generator.mock.test.core.constant.CommonConstant;
import wiki.primo.generator.mock.test.core.util.StringUtils;
import wiki.primo.generator.mock.test.core.util.UUIDUtils;
import wiki.primo.generator.mock.test.data.config.json.JsonConfig;
import wiki.primo.generator.mock.test.data.config.json.JsonConfigList;
import wiki.primo.generator.mock.test.data.dto.JavaClassDTO;
import wiki.primo.generator.mock.test.data.info.JavaClassInfo;

public class GenJava {
    private static Log log = new SystemStreamLog();

    public static void main(String[] args) {
        String json = "{\n  \"isOpen\": false,\n  \"list\":\n  [\n    {\n      \"scope\":\"\u4f5c\u7528\u57df\uff1a\u5168\u5c40\uff08global\uff09\u3001\u5305\uff08package\uff09\u3001\u7c7b\uff08class\uff09\u3001\u65b9\u6cd5\uff08method\uff09 - \u9ed8\u8ba4\u5168\u5c40\",\n      \"scopeValue\": \"\u4f5c\u7528\u57df\u7684\u503c\uff0cglobal\u5219\u65e0\u9700\u914d\u7f6e\u8be5\u503c\uff0cpackage\u5219\u4e3a\u5305\u540d\uff0cclass\u5219\u4e3a\u7c7b\u540d\uff0cmethod\u5219\u4e3a\u65b9\u6cd5\u540d\",\n      \"type\": \"JavaBean\u7c7b\u578b\uff08custom\uff09/\u57fa\u7840\u7c7b\u578b\uff08base\uff09 - \u9ed8\u8ba4\u81ea\u5b9a\u4e49\u7c7b\u578b\",\n      \"name\": \"\u7c7b\u578b\u7684\u5168\u9650\u5b9a\u540d\u79f0\",\n      \"value\":{\n        \"\u82e5type=base\uff0c\u5219\u8be5\u503c\u56fa\u5b9a\u4e3avalue\":\"\u503c\",\n        \"\u82e5type=custom\uff0c\u81ea\u5b9a\u4e49\u7c7b\u578b\uff0cvalue\u4e0b\u7684json\u4e3afastjson\u5e8f\u5217\u5316\u7684json\u503c\":\"\u503c\"\n      }\n    }\n  ]\n}\n\n";
        JsonConfig jsonConfig = (JsonConfig)JSON.parseObject((String)json, JsonConfig.class);
        System.out.println(((JsonConfigList)jsonConfig.getList().get(0)).getValue());
        System.out.println(jsonConfig);
    }

    public static void genTest(JavaClassInfo javaClassInfo) {
        try {
            Configuration cfg = GenJava.getConfiguration();
            HashSet<String> testMethodNameSet = new HashSet<String>();
            boolean fileIsExists = false;
            File testFile = new File(javaClassInfo.getTestAbsolutePath());
            if (testFile.exists()) {
                log.info((CharSequence)(testFile + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8fdb\u884c\u7c7b\u65b9\u6cd5\u8ffd\u52a0\u751f\u6210"));
                String testClassName = javaClassInfo.getPackageName() + "." + javaClassInfo.getTypeName() + "Test";
                JavaClass testJavaClass = CommonConstant.javaProjectBuilder.getClassByName(testClassName);
                List javaMethodList = testJavaClass.getMethods();
                for (JavaMethod javaMethod : javaMethodList) {
                    testMethodNameSet.add(javaMethod.getName());
                    log.info((CharSequence)("\u83b7\u53d6\u6d4b\u8bd5\u7c7b\u7684\u65b9\u6cd5\u540d\u79f0:" + javaMethod.getName()));
                }
                log.info((CharSequence)("\u83b7\u53d6\u7684\u5df2\u7ecf\u751f\u6210\u7684\u7c7b\u65b9\u6cd5\u540d\u79f0\u4e3a:" + javaMethodList + ",\u6d4b\u8bd5\u7c7b\uff1a" + testClassName));
                fileIsExists = true;
            } else if (!testFile.getParentFile().exists() && !testFile.getParentFile().mkdirs()) {
                log.error((CharSequence)(testFile.getParentFile() + "\u6587\u4ef6\u7684\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u672c\u6b21\u751f\u6210\u5931\u8d25"));
                return;
            }
            JavaClassDTO javaClassDTO = BuildClassImpl.build((JavaClassInfo)javaClassInfo);
            if (javaClassDTO == null) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("javaClassDTO", javaClassDTO);
            if (!fileIsExists) {
                cfg.getTemplate(CommonConstant.CONFIG_ENTITY.getConfigFileName()).process(data, (Writer)new FileWriter(testFile));
                log.info((CharSequence)(testFile + "\u751f\u6210\u6210\u529f"));
            } else {
                File newFile = GenJava.fileIsExists(javaClassInfo.getTypeName(), cfg, testMethodNameSet, testFile, javaClassDTO, data, javaClassInfo);
                if (newFile == null) {
                    log.error((CharSequence)(javaClassInfo.getFullyTypeName() + " \u8ffd\u52a0\u65b9\u6cd5\u5931\u8d25"));
                    return;
                }
                log.info((CharSequence)(testFile + ", \u8ffd\u52a0\u65b9\u6cd5\u6210\u529f\uff0c\u751f\u6210\u7684\u4e34\u65f6\u6587\u4ef6:" + newFile));
            }
        }
        catch (Exception e) {
            log.error((CharSequence)"\u751f\u6210\u5931\u8d25\uff0c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private static File fileIsExists(String className, Configuration configuration, Set<String> testMethodNameSet, File file, JavaClassDTO javaClassDTO, Map<String, Object> data, JavaClassInfo javaClassInfo) throws TemplateException, IOException {
        String randId = UUIDUtils.getID();
        String testJavaName = CommonConstant.CONFIG_ENTITY.getBasedir() + "/src/test/java/" + javaClassInfo.getPackageName().replace(".", "/") + "/" + className + randId + "Test" + ".java";
        javaClassDTO.setModelNameUpperCamelTestClass(className + randId + "Test");
        javaClassDTO.setModelNameLowerCamelTestClass(StringUtils.strConvertLowerCamel((String)(className + randId + "Test")));
        File newFile = new File(testJavaName);
        if (!newFile.getParentFile().exists() && !newFile.getParentFile().mkdirs()) {
            log.error((CharSequence)(newFile.getParentFile() + "\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6743\u9650"));
            return null;
        }
        configuration.getTemplate(CommonConstant.CONFIG_ENTITY.getConfigFileName()).process(data, (Writer)new FileWriter(newFile));
        String newClassName = javaClassInfo.getPackageName() + "." + className + randId + "Test";
        log.info((CharSequence)("\u83b7\u53d6\u4e34\u65f6\u751f\u6210\u7684\u7c7b\u540d:" + newClassName));
        CommonConstant.javaProjectBuilder.addSourceTree(newFile);
        JavaClass testJavaClass = CommonConstant.javaProjectBuilder.getClassByName(newClassName);
        List javaMethodList = testJavaClass.getMethods();
        log.info((CharSequence)("\u83b7\u53d6\u7684\u65b9\u6cd5\u540d\u79f0:" + javaMethodList));
        for (JavaMethod javaMethod : javaMethodList) {
            if (!testMethodNameSet.contains(javaMethod.getName())) {
                String code = javaMethod.getSourceCode();
                log.debug((CharSequence)("\u83b7\u53d6\u8ffd\u52a0\u7684\u65b9\u6cd5\u6e90\u7801\u4e3a:" + code));
                String methodStr = "\n    @Test\n    public void " + javaMethod.getName() + "(){\n" + code + "\n    }\n}";
                FileReader fileReader = new FileReader(file);
                BufferedReader br = new BufferedReader(fileReader);
                String lineContent = null;
                ArrayList<String> oldFileStr = new ArrayList<String>();
                while ((lineContent = br.readLine()) != null) {
                    oldFileStr.add(lineContent);
                }
                br.close();
                fileReader.close();
                for (int i = oldFileStr.size() - 1; i >= 0; --i) {
                    String line = ((String)oldFileStr.get(i)).trim();
                    if (StringUtils.isEmpty((CharSequence)line)) continue;
                    if ("}".equals(line)) {
                        oldFileStr.remove(i);
                        break;
                    }
                    if (!line.endsWith("}")) continue;
                    oldFileStr.set(i, ((String)oldFileStr.get(i)).substring(0, ((String)oldFileStr.get(i)).lastIndexOf("}")));
                    break;
                }
                StringBuilder fileStr = new StringBuilder();
                for (String line : oldFileStr) {
                    fileStr.append(line).append("\n");
                }
                fileStr.append(methodStr);
                PrintStream ps = new PrintStream(new FileOutputStream(file));
                ps.println(fileStr);
                ps.close();
            }
            log.info((CharSequence)("\u83b7\u53d6\u4e34\u65f6\u6d4b\u8bd5\u7c7b\u7684\u65b9\u6cd5\u540d\u79f0:" + javaMethod.getName()));
        }
        if (!newFile.delete()) {
            log.error((CharSequence)("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6743\u9650\u3002\u6587\u4ef6:" + newFile));
        }
        return newFile;
    }

    private static Configuration getConfiguration() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        File file = new File(CommonConstant.CONFIG_ENTITY.getBasedir().getPath() + CommonConstant.CONFIG_ENTITY.getConfigPath());
        cfg.setDirectoryForTemplateLoading(file);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        return cfg;
    }
}

