/*
 * Decompiled with CFR 0.152.
 */
package wiki.primo.generator.mock.test.maven.plugin;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.InputStream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.springframework.core.io.ClassPathResource;
import wiki.primo.generator.mock.test.core.constant.CommonConstant;
import wiki.primo.generator.mock.test.core.util.FileUtils;
import wiki.primo.generator.mock.test.core.util.UUIDUtils;
import wiki.primo.generator.mock.test.data.config.json.JsonConfig;

public class DownFile {
    private static Log log = new SystemStreamLog();
    private static String tmpFtlFileName = "primo-generator-mock-test-" + UUIDUtils.getID() + ".ftl";

    public static void downTemplateFile() {
        if (!CommonConstant.CONFIG_ENTITY.getIsDownloadTemplateFile().booleanValue()) {
            CommonConstant.CONFIG_ENTITY.setConfigPath("");
            CommonConstant.CONFIG_ENTITY.setConfigFileName(tmpFtlFileName);
        }
        String configPath = CommonConstant.CONFIG_ENTITY.getConfigPath();
        String path = CommonConstant.CONFIG_ENTITY.getBasedir().getPath() + configPath;
        try {
            FileUtils.downLoadFile((String)CommonConstant.CONFIG_ENTITY.getConfigFileName(), (String)path, (String)"primo-generator-mock-test.ftl");
        }
        catch (Exception e) {
            log.error((CharSequence)"\u4e0b\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void removeTemplateFile() {
        if (!CommonConstant.CONFIG_ENTITY.getIsDownloadTemplateFile().booleanValue()) {
            String configPath = CommonConstant.CONFIG_ENTITY.getConfigPath();
            String path = CommonConstant.CONFIG_ENTITY.getBasedir().getPath() + configPath;
            File file = new File(path + File.separator + CommonConstant.CONFIG_ENTITY.getConfigFileName());
            if (file.exists()) {
                boolean delete = file.delete();
                if (!delete) {
                    log.error((CharSequence)("\u5220\u9664\u4e34\u65f6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u8def\u5f84\uff1a" + file.getPath() + ",\u6587\u4ef6\u540d\uff1a" + file.getName()));
                } else {
                    log.info((CharSequence)("\u5220\u9664\u4e34\u65f6\u914d\u7f6e\u6587\u4ef6\u6210\u529f\uff0c\u8def\u5f84\uff1a" + file.getPath() + ",\u6587\u4ef6\u540d\uff1a" + file.getName()));
                }
            }
        }
    }

    public static void downJsonFile() {
        try {
            String jsonStr = "";
            if (!CommonConstant.CONFIG_ENTITY.getIsDownloadJsonFile().booleanValue()) {
                ClassPathResource classPathResource = new ClassPathResource("primo-generator-mock-test.json");
                InputStream inputStream = classPathResource.getInputStream();
                jsonStr = FileUtils.readInputStreamToString((InputStream)inputStream);
            } else {
                String configPath = CommonConstant.CONFIG_ENTITY.getJsonConfigPath();
                String path = CommonConstant.CONFIG_ENTITY.getBasedir().getPath() + configPath;
                FileUtils.downLoadFile((String)CommonConstant.CONFIG_ENTITY.getJsonConfigFileName(), (String)path, (String)"primo-generator-mock-test.json");
                jsonStr = FileUtils.readFileToString((String)(path + File.separator + CommonConstant.CONFIG_ENTITY.getJsonConfigFileName()));
            }
            log.info((CharSequence)("\u8bfb\u53d6\u7684json\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e3a:" + jsonStr));
            JsonConfig jsonConfig = (JsonConfig)JSON.parseObject((String)jsonStr, JsonConfig.class);
            CommonConstant.CONFIG_ENTITY.setJsonConfig(jsonConfig);
        }
        catch (Exception e) {
            log.error((CharSequence)"\u4e0b\u8f7dJSON\u914d\u7f6e\u6587\u4ef6/\u8bfb\u53d6/\u89e3\u6790json\u5b9e\u4f53\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }
}

