/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.framework.engine.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.remote.framework.actor.ActorInfo;
import tech.powerjob.remote.framework.actor.Handler;
import tech.powerjob.remote.framework.actor.HandlerInfo;
import tech.powerjob.remote.framework.base.HandlerLocation;

class ActorFactory {
    private static final Logger log = LoggerFactory.getLogger(ActorFactory.class);

    ActorFactory() {
    }

    static List<ActorInfo> load(List<Object> actorList) {
        ArrayList actorInfos = Lists.newArrayList();
        actorList.forEach(actor -> {
            Class<?> clz = actor.getClass();
            try {
                Actor anno = clz.getAnnotation(Actor.class);
                ActorInfo actorInfo = new ActorInfo().setActor(actor).setAnno(anno);
                actorInfo.setHandlerInfos(ActorFactory.loadHandlerInfos4Actor(actorInfo));
                actorInfos.add(actorInfo);
            }
            catch (Throwable t) {
                log.error("[ActorFactory] process Actor[{}] failed!", clz);
                ExceptionUtils.rethrow((Throwable)t);
            }
        });
        return actorInfos;
    }

    private static List<HandlerInfo> loadHandlerInfos4Actor(ActorInfo actorInfo) {
        ArrayList ret = Lists.newArrayList();
        Actor anno = actorInfo.getAnno();
        String rootPath = anno.path();
        Object actor = actorInfo.getActor();
        ActorFactory.findHandlerMethod(rootPath, actor.getClass(), ret);
        return ret;
    }

    private static void findHandlerMethod(String rootPath, Class<?> clz, List<HandlerInfo> result) {
        Method[] declaredMethods;
        for (Method handlerMethod : declaredMethods = clz.getDeclaredMethods()) {
            Handler handlerMethodAnnotation = handlerMethod.getAnnotation(Handler.class);
            if (handlerMethodAnnotation == null) continue;
            HandlerLocation handlerLocation = new HandlerLocation().setRootPath(ActorFactory.suitPath(rootPath)).setMethodPath(ActorFactory.suitPath(handlerMethodAnnotation.path()));
            HandlerInfo handlerInfo = new HandlerInfo().setAnno(handlerMethodAnnotation).setMethod(handlerMethod).setLocation(handlerLocation);
            result.add(handlerInfo);
        }
        Class<?> superclass = clz.getSuperclass();
        if (superclass != null) {
            ActorFactory.findHandlerMethod(rootPath, superclass, result);
        }
    }

    static String suitPath(String path) {
        if (path.startsWith("/")) {
            return path.replaceFirst("/", "");
        }
        return path;
    }
}

