/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.SecurityPolicyOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedSecurityPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedSecurityPolicy> {
    private static final SdkField<Boolean> FIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Fips").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::fips)).setter(DescribedSecurityPolicy.setter(Builder::fips)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fips").build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::securityPolicyName)).setter(DescribedSecurityPolicy.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final SdkField<List<String>> SSH_CIPHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshCiphers").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshCiphers)).setter(DescribedSecurityPolicy.setter(Builder::sshCiphers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshCiphers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SSH_KEXS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshKexs").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshKexs)).setter(DescribedSecurityPolicy.setter(Builder::sshKexs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKexs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SSH_MACS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshMacs").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshMacs)).setter(DescribedSecurityPolicy.setter(Builder::sshMacs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshMacs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TLS_CIPHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TlsCiphers").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::tlsCiphers)).setter(DescribedSecurityPolicy.setter(Builder::tlsCiphers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCiphers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIPS_FIELD, SECURITY_POLICY_NAME_FIELD, SSH_CIPHERS_FIELD, SSH_KEXS_FIELD, SSH_MACS_FIELD, TLS_CIPHERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean fips;
    private final String securityPolicyName;
    private final List<String> sshCiphers;
    private final List<String> sshKexs;
    private final List<String> sshMacs;
    private final List<String> tlsCiphers;

    private DescribedSecurityPolicy(BuilderImpl builder) {
        this.fips = builder.fips;
        this.securityPolicyName = builder.securityPolicyName;
        this.sshCiphers = builder.sshCiphers;
        this.sshKexs = builder.sshKexs;
        this.sshMacs = builder.sshMacs;
        this.tlsCiphers = builder.tlsCiphers;
    }

    public final Boolean fips() {
        return this.fips;
    }

    public final String securityPolicyName() {
        return this.securityPolicyName;
    }

    public final boolean hasSshCiphers() {
        return this.sshCiphers != null && !(this.sshCiphers instanceof SdkAutoConstructList);
    }

    public final List<String> sshCiphers() {
        return this.sshCiphers;
    }

    public final boolean hasSshKexs() {
        return this.sshKexs != null && !(this.sshKexs instanceof SdkAutoConstructList);
    }

    public final List<String> sshKexs() {
        return this.sshKexs;
    }

    public final boolean hasSshMacs() {
        return this.sshMacs != null && !(this.sshMacs instanceof SdkAutoConstructList);
    }

    public final List<String> sshMacs() {
        return this.sshMacs;
    }

    public final boolean hasTlsCiphers() {
        return this.tlsCiphers != null && !(this.tlsCiphers instanceof SdkAutoConstructList);
    }

    public final List<String> tlsCiphers() {
        return this.tlsCiphers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fips());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshCiphers() ? this.sshCiphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshKexs() ? this.sshKexs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshMacs() ? this.sshMacs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTlsCiphers() ? this.tlsCiphers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedSecurityPolicy)) {
            return false;
        }
        DescribedSecurityPolicy other = (DescribedSecurityPolicy)obj;
        return Objects.equals(this.fips(), other.fips()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName()) && this.hasSshCiphers() == other.hasSshCiphers() && Objects.equals(this.sshCiphers(), other.sshCiphers()) && this.hasSshKexs() == other.hasSshKexs() && Objects.equals(this.sshKexs(), other.sshKexs()) && this.hasSshMacs() == other.hasSshMacs() && Objects.equals(this.sshMacs(), other.sshMacs()) && this.hasTlsCiphers() == other.hasTlsCiphers() && Objects.equals(this.tlsCiphers(), other.tlsCiphers());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedSecurityPolicy").add("Fips", (Object)this.fips()).add("SecurityPolicyName", (Object)this.securityPolicyName()).add("SshCiphers", this.hasSshCiphers() ? this.sshCiphers() : null).add("SshKexs", this.hasSshKexs() ? this.sshKexs() : null).add("SshMacs", this.hasSshMacs() ? this.sshMacs() : null).add("TlsCiphers", this.hasTlsCiphers() ? this.tlsCiphers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fips": {
                return Optional.ofNullable(clazz.cast(this.fips()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
            case "SshCiphers": {
                return Optional.ofNullable(clazz.cast(this.sshCiphers()));
            }
            case "SshKexs": {
                return Optional.ofNullable(clazz.cast(this.sshKexs()));
            }
            case "SshMacs": {
                return Optional.ofNullable(clazz.cast(this.sshMacs()));
            }
            case "TlsCiphers": {
                return Optional.ofNullable(clazz.cast(this.tlsCiphers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedSecurityPolicy, T> g) {
        return obj -> g.apply((DescribedSecurityPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean fips;
        private String securityPolicyName;
        private List<String> sshCiphers = DefaultSdkAutoConstructList.getInstance();
        private List<String> sshKexs = DefaultSdkAutoConstructList.getInstance();
        private List<String> sshMacs = DefaultSdkAutoConstructList.getInstance();
        private List<String> tlsCiphers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedSecurityPolicy model) {
            this.fips(model.fips);
            this.securityPolicyName(model.securityPolicyName);
            this.sshCiphers(model.sshCiphers);
            this.sshKexs(model.sshKexs);
            this.sshMacs(model.sshMacs);
            this.tlsCiphers(model.tlsCiphers);
        }

        public final Boolean getFips() {
            return this.fips;
        }

        @Override
        public final Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public final void setFips(Boolean fips) {
            this.fips = fips;
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        public final Collection<String> getSshCiphers() {
            if (this.sshCiphers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshCiphers;
        }

        @Override
        public final Builder sshCiphers(Collection<String> sshCiphers) {
            this.sshCiphers = SecurityPolicyOptionsCopier.copy(sshCiphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshCiphers(String ... sshCiphers) {
            this.sshCiphers(Arrays.asList(sshCiphers));
            return this;
        }

        public final void setSshCiphers(Collection<String> sshCiphers) {
            this.sshCiphers = SecurityPolicyOptionsCopier.copy(sshCiphers);
        }

        public final Collection<String> getSshKexs() {
            if (this.sshKexs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshKexs;
        }

        @Override
        public final Builder sshKexs(Collection<String> sshKexs) {
            this.sshKexs = SecurityPolicyOptionsCopier.copy(sshKexs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshKexs(String ... sshKexs) {
            this.sshKexs(Arrays.asList(sshKexs));
            return this;
        }

        public final void setSshKexs(Collection<String> sshKexs) {
            this.sshKexs = SecurityPolicyOptionsCopier.copy(sshKexs);
        }

        public final Collection<String> getSshMacs() {
            if (this.sshMacs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshMacs;
        }

        @Override
        public final Builder sshMacs(Collection<String> sshMacs) {
            this.sshMacs = SecurityPolicyOptionsCopier.copy(sshMacs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshMacs(String ... sshMacs) {
            this.sshMacs(Arrays.asList(sshMacs));
            return this;
        }

        public final void setSshMacs(Collection<String> sshMacs) {
            this.sshMacs = SecurityPolicyOptionsCopier.copy(sshMacs);
        }

        public final Collection<String> getTlsCiphers() {
            if (this.tlsCiphers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tlsCiphers;
        }

        @Override
        public final Builder tlsCiphers(Collection<String> tlsCiphers) {
            this.tlsCiphers = SecurityPolicyOptionsCopier.copy(tlsCiphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCiphers(String ... tlsCiphers) {
            this.tlsCiphers(Arrays.asList(tlsCiphers));
            return this;
        }

        public final void setTlsCiphers(Collection<String> tlsCiphers) {
            this.tlsCiphers = SecurityPolicyOptionsCopier.copy(tlsCiphers);
        }

        public DescribedSecurityPolicy build() {
            return new DescribedSecurityPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedSecurityPolicy> {
        public Builder fips(Boolean var1);

        public Builder securityPolicyName(String var1);

        public Builder sshCiphers(Collection<String> var1);

        public Builder sshCiphers(String ... var1);

        public Builder sshKexs(Collection<String> var1);

        public Builder sshKexs(String ... var1);

        public Builder sshMacs(Collection<String> var1);

        public Builder sshMacs(String ... var1);

        public Builder tlsCiphers(Collection<String> var1);

        public Builder tlsCiphers(String ... var1);
    }
}

