/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AssetSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetsResponse;

public class ListAssetsIterable
implements SdkIterable<ListAssetsResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetsIterable(IoTSiteWiseClient client, ListAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssetsResponseFetcher();
    }

    public Iterator<ListAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetSummary> assetSummaries() {
        Function<ListAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetSummaries() != null) {
                return response.assetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetsResponseFetcher
    implements SyncPageFetcher<ListAssetsResponse> {
        private ListAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetsResponse nextPage(ListAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetsIterable.this.client.listAssets(ListAssetsIterable.this.firstRequest);
            }
            return ListAssetsIterable.this.client.listAssets((ListAssetsRequest)((Object)ListAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

