/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.honeycode.model.DelimitedTextImportOptions;
import software.amazon.awssdk.services.honeycode.model.DestinationOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportOptions> {
    private static final SdkField<DestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationOptions").getter(ImportOptions.getter(ImportOptions::destinationOptions)).setter(ImportOptions.setter(Builder::destinationOptions)).constructor(DestinationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationOptions").build()}).build();
    private static final SdkField<DelimitedTextImportOptions> DELIMITED_TEXT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("delimitedTextOptions").getter(ImportOptions.getter(ImportOptions::delimitedTextOptions)).setter(ImportOptions.setter(Builder::delimitedTextOptions)).constructor(DelimitedTextImportOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimitedTextOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_OPTIONS_FIELD, DELIMITED_TEXT_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DestinationOptions destinationOptions;
    private final DelimitedTextImportOptions delimitedTextOptions;

    private ImportOptions(BuilderImpl builder) {
        this.destinationOptions = builder.destinationOptions;
        this.delimitedTextOptions = builder.delimitedTextOptions;
    }

    public final DestinationOptions destinationOptions() {
        return this.destinationOptions;
    }

    public final DelimitedTextImportOptions delimitedTextOptions() {
        return this.delimitedTextOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimitedTextOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportOptions)) {
            return false;
        }
        ImportOptions other = (ImportOptions)obj;
        return Objects.equals(this.destinationOptions(), other.destinationOptions()) && Objects.equals(this.delimitedTextOptions(), other.delimitedTextOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ImportOptions").add("DestinationOptions", (Object)this.destinationOptions()).add("DelimitedTextOptions", (Object)this.delimitedTextOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationOptions": {
                return Optional.ofNullable(clazz.cast(this.destinationOptions()));
            }
            case "delimitedTextOptions": {
                return Optional.ofNullable(clazz.cast(this.delimitedTextOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportOptions, T> g) {
        return obj -> g.apply((ImportOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DestinationOptions destinationOptions;
        private DelimitedTextImportOptions delimitedTextOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportOptions model) {
            this.destinationOptions(model.destinationOptions);
            this.delimitedTextOptions(model.delimitedTextOptions);
        }

        public final DestinationOptions.Builder getDestinationOptions() {
            return this.destinationOptions != null ? this.destinationOptions.toBuilder() : null;
        }

        @Override
        public final Builder destinationOptions(DestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final void setDestinationOptions(DestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        public final DelimitedTextImportOptions.Builder getDelimitedTextOptions() {
            return this.delimitedTextOptions != null ? this.delimitedTextOptions.toBuilder() : null;
        }

        @Override
        public final Builder delimitedTextOptions(DelimitedTextImportOptions delimitedTextOptions) {
            this.delimitedTextOptions = delimitedTextOptions;
            return this;
        }

        public final void setDelimitedTextOptions(DelimitedTextImportOptions.BuilderImpl delimitedTextOptions) {
            this.delimitedTextOptions = delimitedTextOptions != null ? delimitedTextOptions.build() : null;
        }

        public ImportOptions build() {
            return new ImportOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportOptions> {
        public Builder destinationOptions(DestinationOptions var1);

        default public Builder destinationOptions(Consumer<DestinationOptions.Builder> destinationOptions) {
            return this.destinationOptions((DestinationOptions)((DestinationOptions.Builder)DestinationOptions.builder().applyMutation(destinationOptions)).build());
        }

        public Builder delimitedTextOptions(DelimitedTextImportOptions var1);

        default public Builder delimitedTextOptions(Consumer<DelimitedTextImportOptions.Builder> delimitedTextOptions) {
            return this.delimitedTextOptions((DelimitedTextImportOptions)((DelimitedTextImportOptions.Builder)DelimitedTextImportOptions.builder().applyMutation(delimitedTextOptions)).build());
        }
    }
}

