/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentType {
    NEW_DEPLOYMENT("NewDeployment"),
    REDEPLOYMENT("Redeployment"),
    RESET_DEPLOYMENT("ResetDeployment"),
    FORCE_RESET_DEPLOYMENT("ForceResetDeployment"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentType> knownValues() {
        return Stream.of(DeploymentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

