/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse;

public class GetBatchPredictionJobsPublisher
implements SdkPublisher<GetBatchPredictionJobsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetBatchPredictionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBatchPredictionJobsPublisher(FraudDetectorAsyncClient client, GetBatchPredictionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBatchPredictionJobsPublisher(FraudDetectorAsyncClient client, GetBatchPredictionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBatchPredictionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBatchPredictionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetBatchPredictionJobsResponseFetcher
    implements AsyncPageFetcher<GetBatchPredictionJobsResponse> {
        private GetBatchPredictionJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetBatchPredictionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBatchPredictionJobsResponse> nextPage(GetBatchPredictionJobsResponse previousPage) {
            if (previousPage == null) {
                return GetBatchPredictionJobsPublisher.this.client.getBatchPredictionJobs(GetBatchPredictionJobsPublisher.this.firstRequest);
            }
            return GetBatchPredictionJobsPublisher.this.client.getBatchPredictionJobs((GetBatchPredictionJobsRequest)((Object)GetBatchPredictionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

