/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ListOfModelScoresCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfRuleResultsCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelScores;
import software.amazon.awssdk.services.frauddetector.model.RuleResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventPredictionResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetEventPredictionResponse> {
    private static final SdkField<List<ModelScores>> MODEL_SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelScores").getter(GetEventPredictionResponse.getter(GetEventPredictionResponse::modelScores)).setter(GetEventPredictionResponse.setter(Builder::modelScores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelScores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelScores::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RuleResult>> RULE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleResults").getter(GetEventPredictionResponse.getter(GetEventPredictionResponse::ruleResults)).setter(GetEventPredictionResponse.setter(Builder::ruleResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_SCORES_FIELD, RULE_RESULTS_FIELD));
    private final List<ModelScores> modelScores;
    private final List<RuleResult> ruleResults;

    private GetEventPredictionResponse(BuilderImpl builder) {
        super(builder);
        this.modelScores = builder.modelScores;
        this.ruleResults = builder.ruleResults;
    }

    public final boolean hasModelScores() {
        return this.modelScores != null && !(this.modelScores instanceof SdkAutoConstructList);
    }

    public final List<ModelScores> modelScores() {
        return this.modelScores;
    }

    public final boolean hasRuleResults() {
        return this.ruleResults != null && !(this.ruleResults instanceof SdkAutoConstructList);
    }

    public final List<RuleResult> ruleResults() {
        return this.ruleResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelScores() ? this.modelScores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleResults() ? this.ruleResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionResponse)) {
            return false;
        }
        GetEventPredictionResponse other = (GetEventPredictionResponse)((Object)obj);
        return this.hasModelScores() == other.hasModelScores() && Objects.equals(this.modelScores(), other.modelScores()) && this.hasRuleResults() == other.hasRuleResults() && Objects.equals(this.ruleResults(), other.ruleResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventPredictionResponse").add("ModelScores", this.hasModelScores() ? this.modelScores() : null).add("RuleResults", this.hasRuleResults() ? this.ruleResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelScores": {
                return Optional.ofNullable(clazz.cast(this.modelScores()));
            }
            case "ruleResults": {
                return Optional.ofNullable(clazz.cast(this.ruleResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionResponse, T> g) {
        return obj -> g.apply((GetEventPredictionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<ModelScores> modelScores = DefaultSdkAutoConstructList.getInstance();
        private List<RuleResult> ruleResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionResponse model) {
            super(model);
            this.modelScores(model.modelScores);
            this.ruleResults(model.ruleResults);
        }

        public final List<ModelScores.Builder> getModelScores() {
            List<ModelScores.Builder> result = ListOfModelScoresCopier.copyToBuilder(this.modelScores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder modelScores(Collection<ModelScores> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copy(modelScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(ModelScores ... modelScores) {
            this.modelScores(Arrays.asList(modelScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(Consumer<ModelScores.Builder> ... modelScores) {
            this.modelScores(Stream.of(modelScores).map(c -> (ModelScores)((ModelScores.Builder)ModelScores.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelScores(Collection<ModelScores.BuilderImpl> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copyFromBuilder(modelScores);
        }

        public final List<RuleResult.Builder> getRuleResults() {
            List<RuleResult.Builder> result = ListOfRuleResultsCopier.copyToBuilder(this.ruleResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ruleResults(Collection<RuleResult> ruleResults) {
            this.ruleResults = ListOfRuleResultsCopier.copy(ruleResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(RuleResult ... ruleResults) {
            this.ruleResults(Arrays.asList(ruleResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(Consumer<RuleResult.Builder> ... ruleResults) {
            this.ruleResults(Stream.of(ruleResults).map(c -> (RuleResult)((RuleResult.Builder)RuleResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuleResults(Collection<RuleResult.BuilderImpl> ruleResults) {
            this.ruleResults = ListOfRuleResultsCopier.copyFromBuilder(ruleResults);
        }

        @Override
        public GetEventPredictionResponse build() {
            return new GetEventPredictionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventPredictionResponse> {
        public Builder modelScores(Collection<ModelScores> var1);

        public Builder modelScores(ModelScores ... var1);

        public Builder modelScores(Consumer<ModelScores.Builder> ... var1);

        public Builder ruleResults(Collection<RuleResult> var1);

        public Builder ruleResults(RuleResult ... var1);

        public Builder ruleResults(Consumer<RuleResult.Builder> ... var1);
    }
}

