/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityConfigurationsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
    private static final SdkField<List<SecurityConfigurationSummary>> SECURITY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityConfigurations").getter(ListSecurityConfigurationsResponse.getter(ListSecurityConfigurationsResponse::securityConfigurations)).setter(ListSecurityConfigurationsResponse.setter(Builder::securityConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListSecurityConfigurationsResponse.getter(ListSecurityConfigurationsResponse::marker)).setter(ListSecurityConfigurationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIGURATIONS_FIELD, MARKER_FIELD));
    private final List<SecurityConfigurationSummary> securityConfigurations;
    private final String marker;

    private ListSecurityConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.securityConfigurations = builder.securityConfigurations;
        this.marker = builder.marker;
    }

    public final boolean hasSecurityConfigurations() {
        return this.securityConfigurations != null && !(this.securityConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SecurityConfigurationSummary> securityConfigurations() {
        return this.securityConfigurations;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityConfigurations() ? this.securityConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigurationsResponse)) {
            return false;
        }
        ListSecurityConfigurationsResponse other = (ListSecurityConfigurationsResponse)((Object)obj);
        return this.hasSecurityConfigurations() == other.hasSecurityConfigurations() && Objects.equals(this.securityConfigurations(), other.securityConfigurations()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityConfigurationsResponse").add("SecurityConfigurations", this.hasSecurityConfigurations() ? this.securityConfigurations() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityConfigurations": {
                return Optional.ofNullable(clazz.cast(this.securityConfigurations()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSecurityConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<SecurityConfigurationSummary> securityConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityConfigurationsResponse model) {
            super(model);
            this.securityConfigurations(model.securityConfigurations);
            this.marker(model.marker);
        }

        public final List<SecurityConfigurationSummary.Builder> getSecurityConfigurations() {
            List<SecurityConfigurationSummary.Builder> result = SecurityConfigurationListCopier.copyToBuilder(this.securityConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder securityConfigurations(Collection<SecurityConfigurationSummary> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copy(securityConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(SecurityConfigurationSummary ... securityConfigurations) {
            this.securityConfigurations(Arrays.asList(securityConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(Consumer<SecurityConfigurationSummary.Builder> ... securityConfigurations) {
            this.securityConfigurations(Stream.of(securityConfigurations).map(c -> (SecurityConfigurationSummary)((SecurityConfigurationSummary.Builder)SecurityConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityConfigurations(Collection<SecurityConfigurationSummary.BuilderImpl> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copyFromBuilder(securityConfigurations);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListSecurityConfigurationsResponse build() {
            return new ListSecurityConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityConfigurationsResponse> {
        public Builder securityConfigurations(Collection<SecurityConfigurationSummary> var1);

        public Builder securityConfigurations(SecurityConfigurationSummary ... var1);

        public Builder securityConfigurations(Consumer<SecurityConfigurationSummary.Builder> ... var1);

        public Builder marker(String var1);
    }
}

